/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.gui.CapeSelectionScreen;
import com.quickskin.mod.gui.PlayerWidget;
import com.quickskin.mod.gui.list.SkinEntry;
import com.quickskin.mod.gui.list.SkinList;
import com.quickskin.mod.gui.logic.SkinMenuLogicHandler;
import com.quickskin.mod.gui.utils.GuiScaleManager;
import com.quickskin.mod.gui.widgets.LinkButton;
import com.quickskin.mod.util.KnownCapes;
import com.quickskin.mod.util.SkinData;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class PlayerSkinMenuScreen
extends Screen {
    private final Screen parent;
    @Nullable
    private final PlayerWidget playerWidget;
    private final SkinMenuLogicHandler logicHandler;
    private final boolean renderPanorama;
    private EditBox usernameBox;
    private SkinList skinList;
    private Button applyButton;
    private Button addButton;
    private Button classicModelButton;
    private Button slimModelButton;
    private Button capeSelectionButton;
    private Button rotateButton;
    private boolean isApplyingSkin = false;
    private String loadingMessage = "";
    private int searchDelayTicks = 0;
    private static final int SEARCH_DELAY = 10;
    private String lastPreviewedUsername = "";
    private Tooltip nextTooltip;
    private boolean suppressUsernameChangeEvent = false;
    private PanoramaRenderer panorama;
    private static final int MIN_PANEL_WIDTH = 340;
    private static final int MAX_PANEL_WIDTH = 500;
    private static final int MIN_PANEL_HEIGHT = 280;
    private static final float PANEL_WIDTH_RATIO = 0.5f;
    private static final float PANEL_HEIGHT_RATIO = 0.8f;
    private static final float LEFT_PANEL_RATIO = 0.6f;
    private static final float RIGHT_PANEL_RATIO = 0.35f;
    private static final int PADDING = 6;
    private static final int SPACING = 4;
    private static final int COMPONENT_HEIGHT = 20;
    private int panelWidth;
    private int panelHeight;
    private int panelX;
    private int panelY;
    private int leftPanelWidth;
    private int rightPanelWidth;
    private int scaledPadding;
    private int scaledSpacing;
    private int scaledComponentHeight;
    private static final ResourceLocation DISCORD_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/discord_icon.png");
    private static final ResourceLocation CURSEFORGE_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/curseforge_icon.png");
    private static final ResourceLocation MODRINTH_ICON = ResourceLocation.fromNamespaceAndPath((String)"quickskin", (String)"textures/gui/modrinth_icon.png");
    private static final String DISCORD_URL = "https://discord.gg/yGxdvA7qej";
    private static final String CURSEFORGE_URL = "https://www.curseforge.com/minecraft/mc-mods/quick-skin";
    private static final String MODRINTH_URL = "https://modrinth.com/mod/quick-skin";
    private boolean firstInit = true;

    public PlayerSkinMenuScreen(Screen parent, @Nullable PlayerWidget playerWidget) {
        super((Component)Component.m_237113_((String)"Change Player Skin"));
        this.parent = parent;
        this.playerWidget = playerWidget;
        this.logicHandler = new SkinMenuLogicHandler(this);
        this.renderPanorama = parent instanceof TitleScreen;
        if (this.renderPanorama) {
            try {
                Field panoramaField = TitleScreen.class.getDeclaredField("panorama");
                panoramaField.setAccessible(true);
                this.panorama = (PanoramaRenderer)panoramaField.get(parent);
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Could not get panorama from TitleScreen, creating a new one.", (Throwable)e);
                this.panorama = new PanoramaRenderer(new CubeMap(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/title/background/panorama")));
            }
        } else {
            this.panorama = new PanoramaRenderer(new CubeMap(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/title/background/panorama")));
        }
    }

    protected void m_7856_() {
        if (this.firstInit) {
            this.firstInit = false;
            if (GuiScaleManager.setMenuGuiScale(GuiScaleManager.getOptimalMenuScale())) {
                return;
            }
        }
        super.m_7856_();
        boolean hasGeckoPreview = this.playerWidget != null;
        this.calculateAdaptiveDimensions();
        this.panelX = (this.f_96543_ - this.panelWidth) / 2;
        this.panelY = (this.f_96544_ - this.panelHeight) / 2;
        if (hasGeckoPreview) {
            this.leftPanelWidth = (int)((float)this.panelWidth * 0.6f);
            this.rightPanelWidth = (int)((float)this.panelWidth * 0.35f);
        } else {
            this.leftPanelWidth = this.panelWidth - this.scaledPadding * 2;
            this.rightPanelWidth = 0;
        }
        int topSectionHeight = this.scaledPadding + this.scaledComponentHeight + this.scaledPadding + this.scaledComponentHeight + this.scaledSpacing;
        int bottomSectionHeight = hasGeckoPreview ? this.scaledComponentHeight * 3 + this.scaledSpacing * 2 + this.scaledPadding : this.scaledComponentHeight * 2 + this.scaledSpacing + this.scaledPadding;
        int listHeight = this.panelHeight - topSectionHeight - bottomSectionHeight;
        int componentX = this.panelX + this.scaledPadding;
        int yPos = this.panelY + this.scaledPadding + this.scaledComponentHeight + this.scaledPadding;
        int addButtonWidth = this.scaledComponentHeight;
        int usernameBoxWidth = this.leftPanelWidth - addButtonWidth - this.scaledSpacing;
        this.usernameBox = new EditBox(this.f_96547_, componentX, yPos, usernameBoxWidth, this.scaledComponentHeight, (Component)Component.m_237113_((String)"Skin Username"));
        this.usernameBox.m_94151_(this::onUsernameBoxChanged);
        this.m_142416_((GuiEventListener)this.usernameBox);
        this.addButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> this.logicHandler.addOrUpdateSkinInList()).m_252987_(componentX + usernameBoxWidth + this.scaledSpacing, yPos, addButtonWidth, this.scaledComponentHeight).m_253136_());
        this.skinList = new SkinList(this, this.f_96541_, this.leftPanelWidth, listHeight, yPos += this.scaledComponentHeight + this.scaledSpacing, 40);
        this.skinList.m_93488_(false);
        this.skinList.m_93496_(false);
        this.skinList.m_93507_(componentX);
        this.m_142416_((GuiEventListener)this.skinList);
        int bottomY = this.panelY + this.panelHeight - this.scaledPadding;
        int fullWidthX = this.panelX + this.scaledPadding;
        int fullComponentWidth = this.panelWidth - this.scaledPadding * 2;
        this.applyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.m_7379_()).m_252987_(fullWidthX, bottomY -= this.scaledComponentHeight, fullComponentWidth, this.scaledComponentHeight).m_253136_());
        int fourButtonWidth = (fullComponentWidth - this.scaledSpacing * 3) / 4;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Import Skin"), button -> this.openFileDialog()).m_252987_(fullWidthX, bottomY -= this.scaledComponentHeight + this.scaledSpacing, fourButtonWidth, this.scaledComponentHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"HD Skin Website"), button -> Util.m_137581_().m_137646_("https://mcskins.top/128x128/")).m_252987_(fullWidthX + fourButtonWidth + this.scaledSpacing, bottomY, fourButtonWidth, this.scaledComponentHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Skin Website"), button -> Util.m_137581_().m_137646_("https://laby.net/skins?order=trending_30d")).m_252987_(fullWidthX + (fourButtonWidth + this.scaledSpacing) * 2, bottomY, fourButtonWidth, this.scaledComponentHeight).m_253136_());
        this.capeSelectionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.f_96541_.m_91152_((Screen)new CapeSelectionScreen(this, this.logicHandler.getCurrentSkinData().getCapeUsername(), this.logicHandler::setCape, this.renderPanorama, this.panorama))).m_252987_(fullWidthX + (fourButtonWidth + this.scaledSpacing) * 3, bottomY, fourButtonWidth, this.scaledComponentHeight).m_253136_());
        if (hasGeckoPreview) {
            int modelButtonsX = fullWidthX + (fourButtonWidth + this.scaledSpacing) * 3;
            int modelButtonsTotalWidth = fourButtonWidth;
            int modelButtonWidth = (modelButtonsTotalWidth - this.scaledSpacing) / 2;
            this.classicModelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Classic"), b -> this.logicHandler.setModel("default")).m_252987_(modelButtonsX, bottomY -= this.scaledComponentHeight + this.scaledSpacing, modelButtonWidth, this.scaledComponentHeight).m_253136_());
            this.slimModelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Slim"), b -> this.logicHandler.setModel("slim")).m_252987_(modelButtonsX + modelButtonWidth + this.scaledSpacing, bottomY, modelButtonWidth, this.scaledComponentHeight).m_253136_());
            int availableHeightForWidget = this.classicModelButton.m_252907_() - yPos - this.scaledPadding;
            int widgetSize = Math.min(144, Math.min(availableHeightForWidget, this.rightPanelWidth));
            int rightPanelCenterX = modelButtonsX + modelButtonsTotalWidth / 2;
            int widgetX = rightPanelCenterX - widgetSize / 2;
            int yPaddingAboveButtons = -35;
            int widgetY = this.classicModelButton.m_252907_() - widgetSize + 25 - yPaddingAboveButtons;
            this.playerWidget.m_252865_(widgetX + 20);
            this.playerWidget.m_253211_(widgetY);
            this.playerWidget.m_93674_(widgetSize);
            this.playerWidget.setHeight(widgetSize);
            this.m_142416_((GuiEventListener)this.playerWidget);
            int rotateButtonSize = 20;
            int rightPanelEdgeX = this.panelX + this.panelWidth - this.scaledPadding;
            int rotateButtonX = rightPanelEdgeX - rotateButtonSize;
            int rotateButtonY = this.classicModelButton.m_252907_() - rotateButtonSize - this.scaledSpacing;
            Button.OnPress onPress = b -> this.playerWidget.toggleRotation();
            MutableComponent buttonText = Component.m_237113_((String)"\u21ba");
            MutableComponent tooltipText = Component.m_237113_((String)"Rotate Preview");
            Button.CreateNarration createNarration = Supplier::get;
            this.rotateButton = (Button)this.m_142416_((GuiEventListener)new Button(rotateButtonX, rotateButtonY, rotateButtonSize, rotateButtonSize, (Component)buttonText, onPress, createNarration){

                public void m_280139_(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                    Component message = this.m_6035_();
                    PoseStack poseStack = pGuiGraphics.m_280168_();
                    poseStack.m_85836_();
                    float scale = 2.8f;
                    float textWidth = pFont.m_92852_((FormattedText)message);
                    poseStack.m_252880_((float)this.m_252754_() + (float)this.m_5711_() / 1.8f, (float)this.m_252907_() + (float)this.m_93694_() / 4.0f, 0.0f);
                    poseStack.m_85841_(scale, scale, 1.0f);
                    int n = (int)(-textWidth / 2.0f);
                    Objects.requireNonNull(pFont);
                    pGuiGraphics.m_280430_(pFont, message, n, (int)((float)(-9) / 2.0f + 1.0f), pColor);
                    poseStack.m_85849_();
                }
            });
            this.rotateButton.m_257544_(Tooltip.m_257550_((Component)tooltipText));
        }
        int buttonSize = this.scaledComponentHeight;
        int linkButtonY = this.panelY + this.scaledPadding;
        int discordButtonX = this.panelX + this.panelWidth - buttonSize - this.scaledPadding;
        this.m_142416_((GuiEventListener)new LinkButton(discordButtonX, linkButtonY, buttonSize, buttonSize, DISCORD_ICON, DISCORD_URL, (Component)Component.m_237113_((String)"Join our Discord!")));
        int curseforgeButtonX = discordButtonX - buttonSize - this.scaledSpacing;
        this.m_142416_((GuiEventListener)new LinkButton(curseforgeButtonX, linkButtonY, buttonSize, buttonSize, CURSEFORGE_ICON, CURSEFORGE_URL, (Component)Component.m_237113_((String)"Visit our CurseForge page")));
        int modrinthButtonX = curseforgeButtonX - buttonSize - this.scaledSpacing;
        this.m_142416_((GuiEventListener)new LinkButton(modrinthButtonX, linkButtonY, buttonSize, buttonSize, MODRINTH_ICON, MODRINTH_URL, (Component)Component.m_237113_((String)"Visit our Modrinth page")));
        this.refreshSkinList();
        this.selectSkinInList(this.logicHandler.getCurrentSkinData().getUsername());
    }

    private void calculateAdaptiveDimensions() {
        int minRequiredWidth;
        this.panelWidth = Mth.m_14045_((int)((int)((float)this.f_96543_ * 0.5f)), (int)340, (int)Math.min(500, this.f_96543_ - 40));
        this.panelHeight = Mth.m_14045_((int)((int)((float)this.f_96544_ * 0.8f)), (int)280, (int)(this.f_96544_ - 40));
        float scaleFactor = this.getScaleFactor();
        this.scaledPadding = Math.max(4, (int)(6.0f * scaleFactor));
        this.scaledSpacing = Math.max(2, (int)(4.0f * scaleFactor));
        this.scaledComponentHeight = Math.max(16, Math.min(24, (int)(20.0f * scaleFactor)));
        int minRequiredHeight = this.calculateMinRequiredHeight();
        if (this.panelHeight < minRequiredHeight) {
            this.panelHeight = Math.min(minRequiredHeight, this.f_96544_ - 20);
        }
        if (this.panelWidth < (minRequiredWidth = this.calculateMinRequiredWidth())) {
            this.panelWidth = Math.min(minRequiredWidth, this.f_96543_ - 20);
        }
    }

    private float getScaleFactor() {
        float screenFactor;
        int guiScale = (int)this.f_96541_.m_91268_().m_85449_();
        float scaleFactor = screenFactor = Math.min((float)this.f_96543_ / 854.0f, (float)this.f_96544_ / 480.0f);
        if (guiScale == 1) {
            scaleFactor *= 0.75f;
        } else if (guiScale == 3 || guiScale == 4) {
            scaleFactor *= 1.25f;
        }
        return Mth.m_14036_((float)scaleFactor, (float)0.75f, (float)1.5f);
    }

    private int calculateMinRequiredHeight() {
        return this.scaledPadding * 4 + this.scaledComponentHeight * 7 + this.scaledSpacing * 4 + 120;
    }

    private int calculateMinRequiredWidth() {
        return 370 + this.scaledPadding * 3 + this.scaledSpacing * 2;
    }

    public SkinList getSkinList() {
        return this.skinList;
    }

    public boolean isApplyingSkin() {
        return this.isApplyingSkin;
    }

    public String getUsernameBoxValue() {
        return this.usernameBox.m_94155_();
    }

    public void setUsernameBoxValue(String value) {
        this.suppressUsernameChangeEvent = true;
        this.usernameBox.m_94144_(value);
        this.suppressUsernameChangeEvent = false;
    }

    @Nullable
    public SkinEntry getSelectedEntry() {
        return (SkinEntry)this.skinList.m_93511_();
    }

    public void setSelectedEntry(@Nullable SkinEntry entry) {
        this.skinList.m_6987_((AbstractSelectionList.Entry)entry);
    }

    @Nullable
    public SkinEntry findEntry(Predicate<SkinEntry> predicate) {
        return this.skinList.m_6702_().stream().filter(predicate).findFirst().orElse(null);
    }

    public void setTooltip(Tooltip tooltip) {
        this.nextTooltip = tooltip;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void m_7400_(List<Path> paths) {
        this.logicHandler.handleFileDrop(paths);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchDelayTicks > 0 && --this.searchDelayTicks == 0 && !this.usernameBox.m_94155_().isBlank() && !this.usernameBox.m_94155_().equalsIgnoreCase(this.lastPreviewedUsername)) {
            this.updatePreview();
        }
    }

    public void schedulePreviewUpdate() {
        this.searchDelayTicks = 10;
    }

    public void onSkinSelected(@Nullable SkinEntry entry) {
        this.logicHandler.onSkinSelected(entry);
    }

    public void onUsernameBoxChanged(String username) {
        if (!this.suppressUsernameChangeEvent) {
            this.logicHandler.onUsernameBoxChanged(username);
        }
    }

    public void removeSkinFromList(SkinData skinData) {
        this.logicHandler.removeSkinFromList(skinData);
    }

    public void renameSkinFile(String newName) {
        if (this.getSelectedEntry() != null) {
            this.logicHandler.renameLocalSkin(this.getSelectedEntry().getSkinData(), newName);
        }
    }

    public void refreshSkinList() {
        boolean activeSkinIsSaved;
        ArrayList<String> savedSkins = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        SkinData activeSkinFromConfig = SkinData.fromString((String)Config.ACTIVE_SKIN.get());
        if (!activeSkinFromConfig.getUsername().isBlank() && !(activeSkinIsSaved = savedSkins.stream().anyMatch(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(activeSkinFromConfig.getUsername())))) {
            savedSkins.add(activeSkinFromConfig.toEncodedString());
        }
        this.skinList.clear();
        Map<String, String> localSkinNames = LocalSkinManager.INSTANCE.discoverLocalAssets().stream().filter(a -> "skin".equals(a.type())).collect(Collectors.toMap(a -> "local_skin:" + a.hash(), LocalSkinManager.LocalAsset::friendlyName, (n1, n2) -> n1));
        ArrayList updatedConfigListForSync = new ArrayList();
        savedSkins.stream().map(SkinData::fromString).map(sd -> {
            String name;
            if (sd.getUsername().startsWith("local_skin:") && (name = (String)localSkinNames.get(sd.getUsername())) != null && !name.equals(sd.getFriendlyName())) {
                return new SkinData(sd.getUsername(), sd.getModel(), sd.getCapeUsername(), name);
            }
            return sd;
        }).peek(sd -> updatedConfigListForSync.add(sd.toEncodedString())).map(sd -> new SkinEntry(this, (SkinData)sd)).sorted((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getSortName(), b.getSortName())).forEach(this.skinList::addEntry);
        Config.SAVED_SKINS.set(updatedConfigListForSync);
        Config.SAVED_SKINS.save();
    }

    public void selectSkinInList(String skinUsername) {
        SkinEntry entry = this.findEntry(e -> e.getSkinData().getUsername().equalsIgnoreCase(skinUsername));
        this.skinList.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.skinList.makeVisible(entry);
            this.onSkinSelected(entry);
        } else {
            this.onSkinSelected(null);
        }
    }

    public void updateAllWidgets() {
        this.setUsernameBoxValue(this.logicHandler.getCurrentSkinData().getDisplayName());
        if (this.playerWidget != null) {
            this.updateModelButtons();
        }
        this.updateApplyButtonState();
        this.updateAddButtonState();
        this.updateCapeButtonText();
    }

    public void updatePreviewImmediately() {
        if (this.playerWidget == null) {
            return;
        }
        this.searchDelayTicks = 0;
        this.updatePreview();
    }

    private void updateModelButtons() {
        boolean canInteract;
        SkinData currentData = this.logicHandler.getCurrentSkinData();
        boolean bl = canInteract = !currentData.getUsername().isBlank() && !this.isApplyingSkin;
        if (this.classicModelButton != null && this.slimModelButton != null) {
            this.classicModelButton.f_93623_ = canInteract && "slim".equalsIgnoreCase(currentData.getModel());
            this.slimModelButton.f_93623_ = canInteract && !"slim".equalsIgnoreCase(currentData.getModel());
            this.playerWidget.setModel(currentData.getModel());
        }
    }

    private void updateCapeButtonText() {
        KnownCapes cape;
        if (this.capeSelectionButton == null) {
            return;
        }
        String id = this.logicHandler.getCurrentSkinData().getCapeUsername();
        MutableComponent text = Component.m_237115_((String)"gui.quickskin.cape.default");
        if ("__NONE__".equals(id)) {
            text = Component.m_237115_((String)"gui.quickskin.cape.none");
        } else if (id.startsWith("local_cape:")) {
            text = Component.m_237113_((String)"Cape: ").m_7220_((Component)Component.m_237113_((String)"Local").m_130938_(s -> s.m_178520_(0x55FF55)));
        } else if (id.startsWith("KNOWN_CAPE:") && (cape = KnownCapes.getById(id.substring("KNOWN_CAPE:".length()))) != null) {
            text = Component.m_237113_((String)"Cape: ").m_7220_((Component)Component.m_237113_((String)cape.getDisplayName()).m_130938_(s -> s.m_178520_(0xFFFFAA)));
        }
        this.capeSelectionButton.m_93666_((Component)text);
    }

    private void updatePreview() {
        SkinData data = this.logicHandler.getCurrentSkinData();
        if (data.getUsername().isBlank()) {
            return;
        }
        if (this.playerWidget != null) {
            this.lastPreviewedUsername = data.getUsername();
            this.playerWidget.loadPlayerSkinWithRetry(data.getUsername(), data.getCapeUsername(), data.getModel(), null);
        }
    }

    private void updateApplyButtonState() {
        this.applyButton.f_93623_ = !this.isApplyingSkin;
        this.applyButton.m_93666_((Component)(this.isApplyingSkin ? Component.m_237113_((String)this.loadingMessage) : Component.m_237115_((String)"gui.done")));
    }

    private void updateAddButtonState() {
        boolean canAdd;
        this.addButton.f_93623_ = canAdd = !this.isApplyingSkin && !this.logicHandler.getCurrentSkinData().getUsername().isBlank();
    }

    public void setLoadingState(boolean loading, String message) {
        this.isApplyingSkin = loading;
        this.loadingMessage = message;
        this.usernameBox.m_94186_(!loading);
        this.skinList.m_93410_(this.skinList.m_93517_());
        this.updateAllWidgets();
    }

    private void openFileDialog() {
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.png")).flip();
                String file = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select Skin", (CharSequence)"", (PointerBuffer)filters, (CharSequence)"PNG Images", (boolean)false);
                if (file != null && !file.isEmpty()) {
                    this.logicHandler.handleFileSelection(Path.of(file, new String[0]));
                }
            }
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.nextTooltip = null;
        if (this.renderPanorama) {
            this.panorama.m_110003_(partialTicks, 1.0f);
            graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x70000000);
        } else {
            this.m_280273_(graphics);
        }
        graphics.m_280509_(this.panelX, this.panelY, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1879048192);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.panelY + this.scaledPadding, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.nextTooltip != null) {
            graphics.m_280245_(this.f_96547_, this.nextTooltip.m_257408_(this.f_96541_), mouseX, mouseY);
        }
    }

    public void m_7379_() {
        if (this.logicHandler != null) {
            this.logicHandler.savePendingChanges();
        }
        GuiScaleManager.restoreOriginalGuiScale();
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        SkinEntry selectedEntry = this.skinList != null ? (SkinEntry)this.skinList.m_93511_() : null;
        String textInBox = this.usernameBox != null ? this.usernameBox.m_94155_() : "";
        super.m_6574_(minecraft, width, height);
        if (selectedEntry != null) {
            this.selectSkinInList(selectedEntry.getSkinData().getUsername());
        } else if (!textInBox.isEmpty()) {
            this.usernameBox.m_94144_(textInBox);
        }
    }
}

