/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.client.geckolib.GeoCapeRenderer;
import com.quickskin.mod.client.geckolib.GeoPlayerEntity;
import com.quickskin.mod.client.geckolib.GeoPlayerRenderer;
import com.quickskin.mod.util.KnownCapes;
import com.quickskin.mod.util.SkinAPI;
import com.quickskin.mod.util.SkinData;
import com.quickskin.mod.util.SkinResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PlayerWidget
extends AbstractWidget {
    private GameProfile gameProfile;
    private ResourceLocation skinLocation;
    private ResourceLocation capeLocation;
    private String currentCapeId;
    private GeoPlayerEntity geoPlayerEntity;
    private GeoPlayerRenderer geoPlayerRenderer;
    private GeoPlayerEntity geoCapeEntity;
    private GeoCapeRenderer geoCapeRenderer;
    private boolean isLoadingSkin = false;
    private CompletableFuture<?> currentLoadTask = null;
    private boolean enableGeckoLibRendering = true;
    private String lastError = "";
    private LocalSkinManager.TextureQuality previewQuality = LocalSkinManager.TextureQuality.PREVIEW;
    private SkinResolution currentResolution = null;
    private float yRotation = 200.0f;
    private static final float FRONT_ROTATION = 200.0f;
    private static final float BACK_ROTATION = 20.0f;

    public PlayerWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        if (!QuickSkin.isGeckoLibLoaded) {
            this.enableGeckoLibRendering = false;
            this.lastError = "GeckoLib not loaded.";
            QuickSkin.LOGGER.error("PlayerWidget instantiated, but GeckoLib is not loaded. This should not happen and indicates a logic error elsewhere.");
            return;
        }
        try {
            this.initializeWidget();
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error in PlayerWidget constructor", (Throwable)e);
            this.enableGeckoLibRendering = false;
            this.lastError = "Constructor error: " + e.getMessage();
        }
    }

    private void initializeWidget() {
        Minecraft mc = Minecraft.m_91087_();
        SkinData activeSkin = SkinData.fromString((String)Config.ACTIVE_SKIN.get());
        UUID profileId = mc.m_91094_() != null ? mc.m_91094_().m_240411_() : Util.f_137441_;
        String profileName = mc.m_91094_() != null ? mc.m_91094_().m_92546_() : "Steve";
        this.gameProfile = new GameProfile(profileId, profileName);
        this.skinLocation = DefaultPlayerSkin.m_118627_((UUID)profileId);
        this.currentCapeId = activeSkin.getCapeUsername();
        try {
            QuickSkin.LOGGER.info("Initializing GeckoLib components...");
            this.geoPlayerEntity = new GeoPlayerEntity(this.skinLocation, activeSkin.getModel());
            this.geoPlayerRenderer = new GeoPlayerRenderer();
            this.geoCapeEntity = new GeoPlayerEntity(null, activeSkin.getModel());
            this.geoCapeRenderer = new GeoCapeRenderer();
            QuickSkin.LOGGER.info("GeckoLib components created successfully");
            if (this.geoPlayerEntity != null) {
                this.geoPlayerEntity.setAnimation((String)Config.ACTIVE_ANIMATION.get());
                QuickSkin.LOGGER.info("Set initial animation to '{}'", Config.ACTIVE_ANIMATION.get());
            }
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error initializing GeckoLib components", (Throwable)e);
            this.enableGeckoLibRendering = false;
            this.lastError = "GeckoLib init error: " + e.getMessage();
            return;
        }
        if (!activeSkin.getUsername().isBlank()) {
            QuickSkin.LOGGER.info("Loading configured skin: {}", (Object)activeSkin.toEncodedString());
            this.loadPlayerSkinWithRetry(activeSkin.getUsername(), activeSkin.getCapeUsername(), activeSkin.getModel(), null);
        } else {
            String currentUsername = mc.m_91094_() != null ? mc.m_91094_().m_92546_() : "Steve";
            QuickSkin.LOGGER.info("Loading default skin for '{}'", (Object)currentUsername);
            this.loadPlayerSkinWithRetry(currentUsername, "", "default", this::saveDefaultSkin);
        }
    }

    private void saveDefaultSkin(GameProfile gameProfile) {
        if (gameProfile != null) {
            QuickSkin.LOGGER.info("Saving default skin for user: {}", (Object)gameProfile.getName());
            SkinData defaultSkin = new SkinData(gameProfile.getName(), "slim", "", null);
            Config.ACTIVE_SKIN.set((Object)defaultSkin.toEncodedString());
            Config.ACTIVE_SKIN.save();
            ArrayList<String> savedSkins = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
            if (savedSkins.stream().noneMatch(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(gameProfile.getName()))) {
                savedSkins.add(defaultSkin.toEncodedString());
                Config.SAVED_SKINS.set(savedSkins);
                Config.SAVED_SKINS.save();
            }
        }
    }

    public void loadPlayerSkinWithRetry(String skinUsername, String capeId, String model, @Nullable Consumer<GameProfile> onLoadedCallback) {
        QuickSkin.LOGGER.info("loadPlayerSkinWithRetry called for skin: {}, cape: {}, model: {}", new Object[]{skinUsername, capeId, model});
        if (this.currentLoadTask != null && !this.currentLoadTask.isDone()) {
            QuickSkin.LOGGER.info("Cancelling previous load task");
            this.currentLoadTask.cancel(true);
        }
        this.isLoadingSkin = true;
        if (skinUsername != null && skinUsername.startsWith("local_skin:")) {
            this.currentLoadTask = CompletableFuture.runAsync(() -> {
                SkinResolution resolution;
                String hash = skinUsername.substring("local_skin:".length());
                this.currentResolution = resolution = LocalSkinManager.INSTANCE.getResolution(hash);
                LocalSkinManager.TextureQuality quality = LocalSkinManager.TextureQuality.PREVIEW;
                this.skinLocation = LocalSkinManager.INSTANCE.getTextureLocation(hash, quality);
                Minecraft.m_91087_().execute(() -> {
                    if (this.geoPlayerEntity != null) {
                        this.geoPlayerEntity.setSkinLocation(this.skinLocation);
                        this.geoPlayerEntity.setModelName(model);
                    }
                    this.processCapeById(capeId);
                    this.isLoadingSkin = false;
                    if (onLoadedCallback != null) {
                        onLoadedCallback.accept(null);
                    }
                });
            }, (Executor)Minecraft.m_91087_());
            return;
        }
        CompletableFuture<Object> skinFuture = skinUsername != null && !skinUsername.isBlank() ? SkinAPI.fetchProfile(skinUsername) : CompletableFuture.completedFuture(null);
        this.currentLoadTask = ((CompletableFuture)skinFuture.thenAcceptAsync(skinProfile -> Minecraft.m_91087_().execute(() -> {
            if (skinProfile != null) {
                this.processSkin((GameProfile)skinProfile, model);
                if (onLoadedCallback != null) {
                    onLoadedCallback.accept((GameProfile)skinProfile);
                }
            } else {
                this.handleSkinLoadFailure(onLoadedCallback);
            }
            this.processCapeById(capeId);
            this.isLoadingSkin = false;
        }), (Executor)Minecraft.m_91087_())).exceptionally(e -> {
            QuickSkin.LOGGER.error("Exception during skin/cape loading", e);
            this.handleSkinLoadFailure(onLoadedCallback);
            return null;
        });
    }

    private void processCapeById(String capeId) {
        this.currentCapeId = capeId;
        this.capeLocation = null;
        if (this.geoCapeEntity != null) {
            this.geoCapeEntity.setSkinLocation(null);
            this.geoCapeEntity.setCapeIdentifier(null);
        }
        if (capeId == null || capeId.isBlank() || capeId.equals("__NONE__")) {
            return;
        }
        if (capeId.startsWith("local_cape:")) {
            ClientSkinManager.getInstance().getCapeLocationForId(capeId);
        } else if (!capeId.startsWith("KNOWN_CAPE:")) {
            SkinAPI.fetchProfile(capeId).thenAccept(profileWithCape -> {
                if (profileWithCape != null) {
                    this.processCapeTexture((GameProfile)profileWithCape);
                }
            });
        }
    }

    private void handleSkinLoadFailure(@Nullable Consumer<GameProfile> onLoadedCallback) {
        Minecraft.m_91087_().execute(() -> {
            QuickSkin.LOGGER.info("Handling skin load failure, reverting to default");
            UUID defaultUuid = Util.f_137441_;
            this.skinLocation = DefaultPlayerSkin.m_118627_((UUID)defaultUuid);
            this.capeLocation = null;
            this.currentCapeId = null;
            if (this.geoPlayerEntity != null) {
                this.geoPlayerEntity.setSkinLocation(this.skinLocation);
            }
            if (this.geoCapeEntity != null) {
                this.geoCapeEntity.setSkinLocation(null);
                this.geoCapeEntity.setCapeIdentifier(null);
            }
            this.isLoadingSkin = false;
            if (onLoadedCallback != null) {
                onLoadedCallback.accept(null);
            }
        });
    }

    private void processSkin(GameProfile profile, String model) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, profileTexture) -> {
            if (type == MinecraftProfileTexture.Type.SKIN) {
                QuickSkin.LOGGER.info("Registered skin texture for {} at location: {}", (Object)profile.getName(), (Object)location);
                this.gameProfile = profile;
                this.skinLocation = location;
                if (this.geoPlayerEntity != null) {
                    this.geoPlayerEntity.setSkinLocation(location);
                    this.geoPlayerEntity.setModelName(model);
                }
            }
        }, true);
    }

    private void processCapeTexture(GameProfile profile) {
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, location, profileTexture) -> {
            if (type == MinecraftProfileTexture.Type.CAPE) {
                QuickSkin.LOGGER.info("Registered cape texture for {} at location: {}", (Object)profile.getName(), (Object)location);
                this.capeLocation = location;
                if (this.geoCapeEntity != null) {
                    this.geoCapeEntity.setSkinLocation(location);
                }
            }
        }, true);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.enableGeckoLibRendering) {
            try {
                this.renderGeckoModel(graphics, partialTicks);
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Error rendering GeckoLib model", (Throwable)e);
                this.enableGeckoLibRendering = false;
                this.lastError = "Render error: " + e.getMessage();
                this.renderFallback(graphics);
            }
        } else {
            this.renderFallback(graphics);
        }
        if (this.isLoadingSkin) {
            graphics.m_280137_(Minecraft.m_91087_().f_91062_, "Loading...", this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + this.m_93694_() - 10, 0xFFFFFF);
        }
        if (!this.enableGeckoLibRendering && !this.lastError.isEmpty()) {
            graphics.m_280137_(Minecraft.m_91087_().f_91062_, "Render Error", this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + this.m_93694_() - 25, 0xFF0000);
        }
    }

    private void renderFallback(GuiGraphics graphics) {
        int centerX = this.m_252754_() + this.m_5711_() / 2;
        int centerY = this.m_252907_() + this.m_93694_() / 2;
        graphics.m_280509_(centerX - 30, centerY - 40, centerX + 30, centerY + 40, -12303292);
        graphics.m_280137_(Minecraft.m_91087_().f_91062_, "Player", centerX, centerY, 0xFFFFFF);
    }

    public void renderGeckoModel(GuiGraphics graphics, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        if (this.geoPlayerEntity == null || this.geoPlayerRenderer == null || this.geoCapeEntity == null || this.geoCapeRenderer == null) {
            throw new RuntimeException("Rendering components are null");
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        try {
            boolean isSitting;
            float xOffset = 0.0f;
            if (Math.abs(this.yRotation - 20.0f) < 1.0f) {
                xOffset = -45.0f;
            }
            float scale = 75.0f;
            poseStack.m_85837_((double)this.m_252754_() + (double)this.m_5711_() / 2.0 + (double)xOffset, (double)(this.m_252907_() + this.m_93694_() - 25), 100.0);
            poseStack.m_85841_(scale, scale, -scale);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(this.yRotation));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = isSitting = this.geoPlayerEntity != null && "animation.player.seat_idle_detailed".equals(this.geoPlayerEntity.getCurrentAnimation());
            if (isSitting) {
                poseStack.m_85836_();
                BlockState stoneState = Blocks.f_50440_.m_49966_();
                poseStack.m_85841_(0.55f, 0.55f, 0.55f);
                poseStack.m_85837_((double)0.425f, (double)1.15f, 0.45);
                Minecraft.m_91087_().m_91289_().m_110912_(stoneState, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
            RenderSystem.setupGuiFlatDiffuseLighting((Vector3f)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f));
            RenderType renderType = RenderType.m_110470_((ResourceLocation)this.geoPlayerEntity.getSkinLocation());
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            try {
                this.geoPlayerRenderer.render(poseStack, this.geoPlayerEntity, (MultiBufferSource)buffer, renderType, vertexConsumer, 0xF000F0);
            }
            catch (NullPointerException npe) {
                QuickSkin.LOGGER.error("NPE during GeckoLib player render", (Throwable)npe);
                throw new RuntimeException("GeckoLib render failed due to missing data", npe);
            }
            if (this.currentCapeId != null && !this.currentCapeId.isEmpty() && !this.currentCapeId.equals("__NONE__")) {
                ResourceLocation baseCapeTexture = null;
                String baseAnimationId = null;
                if (this.currentCapeId.startsWith("local_cape:")) {
                    String hash = this.currentCapeId.substring("local_cape:".length());
                    baseAnimationId = "cape_" + hash;
                    baseCapeTexture = LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.FULL);
                } else if (this.currentCapeId.startsWith("KNOWN_CAPE:")) {
                    String id = this.currentCapeId.substring("KNOWN_CAPE:".length());
                    KnownCapes cape = KnownCapes.getById(id);
                    if (cape != null) {
                        baseCapeTexture = cape.getTextureLocation();
                    }
                } else {
                    baseCapeTexture = this.capeLocation;
                }
                if (baseCapeTexture != null) {
                    this.geoCapeEntity.setCapeIdentifier(baseAnimationId);
                    this.geoCapeEntity.setAnimation(this.geoPlayerEntity.getCurrentAnimation());
                    this.geoCapeEntity.setModelName(this.geoPlayerEntity.getModelName());
                    this.geoCapeEntity.setSkinLocation(baseCapeTexture);
                    RenderType capeRenderType = RenderType.m_110470_((ResourceLocation)baseCapeTexture);
                    VertexConsumer capeVertexConsumer = buffer.m_6299_(capeRenderType);
                    try {
                        this.geoCapeRenderer.render(poseStack, this.geoCapeEntity, (MultiBufferSource)buffer, capeRenderType, capeVertexConsumer, 0xF000F0);
                    }
                    catch (Exception e) {
                        QuickSkin.LOGGER.error("Error during GeckoLib cape render", (Throwable)e);
                    }
                }
            } else {
                this.geoCapeEntity.setCapeIdentifier(null);
                this.geoCapeEntity.setSkinLocation(null);
            }
            buffer.m_109911_();
        }
        catch (Exception e) {
            QuickSkin.LOGGER.error("Error in renderGeckoModel", (Throwable)e);
            throw e;
        }
        finally {
            poseStack.m_85849_();
        }
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public boolean isLoadingSkin() {
        return this.isLoadingSkin;
    }

    public void setAnimation(String animationName) {
        if (this.geoPlayerEntity != null && animationName != null && !animationName.isBlank()) {
            this.geoPlayerEntity.setAnimation(animationName);
            Config.ACTIVE_ANIMATION.set((Object)animationName);
            Config.ACTIVE_ANIMATION.save();
            QuickSkin.LOGGER.debug("PlayerWidget animation set to: {}", (Object)animationName);
        }
    }

    public void setModel(String modelName) {
        if (this.geoPlayerEntity != null) {
            this.geoPlayerEntity.setModelName(modelName);
            QuickSkin.LOGGER.debug("PlayerWidget model set to: {}", (Object)modelName);
        }
    }

    public void toggleRotation() {
        this.yRotation = Math.abs(this.yRotation - 200.0f) < 1.0f ? 20.0f : 200.0f;
    }

    private LocalSkinManager.TextureQuality determinePreviewQuality(SkinResolution resolution) {
        if (resolution == null || !resolution.isHD()) {
            return LocalSkinManager.TextureQuality.FULL;
        }
        return switch ((Config.HDSkinQuality)((Object)Config.HD_SKIN_QUALITY.get())) {
            default -> throw new IncompatibleClassChangeError();
            case Config.HDSkinQuality.HIGH -> LocalSkinManager.TextureQuality.FULL;
            case Config.HDSkinQuality.MEDIUM -> LocalSkinManager.TextureQuality.PREVIEW;
            case Config.HDSkinQuality.LOW -> LocalSkinManager.TextureQuality.THUMBNAIL;
        };
    }

    public void setPreviewQuality(LocalSkinManager.TextureQuality quality) {
        if (this.previewQuality != quality) {
            this.previewQuality = quality;
            if (this.skinLocation != null && this.currentResolution != null && this.currentResolution.isHD()) {
                this.reloadCurrentSkinWithQuality(quality);
            }
        }
    }

    private void reloadCurrentSkinWithQuality(LocalSkinManager.TextureQuality quality) {
        if (this.geoPlayerEntity == null) {
            return;
        }
        String currentSkinId = (String)Config.ACTIVE_SKIN.get();
        SkinData currentSkin = SkinData.fromString(currentSkinId);
        if (currentSkin.getUsername().startsWith("local_skin:")) {
            String hash = currentSkin.getUsername().substring("local_skin:".length());
            this.skinLocation = LocalSkinManager.INSTANCE.getTextureLocation(hash, quality);
            this.geoPlayerEntity.setSkinLocation(this.skinLocation);
        }
    }

    public boolean isHDSkin() {
        return this.currentResolution != null && this.currentResolution.isHD();
    }

    @Nullable
    public SkinResolution getCurrentResolution() {
        return this.currentResolution;
    }
}

