/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.gui.list;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.gui.PlayerSkinMenuScreen;
import com.quickskin.mod.gui.RenameScreen;
import com.quickskin.mod.util.SkinAPI;
import com.quickskin.mod.util.SkinData;
import com.quickskin.mod.util.SkinResolution;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class SkinEntry
extends ContainerObjectSelectionList.Entry<SkinEntry> {
    private final PlayerSkinMenuScreen parentScreen;
    private final Minecraft mc;
    private SkinData skinData;
    private ResourceLocation textureLocation;
    private boolean isLoading;
    private boolean loadFailed;
    private final int actionButtonSize = 11;
    private int deleteButtonX;
    private int deleteButtonY;
    private int editButtonX;
    private int editButtonY;
    private boolean isDeleteHovered;
    private boolean isEditHovered;

    public SkinEntry(PlayerSkinMenuScreen parentScreen, SkinData skinData) {
        this.parentScreen = parentScreen;
        this.skinData = skinData;
        this.mc = Minecraft.m_91087_();
        this.loadPreview();
    }

    public SkinData getSkinData() {
        return this.skinData;
    }

    public void setSkinData(SkinData skinData) {
        this.skinData = skinData;
    }

    public String getSortName() {
        return this.skinData.getDisplayName();
    }

    private void loadPreview() {
        if (this.isLoading || this.skinData.getUsername().isBlank()) {
            return;
        }
        this.isLoading = true;
        this.loadFailed = false;
        String username = this.skinData.getUsername();
        if (username.startsWith("local_skin:")) {
            String hash = username.substring("local_skin:".length());
            this.textureLocation = LocalSkinManager.INSTANCE.getTextureLocation(hash, LocalSkinManager.TextureQuality.FULL);
            this.isLoading = false;
            this.loadFailed = this.textureLocation == DefaultPlayerSkin.m_118626_();
        } else {
            SkinAPI.fetchProfile(username).thenAcceptAsync(profile -> {
                if (profile == null) {
                    this.isLoading = false;
                    this.loadFailed = true;
                    return;
                }
                this.mc.m_91109_().m_118817_(profile, (type, location, texture) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        this.textureLocation = location;
                        this.isLoading = false;
                    }
                }, true);
            }, (Executor)this.mc);
        }
    }

    public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
        String hash;
        SkinResolution resolution;
        int highlightPaddingH = 4;
        int highlightPaddingV = 2;
        int highlightLeft = left - highlightPaddingH;
        int highlightRight = left + width - 10;
        int highlightTop = top - highlightPaddingV;
        int highlightBottom = top + height + highlightPaddingV;
        if (this.parentScreen.getSkinList().m_93511_() == this) {
            graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, -2144301888);
            graphics.m_280637_(highlightLeft, highlightTop, highlightRight - highlightLeft, highlightBottom - highlightTop, -12549889);
        } else if (isHovered) {
            graphics.m_280509_(highlightLeft, highlightTop, highlightRight, highlightBottom, 0x30FFFFFF);
        }
        int faceSize = height - 8;
        int faceX = left + 4;
        int faceY = top + 4;
        if (this.isLoading) {
            graphics.m_280509_(faceX, faceY, faceX + faceSize, faceY + faceSize, -13421773);
        } else if (this.loadFailed) {
            graphics.m_280509_(faceX, faceY, faceX + faceSize, faceY + faceSize, -7864320);
            graphics.m_280137_(this.mc.f_91062_, "?", faceX + faceSize / 2, faceY + faceSize / 2 - 4, 0xFFFFFF);
        } else {
            String hash2;
            SkinResolution resolution2;
            ResourceLocation skin = this.textureLocation != null ? this.textureLocation : DefaultPlayerSkin.m_118627_((UUID)Util.f_137441_);
            RenderSystem.enableBlend();
            int textureWidth = 64;
            int textureHeight = 64;
            if (this.skinData.getUsername().startsWith("local_skin:") && (resolution2 = LocalSkinManager.INSTANCE.getResolution(hash2 = this.skinData.getUsername().substring("local_skin:".length()))) != null) {
                textureWidth = resolution2.width;
                textureHeight = resolution2.height;
            }
            float scaleX = (float)textureWidth / 64.0f;
            float scaleY = (float)textureHeight / 64.0f;
            graphics.m_280411_(skin, faceX, faceY, faceSize, faceSize, 8.0f * scaleX, 8.0f * scaleY, (int)(8.0f * scaleX), (int)(8.0f * scaleY), textureWidth, textureHeight);
            graphics.m_280411_(skin, faceX, faceY, faceSize, faceSize, 40.0f * scaleX, 8.0f * scaleY, (int)(8.0f * scaleX), (int)(8.0f * scaleY), textureWidth, textureHeight);
            RenderSystem.disableBlend();
        }
        int textX = left + faceSize + 12;
        int buttonAreaWidth = 19;
        int textMaxWidth = highlightRight - buttonAreaWidth - textX;
        String displayName = this.getSortName();
        String truncatedName = this.mc.f_91062_.m_92865_().m_92410_(displayName, textMaxWidth, Style.f_131099_);
        graphics.m_280488_(this.mc.f_91062_, truncatedName, textX, top + 6, 0xFFFFFF);
        Object modelText = "slim".equalsIgnoreCase(this.skinData.getModel()) ? "Slim" : "Classic";
        Object resolutionText = "";
        if (this.skinData.getUsername().startsWith("local_skin:") && (resolution = LocalSkinManager.INSTANCE.getResolution(hash = this.skinData.getUsername().substring("local_skin:".length()))) != null && resolution.isHD()) {
            resolutionText = " \u2022 " + resolution.name();
            modelText = (String)modelText + (String)resolutionText;
        }
        Font font = this.mc.f_91062_;
        Objects.requireNonNull(this.mc.f_91062_);
        graphics.m_280488_(font, (String)modelText, textX, top + 6 + 9 + 2, ((String)resolutionText).isEmpty() ? 0xAAAAAA : 0x55FF55);
        this.isDeleteHovered = false;
        this.isEditHovered = false;
        if (isHovered) {
            int margin = 4;
            this.deleteButtonX = highlightRight - 11 - margin;
            this.deleteButtonY = highlightTop + margin;
            this.isDeleteHovered = mouseX >= this.deleteButtonX && mouseX < this.deleteButtonX + 11 && mouseY >= this.deleteButtonY && mouseY < this.deleteButtonY + 11;
            graphics.m_280509_(this.deleteButtonX, this.deleteButtonY, this.deleteButtonX + 11, this.deleteButtonY + 11, this.isDeleteHovered ? -1595916224 : -2134900736);
            graphics.m_280488_(this.mc.f_91062_, "x", this.deleteButtonX + 3, this.deleteButtonY + 1, 0xFFFFFF);
            if (this.isDeleteHovered) {
                this.parentScreen.setTooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"Delete")));
            }
            if (this.skinData.getUsername().startsWith("local_skin:")) {
                this.editButtonX = this.deleteButtonX;
                this.editButtonY = this.deleteButtonY + this.actionButtonSize + 2;
                this.isEditHovered = mouseX >= this.editButtonX && mouseX < this.editButtonX + 11 && mouseY >= this.editButtonY && mouseY < this.editButtonY + 11;
                graphics.m_280509_(this.editButtonX, this.editButtonY, this.editButtonX + 11, this.editButtonY + 11, this.isEditHovered ? -1606369088 : -2143256448);
                graphics.m_280488_(this.mc.f_91062_, "\u270e", this.editButtonX + 2, this.editButtonY + 1, -1);
                if (this.isEditHovered) {
                    this.parentScreen.setTooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"Rename File")));
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isDeleteHovered) {
                MutableComponent message = this.skinData.getUsername().startsWith("local_skin:") ? Component.m_237113_((String)"This will permanently delete the skin file. Are you sure?") : Component.m_237113_((String)("Remove '" + this.getSortName() + "' from this list?"));
                this.mc.m_91152_((Screen)new ConfirmScreen(c -> {
                    if (c) {
                        this.parentScreen.removeSkinFromList(this.skinData);
                    }
                    this.mc.m_91152_((Screen)this.parentScreen);
                }, (Component)Component.m_237113_((String)"Delete Skin"), (Component)message));
                return true;
            }
            if (this.isEditHovered) {
                this.mc.m_91152_((Screen)new RenameScreen(this.parentScreen, (Component)Component.m_237113_((String)"Rename Skin File"), (Component)Component.m_237119_(), this.getSortName(), this.parentScreen::renameSkinFile));
                return true;
            }
            if (!this.parentScreen.isApplyingSkin()) {
                this.parentScreen.onSkinSelected(this);
                return true;
            }
        }
        return false;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of();
    }

    public List<? extends NarratableEntry> m_142437_() {
        return List.of();
    }
}

