/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.gui.logic;

import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.SkinSwapper;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.gui.PlayerSkinMenuScreen;
import com.quickskin.mod.gui.list.SkinEntry;
import com.quickskin.mod.util.HDTextureProcessor;
import com.quickskin.mod.util.SkinData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class SkinMenuLogicHandler {
    private final PlayerSkinMenuScreen screen;
    private final Minecraft minecraft;
    private SkinData currentSkinData;

    public SkinMenuLogicHandler(PlayerSkinMenuScreen screen) {
        this.screen = screen;
        this.minecraft = Minecraft.m_91087_();
        String initialSkinId = (String)Config.ACTIVE_SKIN.get();
        if (initialSkinId.isBlank() && this.minecraft.m_91094_() != null) {
            String playerName = this.minecraft.m_91094_().m_92546_();
            this.currentSkinData = new SkinData(playerName, "slim", "", null);
        } else {
            this.currentSkinData = SkinData.fromString(initialSkinId);
        }
    }

    public SkinData getCurrentSkinData() {
        return this.currentSkinData;
    }

    private void applyAndSaveChanges() {
        if (this.currentSkinData.getUsername().isBlank()) {
            return;
        }
        if (this.minecraft.m_91403_() != null) {
            SkinSwapper.applySkin(this.currentSkinData.getUsername(), this.currentSkinData.getCapeUsername(), this.currentSkinData.getModel());
        }
        ClientSkinManager.getInstance().applyLookLocally(this.currentSkinData.getUsername(), this.currentSkinData.getCapeUsername(), this.currentSkinData.getModel());
        Config.ACTIVE_SKIN.set((Object)this.currentSkinData.toEncodedString());
        Config.ACTIVE_SKIN.save();
        this.updateSavedSkinInConfig(this.currentSkinData);
    }

    public void onSkinSelected(@Nullable SkinEntry entry) {
        if (entry == null) {
            if (!this.currentSkinData.getUsername().startsWith("local_skin:")) {
                this.currentSkinData = new SkinData(this.screen.getUsernameBoxValue(), "slim", this.currentSkinData.getCapeUsername(), null);
            }
        } else {
            this.currentSkinData = entry.getSkinData();
            this.applyAndSaveChanges();
        }
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void onUsernameBoxChanged(String username) {
        SkinEntry matchingEntry = this.screen.findEntry(e -> e.getSortName().equalsIgnoreCase(username));
        if (matchingEntry != null) {
            if (this.screen.getSelectedEntry() != matchingEntry) {
                this.screen.setSelectedEntry(matchingEntry);
                this.onSkinSelected(matchingEntry);
            }
        } else {
            this.screen.setSelectedEntry(null);
            this.currentSkinData = new SkinData(username, "slim", this.currentSkinData.getCapeUsername(), null);
            if (!username.isBlank()) {
                this.screen.schedulePreviewUpdate();
            }
            this.screen.updateAllWidgets();
        }
    }

    public void setModel(String newModel) {
        if (this.currentSkinData.getUsername().isBlank() || newModel.equalsIgnoreCase(this.currentSkinData.getModel())) {
            return;
        }
        this.currentSkinData = new SkinData(this.currentSkinData.getUsername(), newModel, this.currentSkinData.getCapeUsername(), this.currentSkinData.getFriendlyName());
        SkinEntry selectedEntry = this.screen.getSelectedEntry();
        if (selectedEntry != null && selectedEntry.getSkinData().getUsername().equalsIgnoreCase(this.currentSkinData.getUsername())) {
            selectedEntry.setSkinData(this.currentSkinData);
        }
        this.applyAndSaveChanges();
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void setCape(String capeIdentifier) {
        this.currentSkinData = new SkinData(this.currentSkinData.getUsername(), this.currentSkinData.getModel(), capeIdentifier, this.currentSkinData.getFriendlyName());
        SkinEntry selectedEntry = this.screen.getSelectedEntry();
        if (selectedEntry != null && selectedEntry.getSkinData().getUsername().equalsIgnoreCase(this.currentSkinData.getUsername())) {
            selectedEntry.setSkinData(this.currentSkinData);
        }
        this.applyAndSaveChanges();
        this.screen.updateAllWidgets();
        this.screen.updatePreviewImmediately();
    }

    public void addOrUpdateSkinInList() {
        if (this.screen.isApplyingSkin() || this.currentSkinData.getUsername().isBlank()) {
            return;
        }
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        SkinData dataToSave = this.currentSkinData;
        int existingIndex = -1;
        for (int i = 0; i < saved.size(); ++i) {
            if (!SkinData.fromString((String)saved.get(i)).getUsername().equalsIgnoreCase(dataToSave.getUsername())) continue;
            existingIndex = i;
            break;
        }
        if (existingIndex != -1) {
            saved.set(existingIndex, dataToSave.toEncodedString());
        } else if (!dataToSave.getUsername().startsWith("local_skin:")) {
            saved.add(dataToSave.toEncodedString());
        } else {
            return;
        }
        Config.SAVED_SKINS.set(saved);
        Config.SAVED_SKINS.save();
        this.screen.refreshSkinList();
        this.screen.selectSkinInList(dataToSave.getUsername());
    }

    public void removeSkinFromList(SkinData skinDataToRemove) {
        ArrayList<String> saved;
        String hash;
        LocalSkinManager.DeleteResult result;
        if (skinDataToRemove == null || skinDataToRemove.getUsername().isBlank()) {
            return;
        }
        if (skinDataToRemove.getUsername().startsWith("local_skin:") && (result = LocalSkinManager.INSTANCE.deleteLocalAsset(hash = skinDataToRemove.getUsername().substring("local_skin:".length()))) == LocalSkinManager.DeleteResult.IO_ERROR && this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not delete the skin file.").m_130938_(s -> s.m_178520_(0xFF5555)));
        }
        if ((saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get())).removeIf(s -> SkinData.fromString(s).getUsername().equalsIgnoreCase(skinDataToRemove.getUsername()))) {
            String sortName;
            Config.SAVED_SKINS.set(saved);
            Config.SAVED_SKINS.save();
            this.screen.refreshSkinList();
            String string = sortName = skinDataToRemove.getFriendlyName() != null ? skinDataToRemove.getFriendlyName() : skinDataToRemove.getUsername();
            if (this.screen.getUsernameBoxValue().equalsIgnoreCase(sortName)) {
                this.screen.setUsernameBoxValue("");
                this.currentSkinData = new SkinData("", "slim", this.currentSkinData.getCapeUsername(), null);
                this.screen.updateAllWidgets();
                this.screen.updatePreviewImmediately();
            }
        }
    }

    public void renameLocalSkin(SkinData skinData, String newFriendlyName) {
        String hash = skinData.getUsername().substring("local_skin:".length());
        LocalSkinManager.RenameResult result = LocalSkinManager.INSTANCE.renameLocalAsset(hash, newFriendlyName);
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        switch (result) {
            case SUCCESS: {
                SkinData newData = new SkinData(skinData.getUsername(), skinData.getModel(), skinData.getCapeUsername(), newFriendlyName);
                this.updateSavedSkinInConfig(newData);
                this.screen.refreshSkinList();
                this.screen.selectSkinInList(newData.getUsername());
                break;
            }
            case NAME_TAKEN: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: A skin file with that name already exists.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case INVALID_NAME: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: The name contains invalid characters or is empty.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case IO_ERROR: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not rename the file. See logs.").m_130938_(s -> s.m_178520_(0xFF5555)));
                break;
            }
            case NOT_FOUND: {
                this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"Error: Could not find the original file.").m_130938_(s -> s.m_178520_(0xFF5555)));
            }
        }
    }

    public void importLocalSkins() {
        List<LocalSkinManager.LocalAsset> newAssets = LocalSkinManager.INSTANCE.scanAndCacheUploads();
        ArrayList<String> saved = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        int newSkinsCount = 0;
        String firstNewSkinId = null;
        for (LocalSkinManager.LocalAsset asset : newAssets) {
            if (!"skin".equals(asset.type())) continue;
            String skinId = "local_skin:" + asset.hash();
            if (!saved.stream().noneMatch(s -> SkinData.fromString(s).getUsername().equals(skinId))) continue;
            SkinData newSkinData = new SkinData(skinId, "slim", "", asset.friendlyName());
            saved.add(newSkinData.toEncodedString());
            if (firstNewSkinId == null) {
                firstNewSkinId = skinId;
            }
            ++newSkinsCount;
        }
        if (newSkinsCount > 0) {
            Config.SAVED_SKINS.set(saved);
            Config.SAVED_SKINS.save();
            this.screen.refreshSkinList();
            if (firstNewSkinId != null) {
                this.screen.selectSkinInList(firstNewSkinId);
            }
        }
    }

    public void savePendingChanges() {
        if (this.screen.getSelectedEntry() == null && !this.currentSkinData.getUsername().isBlank() && !this.screen.isApplyingSkin()) {
            this.applyAndSaveChanges();
            if (!this.currentSkinData.getUsername().startsWith("local_skin:")) {
                this.addOrUpdateSkinInList();
            }
        }
    }

    public void updateSavedSkinInConfig(SkinData skinData) {
        ArrayList<String> savedSkins = new ArrayList<String>((Collection)Config.SAVED_SKINS.get());
        for (int i = 0; i < savedSkins.size(); ++i) {
            if (!SkinData.fromString((String)savedSkins.get(i)).getUsername().equalsIgnoreCase(skinData.getUsername())) continue;
            savedSkins.set(i, skinData.toEncodedString());
            Config.SAVED_SKINS.set(savedSkins);
            Config.SAVED_SKINS.save();
            return;
        }
    }

    public void handleFileDrop(List<Path> paths) {
        List pngFiles = paths.stream().filter(p -> p.toString().toLowerCase().endsWith(".png")).collect(Collectors.toList());
        if (pngFiles.isEmpty()) {
            return;
        }
        Path uploadsDir = LocalSkinManager.INSTANCE.getSkinsUploadDir();
        try {
            Files.createDirectories(uploadsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            return;
        }
        int successCount = 0;
        for (Path skinFile : pngFiles) {
            try {
                BufferedImage image = ImageIO.read(skinFile.toFile());
                BufferedImage finalImage = HDTextureProcessor.normalizeSkin(image);
                if (finalImage == null) continue;
                Path targetPath = uploadsDir.resolve(skinFile.getFileName());
                ImageIO.write((RenderedImage)finalImage, "png", targetPath.toFile());
                ++successCount;
            }
            catch (IOException e) {
                QuickSkin.LOGGER.error("Could not process dropped skin file {}: {}", (Object)skinFile, (Object)e.getMessage());
            }
        }
        if (successCount > 0) {
            this.importLocalSkins();
        }
    }

    public void handleFileSelection(Path selectedPath) {
        try {
            BufferedImage image = ImageIO.read(selectedPath.toFile());
            BufferedImage finalImage = HDTextureProcessor.normalizeSkin(image);
            if (finalImage != null) {
                Path uploadsDir = LocalSkinManager.INSTANCE.getSkinsUploadDir();
                Files.createDirectories(uploadsDir, new FileAttribute[0]);
                Path targetPath = uploadsDir.resolve(selectedPath.getFileName());
                ImageIO.write((RenderedImage)finalImage, "png", targetPath.toFile());
                this.minecraft.execute(() -> {
                    this.importLocalSkins();
                    if (this.minecraft.f_91074_ != null) {
                        this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u2713 Imported normalized skin: ").m_7220_((Component)Component.m_237113_((String)targetPath.getFileName().toString()).m_130938_(s -> s.m_178520_(0x55FF55))));
                    }
                });
            } else {
                this.sendInvalidSkinMessage();
            }
        }
        catch (IOException e) {
            QuickSkin.LOGGER.error("Could not copy selected skin file {}", (Object)selectedPath, (Object)e);
        }
    }

    private void sendInvalidSkinMessage() {
        if (this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u26a0 Invalid skin image (must follow Minecraft skin format: 64x32, 64x64, or HD resolutions like 512x256, 1024x512, etc.).").m_130938_(s -> s.m_178520_(0xFFAA00)));
        }
    }
}

