/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.gui.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiScaleManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"quickskin GuiScaleManager");
    private static Integer originalGuiScale = null;
    private static boolean scaleChanged = false;

    public static boolean setMenuGuiScale(int targetScale) {
        try {
            int currentScale;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_ == null) {
                LOGGER.warn("Cannot change GUI scale: options is null");
                return false;
            }
            OptionInstance guiScaleOption = mc.f_91066_.m_231928_();
            if (originalGuiScale == null) {
                originalGuiScale = (Integer)guiScaleOption.m_231551_();
                LOGGER.info("Stored original GUI scale: {}", (Object)originalGuiScale);
            }
            if ((currentScale = ((Integer)guiScaleOption.m_231551_()).intValue()) != targetScale) {
                guiScaleOption.m_231514_((Object)targetScale);
                scaleChanged = true;
                mc.m_5741_();
                LOGGER.info("Changed GUI scale from {} to {} for QuickSkin menu", (Object)currentScale, (Object)targetScale);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to set menu GUI scale", (Throwable)e);
        }
        return false;
    }

    public static void restoreOriginalGuiScale() {
        try {
            if (originalGuiScale == null || !scaleChanged) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_ == null) {
                LOGGER.warn("Cannot restore GUI scale: options is null");
                return;
            }
            OptionInstance guiScaleOption = mc.f_91066_.m_231928_();
            int currentScale = (Integer)guiScaleOption.m_231551_();
            if (currentScale != originalGuiScale) {
                guiScaleOption.m_231514_((Object)originalGuiScale);
                mc.m_5741_();
                LOGGER.info("Restored GUI scale from {} to {}", (Object)currentScale, (Object)originalGuiScale);
            }
            originalGuiScale = null;
            scaleChanged = false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore original GUI scale", (Throwable)e);
        }
    }

    public static int getOptimalMenuScale() {
        try {
            return 3;
        }
        catch (Exception e) {
            LOGGER.error("Failed to calculate optimal menu scale", (Throwable)e);
            return 3;
        }
    }

    public static boolean hasModifiedScale() {
        return originalGuiScale != null && scaleChanged;
    }

    public static Integer getOriginalScale() {
        return originalGuiScale;
    }
}

