/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.event.ServerAnimationCache;
import com.quickskin.mod.event.ServerTextureCache;
import com.quickskin.mod.network.PacketHandler;
import com.quickskin.mod.network.S2CSendAnimationMetadataPacket;
import com.quickskin.mod.network.S2CTextureChunkPacket;
import com.quickskin.mod.util.SkinResolution;
import com.quickskin.mod.util.TextureChunker;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SRequestTexturePacket(String hash) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
    }

    public static C2SRequestTexturePacket decode(FriendlyByteBuf buf) {
        return new C2SRequestTexturePacket(buf.m_130277_());
    }

    public static void handle(C2SRequestTexturePacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ServerTextureCache cache = ServerTextureCache.getInstance();
            if (cache.hasTexture(msg.hash())) {
                byte[] data = cache.getTexture(msg.hash());
                SkinResolution resolution = cache.getResolution(msg.hash());
                if (data != null) {
                    List<S2CTextureChunkPacket> chunks = TextureChunker.chunkTextureForDownload(msg.hash(), data, resolution);
                    chunks.forEach(chunk -> PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), chunk));
                    LocalSkinManager.AnimationMetadata metadata = ServerAnimationCache.getInstance().getMetadata(msg.hash());
                    if (metadata != null) {
                        S2CSendAnimationMetadataPacket metaPacket = new S2CSendAnimationMetadataPacket(msg.hash(), metadata);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)metaPacket);
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

