/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.event.ServerTextureCache;
import com.quickskin.mod.util.SkinResolution;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record C2STextureChunkPacket(String hash, int chunkIndex, int totalChunks, byte[] chunkData, @Nullable SkinResolution resolution) {
    public static final int MAX_CHUNK_SIZE = 30000;

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130087_(this.chunkData);
        buf.writeBoolean(this.resolution != null);
        if (this.resolution != null) {
            buf.m_130068_((Enum)this.resolution);
        }
    }

    public static C2STextureChunkPacket decode(FriendlyByteBuf buf) {
        String hash = buf.m_130277_();
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        byte[] chunkData = buf.m_130052_();
        SkinResolution resolution = null;
        if (buf.readBoolean()) {
            resolution = (SkinResolution)buf.m_130066_(SkinResolution.class);
        }
        return new C2STextureChunkPacket(hash, chunkIndex, totalChunks, chunkData, resolution);
    }

    public static void handle(C2STextureChunkPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (msg.chunkIndex < 0 || msg.chunkIndex >= msg.totalChunks || msg.chunkData.length > 30000) {
                return;
            }
            ServerTextureCache.getInstance().storeTextureChunk(msg.hash(), msg.chunkIndex(), msg.totalChunks(), msg.chunkData(), msg.resolution());
        });
        ctx.setPacketHandled(true);
    }
}

