/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.event.ServerTextureCache;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record C2SUploadTexturePacket(String hash, byte[] data) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.m_130087_(this.data);
    }

    public static C2SUploadTexturePacket decode(FriendlyByteBuf buf) {
        return new C2SUploadTexturePacket(buf.m_130277_(), buf.m_130052_());
    }

    public static void handle(C2SUploadTexturePacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            ServerTextureCache.getInstance().storeTexture(msg.hash(), msg.data());
        });
        ctx.setPacketHandled(true);
    }
}

