/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.util.GifUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CSendAnimationMetadataPacket(String hash, LocalSkinManager.AnimationMetadata metadata) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.writeInt(this.metadata.frameCount());
        buf.m_236828_(this.metadata.frames(), (b, frame) -> b.writeInt(frame.delay()));
    }

    public static S2CSendAnimationMetadataPacket decode(FriendlyByteBuf buf) {
        String hash = buf.m_130277_();
        int frameCount = buf.readInt();
        List frames = (List)buf.m_236838_(ArrayList::new, b -> new GifUtil.FrameData(b.readInt()));
        return new S2CSendAnimationMetadataPacket(hash, new LocalSkinManager.AnimationMetadata(frames, frameCount));
    }

    public static void handle(S2CSendAnimationMetadataPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            QuickSkin.LOGGER.info("[CLIENT] Received animation metadata from server for hash: {}", (Object)msg.hash());
            LocalSkinManager.INSTANCE.saveAnimationMetadata(msg.hash(), msg.metadata());
            ClientSkinManager.getInstance().refreshUsersOfTexture(msg.hash());
        }));
        ctx.setPacketHandled(true);
    }
}

