/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.client.ClientSkinManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CUpdateSkinPacket(UUID playerUuid, String skinIdentifier, String capeIdentifier, String model) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUuid);
        buf.m_236821_((Object)this.skinIdentifier, FriendlyByteBuf::m_130070_);
        buf.m_236821_((Object)this.capeIdentifier, FriendlyByteBuf::m_130070_);
        buf.m_236821_((Object)this.model, FriendlyByteBuf::m_130070_);
    }

    public static S2CUpdateSkinPacket decode(FriendlyByteBuf buf) {
        return new S2CUpdateSkinPacket(buf.m_130259_(), (String)buf.m_236868_(FriendlyByteBuf::m_130277_), (String)buf.m_236868_(FriendlyByteBuf::m_130277_), (String)buf.m_236868_(FriendlyByteBuf::m_130277_));
    }

    public static void handle(S2CUpdateSkinPacket msg, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientSkinManager manager = ClientSkinManager.getInstance();
            if (msg.skinIdentifier == null) {
                manager.clearSkin(msg.playerUuid);
            } else {
                manager.applyLook(msg.playerUuid, msg.skinIdentifier, msg.capeIdentifier, msg.model);
            }
        }));
        ctx.setPacketHandled(true);
    }
}

