/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.network;

import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.client.ClientSkinManager;
import com.quickskin.mod.client.LocalSkinManager;
import com.quickskin.mod.util.SkinResolution;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class TextureChunkReceiver {
    private static final TextureChunkReceiver INSTANCE = new TextureChunkReceiver();
    private final Map<String, ChunkAssembly> incompleteTextures = new ConcurrentHashMap<String, ChunkAssembly>();
    private final Map<String, String> pendingRequestTypes = new ConcurrentHashMap<String, String>();

    public static TextureChunkReceiver getInstance() {
        return INSTANCE;
    }

    public void registerPendingRequest(String hash, String type) {
        this.pendingRequestTypes.put(hash, type);
    }

    public void receiveChunk(String hash, int chunkIndex, int totalChunks, byte[] chunkData, @Nullable SkinResolution resolution) {
        ChunkAssembly assembly = this.incompleteTextures.computeIfAbsent(hash, k -> new ChunkAssembly(totalChunks, resolution));
        if (assembly.addChunk(chunkIndex, chunkData)) {
            byte[] completeData = assembly.assembleTexture();
            if (completeData != null) {
                String type = this.pendingRequestTypes.remove(hash);
                if (type == null) {
                    QuickSkin.LOGGER.warn("Received texture for hash {} without a pending request type, defaulting to 'skin'", (Object)hash);
                    type = "skin";
                }
                LocalSkinManager.INSTANCE.saveTextureAndCreateMetadata(hash, completeData, type, assembly.resolution);
                Minecraft.m_91087_().execute(() -> ClientSkinManager.getInstance().refreshUsersOfTexture(hash));
            }
            this.incompleteTextures.remove(hash);
        }
    }

    private static class ChunkAssembly {
        private final byte[][] chunks;
        private final boolean[] received;
        private final SkinResolution resolution;
        private int receivedCount = 0;

        public ChunkAssembly(int totalChunks, @Nullable SkinResolution resolution) {
            this.chunks = new byte[totalChunks][];
            this.received = new boolean[totalChunks];
            this.resolution = resolution;
        }

        public synchronized boolean addChunk(int index, byte[] data) {
            if (index < 0 || index >= this.chunks.length || this.received[index]) {
                return false;
            }
            this.chunks[index] = data;
            this.received[index] = true;
            ++this.receivedCount;
            return this.receivedCount == this.chunks.length;
        }

        @Nullable
        public byte[] assembleTexture() {
            if (this.receivedCount != this.chunks.length) {
                return null;
            }
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                totalSize += chunk.length;
            }
            byte[] result = new byte[totalSize];
            int offset = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, result, offset, chunk.length);
                offset += chunk.length;
            }
            return result;
        }
    }
}

