/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.util.GifUtil;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FramePool {
    private static final int MAX_CACHED_FRAMES = 100;
    private static final Map<String, FrameCache> caches = new ConcurrentHashMap<String, FrameCache>();

    public static FrameCache getOrCreateCache(String gifId, GifUtil.GifData gifData) {
        return caches.computeIfAbsent(gifId, id -> new FrameCache((String)id, gifData));
    }

    public static FrameCache getCache(String gifId) {
        return caches.get(gifId);
    }

    public static void removeCache(String gifId) {
        FrameCache cache = caches.remove(gifId);
        if (cache != null) {
            cache.cleanup();
        }
    }

    public static void cleanupAll() {
        caches.values().forEach(FrameCache::cleanup);
        caches.clear();
    }

    public static int getCacheCount() {
        return caches.size();
    }

    public static long getMemoryUsage() {
        return caches.values().stream().mapToLong(cache -> (long)(cache.frames.size() * cache.frameWidth * cache.frameHeight) * 4L).sum();
    }

    public static class FrameCache {
        private final String gifId;
        private final Map<Integer, WeakReference<NativeImage>> frames = new ConcurrentHashMap<Integer, WeakReference<NativeImage>>();
        private final GifUtil.GifData gifData;
        private final int frameWidth;
        private final int frameHeight;

        public FrameCache(String gifId, GifUtil.GifData gifData) {
            this.gifId = gifId;
            this.gifData = gifData;
            this.frameWidth = gifData.atlas().getWidth();
            this.frameHeight = gifData.atlas().getHeight() / gifData.frameCount();
        }

        public NativeImage getFrame(int index) {
            NativeImage image;
            if (index < 0 || index >= this.gifData.frameCount()) {
                return null;
            }
            WeakReference<NativeImage> ref = this.frames.get(index);
            NativeImage nativeImage = image = ref != null ? (NativeImage)ref.get() : null;
            if (image == null && (image = this.loadFrame(index)) != null) {
                this.frames.put(index, new WeakReference<NativeImage>(image));
                if (this.frames.size() > 100) {
                    this.cleanupOldFrames();
                }
            }
            return image;
        }

        private NativeImage loadFrame(int index) {
            try {
                int y = index * this.frameHeight;
                BufferedImage frameImage = this.gifData.atlas().getSubimage(0, y, this.frameWidth, this.frameHeight);
                NativeImage nativeImage = new NativeImage(this.frameWidth, this.frameHeight, false);
                for (int py = 0; py < this.frameHeight; ++py) {
                    for (int px = 0; px < this.frameWidth; ++px) {
                        int rgb = frameImage.getRGB(px, py);
                        nativeImage.m_84988_(px, py, rgb);
                    }
                }
                return nativeImage;
            }
            catch (Exception e) {
                QuickSkin.LOGGER.error("Failed to load frame {} for GIF {}", new Object[]{index, this.gifId, e});
                return null;
            }
        }

        private void cleanupOldFrames() {
            this.frames.entrySet().removeIf(entry -> ((WeakReference)entry.getValue()).get() == null);
            if (this.frames.size() > 100) {
                int toRemove = this.frames.size() - 100;
                this.frames.entrySet().stream().limit(toRemove).forEach(entry -> this.frames.remove(entry.getKey()));
            }
        }

        public void cleanup() {
            this.frames.values().forEach(ref -> {
                NativeImage image = (NativeImage)ref.get();
                if (image != null) {
                    image.close();
                }
            });
            this.frames.clear();
        }
    }
}

