/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GifUtil {
    public static GifData processGif(InputStream inputStream) throws IOException {
        ImageReader reader = null;
        try {
            GifData gifData;
            block18: {
                ImageInputStream stream = ImageIO.createImageInputStream(inputStream);
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                    if (!readers.hasNext()) {
                        throw new IOException("No GIF reader found for stream.");
                    }
                    reader = readers.next();
                    reader.setInput(stream);
                    int frameCount = reader.getNumImages(true);
                    if (frameCount <= 0) {
                        throw new IOException("GIF file contains no frames.");
                    }
                    ArrayList<FrameData> frameDataList = new ArrayList<FrameData>();
                    ArrayList<BufferedImage> reconstructedFrames = new ArrayList<BufferedImage>();
                    int masterWidth = reader.getWidth(0);
                    int masterHeight = reader.getHeight(0);
                    BufferedImage canvas = new BufferedImage(masterWidth, masterHeight, 2);
                    Graphics2D canvasGraphics = canvas.createGraphics();
                    int lastFrameX = 0;
                    int lastFrameY = 0;
                    for (int i = 0; i < frameCount; ++i) {
                        BufferedImage rawFrame = reader.read(i);
                        IIOMetadata metadata = reader.getImageMetadata(i);
                        Node root = metadata.getAsTree(metadata.getNativeMetadataFormatName());
                        Node gceNode = GifUtil.findNode(root, "GraphicControlExtension");
                        int delay = 100;
                        DisposalMethod disposal = DisposalMethod.NONE;
                        if (gceNode != null) {
                            delay = Integer.parseInt(gceNode.getAttributes().getNamedItem("delayTime").getNodeValue()) * 10;
                            if (delay < 20) {
                                delay = 100;
                            }
                            disposal = DisposalMethod.fromString(gceNode.getAttributes().getNamedItem("disposalMethod").getNodeValue());
                        }
                        Node idNode = GifUtil.findNode(root, "ImageDescriptor");
                        int frameX = 0;
                        int frameY = 0;
                        if (idNode != null) {
                            frameX = Integer.parseInt(idNode.getAttributes().getNamedItem("imageLeftPosition").getNodeValue());
                            frameY = Integer.parseInt(idNode.getAttributes().getNamedItem("imageTopPosition").getNodeValue());
                        }
                        canvasGraphics.drawImage((Image)rawFrame, frameX, frameY, null);
                        BufferedImage finalFrame = new BufferedImage(masterWidth, masterHeight, 2);
                        Graphics2D finalFrameGraphics = finalFrame.createGraphics();
                        finalFrameGraphics.drawImage((Image)canvas, 0, 0, null);
                        finalFrameGraphics.dispose();
                        reconstructedFrames.add(finalFrame);
                        frameDataList.add(new FrameData(delay));
                        if (disposal == DisposalMethod.RESTORE_TO_BACKGROUND) {
                            canvasGraphics.clearRect(lastFrameX, lastFrameY, rawFrame.getWidth(), rawFrame.getHeight());
                        }
                        lastFrameX = frameX;
                        lastFrameY = frameY;
                    }
                    canvasGraphics.dispose();
                    int totalHeight = masterHeight * frameCount;
                    BufferedImage atlas = new BufferedImage(masterWidth, totalHeight, 2);
                    Graphics2D g = atlas.createGraphics();
                    int currentY = 0;
                    for (BufferedImage frame : reconstructedFrames) {
                        g.drawImage((Image)frame, 0, currentY, null);
                        currentY += frame.getHeight();
                    }
                    g.dispose();
                    gifData = new GifData(atlas, frameDataList, frameCount);
                    if (stream == null) break block18;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return gifData;
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private static Node findNode(Node rootNode, String nodeName) {
        if (rootNode.getNodeName().equalsIgnoreCase(nodeName)) {
            return rootNode;
        }
        NodeList children = rootNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node foundNode = GifUtil.findNode(node, nodeName);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public static enum DisposalMethod {
        NONE(0),
        DO_NOT_DISPOSE(1),
        RESTORE_TO_BACKGROUND(2),
        RESTORE_TO_PREVIOUS(3);

        private final int code;

        private DisposalMethod(int code) {
            this.code = code;
        }

        public static DisposalMethod fromString(String value) {
            if ("none".equalsIgnoreCase(value)) {
                return NONE;
            }
            if ("doNotDispose".equalsIgnoreCase(value)) {
                return DO_NOT_DISPOSE;
            }
            if ("restoreToBackgroundColor".equalsIgnoreCase(value)) {
                return RESTORE_TO_BACKGROUND;
            }
            if ("restoreToPrevious".equalsIgnoreCase(value)) {
                return RESTORE_TO_PREVIOUS;
            }
            try {
                return DisposalMethod.fromCode(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                return NONE;
            }
        }

        public static DisposalMethod fromCode(int code) {
            for (DisposalMethod method : DisposalMethod.values()) {
                if (method.code != code) continue;
                return method;
            }
            return NONE;
        }
    }

    public record FrameData(int delay) {
    }

    public record GifData(BufferedImage atlas, List<FrameData> frames, int frameCount) {
    }
}

