/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.quickskin.mod.Config;
import com.quickskin.mod.QuickSkin;
import com.quickskin.mod.util.SkinResolution;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class HDTextureProcessor {
    private static final Map<String, BufferedImage> DOWNSAMPLED_CACHE = new ConcurrentHashMap<String, BufferedImage>();
    private static final Map<String, BufferedImage> THUMBNAIL_CACHE = new ConcurrentHashMap<String, BufferedImage>();
    private static final int THUMBNAIL_SIZE = 64;
    private static final int PREVIEW_SIZE = 256;

    public static NativeImage processHDSkin(InputStream inputStream, boolean isTransparent) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        NativeImage nativeImage = HDTextureProcessor.convertBufferedToNative(bufferedImage);
        return HDTextureProcessor.processLegacySkin(nativeImage, isTransparent);
    }

    private static NativeImage processLegacySkin(NativeImage nativeImageIn, boolean isTransparent) {
        if (nativeImageIn == null) {
            return null;
        }
        int imageWidth = nativeImageIn.m_84982_();
        int imageHeight = nativeImageIn.m_85084_();
        boolean isLegacy = imageHeight == imageWidth / 2;
        float scaleFactor = (float)imageWidth / 64.0f;
        if (isLegacy) {
            NativeImage nativeimage = new NativeImage(imageWidth, imageWidth, true);
            nativeimage.m_85054_(nativeImageIn);
            nativeImageIn.close();
            nativeImageIn = nativeimage;
            if (!isTransparent) {
                nativeimage.m_84997_(0, (int)(32.0f * scaleFactor), (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor), 0);
            }
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 4, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 8, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 0, 20, 24, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 4, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 8, 20, 8, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 12, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 44, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 48, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 40, 20, 0, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 44, 20, -8, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 48, 20, -16, 32, 4, 12, true, false, scaleFactor);
            HDTextureProcessor.copyAreaRGBAScale(nativeimage, 52, 20, -8, 32, 4, 12, true, false, scaleFactor);
        }
        if (!isTransparent) {
            HDTextureProcessor.setAreaOpaque(nativeImageIn, 0, 0, (int)(32.0f * scaleFactor), (int)(16.0f * scaleFactor));
        }
        if (isLegacy) {
            HDTextureProcessor.setAreaTransparent(nativeImageIn, (int)(32.0f * scaleFactor), 0, (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor));
        }
        if (!isTransparent) {
            HDTextureProcessor.setAreaOpaque(nativeImageIn, 0, (int)(16.0f * scaleFactor), (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor));
            HDTextureProcessor.setAreaOpaque(nativeImageIn, (int)(16.0f * scaleFactor), (int)(48.0f * scaleFactor), (int)(48.0f * scaleFactor), (int)(64.0f * scaleFactor));
        }
        return nativeImageIn;
    }

    private static void copyAreaRGBAScale(NativeImage image, int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY, float scaleFactor) {
        image.m_85025_((int)((float)xFrom * scaleFactor), (int)((float)yFrom * scaleFactor), (int)((float)xToDelta * scaleFactor), (int)((float)yToDelta * scaleFactor), (int)((float)widthIn * scaleFactor), (int)((float)heightIn * scaleFactor), mirrorX, mirrorY);
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int pixel = image.m_84985_(i, j);
                if ((pixel >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.m_84988_(l, i1, image.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.m_84988_(i, j, image.m_84985_(i, j) | 0xFF000000);
            }
        }
    }

    private static NativeImage convertBufferedToNative(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        NativeImage nativeImage = new NativeImage(width, height, true);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.m_84988_(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static BufferedImage normalizeSkin(BufferedImage original) {
        int height;
        if (original == null) {
            return null;
        }
        int width = original.getWidth();
        if (SkinResolution.isValidSkinDimension(width, height = original.getHeight())) {
            return height == 32 && width == 64 ? HDTextureProcessor.convertLegacyToModern(original) : original;
        }
        return null;
    }

    public static BufferedImage normalizeCape(BufferedImage original) {
        if (original == null) {
            return null;
        }
        int width = original.getWidth();
        int height = original.getHeight();
        if (height <= 0 || width != height * 2) {
            return null;
        }
        if (width == 64 && height == 32) {
            return original;
        }
        if (width > 64 && height > 32 && width % 64 == 0 && height % 32 == 0 && width / 64 == height / 32) {
            QuickSkin.LOGGER.debug("Normalizing HD cape ({}x{}) to 64x32.", (Object)width, (Object)height);
            return HDTextureProcessor.downsampleTexture(original, 64, 32);
        }
        return null;
    }

    public static BufferedImage convertLegacyToModern(BufferedImage legacySkin) {
        if (legacySkin == null || legacySkin.getWidth() != 64 || legacySkin.getHeight() != 32) {
            return legacySkin;
        }
        QuickSkin.LOGGER.debug("Converting legacy 64x32 skin to 64x64 format.");
        BufferedImage newSkin = new BufferedImage(64, 64, 2);
        Graphics2D g = newSkin.createGraphics();
        g.drawImage((Image)legacySkin, 0, 0, null);
        HDTextureProcessor.copy(g, legacySkin, 4, 16, 20, 48, 4, 4);
        HDTextureProcessor.copy(g, legacySkin, 8, 16, 24, 48, 4, 4);
        HDTextureProcessor.copyMirrored(g, legacySkin, 0, 20, 24, 52, 4, 12);
        HDTextureProcessor.copy(g, legacySkin, 4, 20, 20, 52, 4, 12);
        HDTextureProcessor.copyMirrored(g, legacySkin, 8, 20, 16, 52, 4, 12);
        HDTextureProcessor.copy(g, legacySkin, 12, 20, 28, 52, 4, 12);
        HDTextureProcessor.copy(g, legacySkin, 44, 16, 36, 48, 4, 4);
        HDTextureProcessor.copy(g, legacySkin, 48, 16, 40, 48, 4, 4);
        HDTextureProcessor.copyMirrored(g, legacySkin, 40, 20, 40, 52, 4, 12);
        HDTextureProcessor.copy(g, legacySkin, 44, 20, 36, 52, 4, 12);
        HDTextureProcessor.copyMirrored(g, legacySkin, 48, 20, 32, 52, 4, 12);
        HDTextureProcessor.copy(g, legacySkin, 52, 20, 44, 52, 4, 12);
        g.dispose();
        return newSkin;
    }

    private static void copy(Graphics2D g, BufferedImage src, int srcX, int srcY, int destX, int destY, int width, int height) {
        g.drawImage((Image)src.getSubimage(srcX, srcY, width, height), destX, destY, null);
    }

    private static void copyMirrored(Graphics2D g, BufferedImage src, int srcX, int srcY, int destX, int destY, int width, int height) {
        g.drawImage(src, destX + width, destY, destX, destY + height, srcX, srcY, srcX + width, srcY + height, null);
    }

    public static BufferedImage downsampleTexture(BufferedImage original, int targetWidth, int targetHeight) {
        if (original.getWidth() == targetWidth && original.getHeight() == targetHeight) {
            return original;
        }
        String cacheKey = HDTextureProcessor.generateCacheKey(original, targetWidth, targetHeight);
        BufferedImage cached = DOWNSAMPLED_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        BufferedImage downsampled = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = downsampled.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(original, 0, 0, targetWidth, targetHeight, null);
        g2d.dispose();
        DOWNSAMPLED_CACHE.put(cacheKey, downsampled);
        return downsampled;
    }

    public static BufferedImage createThumbnail(BufferedImage original) {
        SkinResolution resolution = SkinResolution.fromDimensions(original.getWidth(), original.getHeight());
        if (resolution == null) {
            return HDTextureProcessor.downsampleTexture(original, 64, 64);
        }
        int thumbnailHeight = resolution == SkinResolution.LEGACY ? 32 : 64;
        return HDTextureProcessor.downsampleTexture(original, 64, thumbnailHeight);
    }

    public static BufferedImage createPreview(BufferedImage original) {
        SkinResolution resolution = SkinResolution.fromDimensions(original.getWidth(), original.getHeight());
        if (resolution == null || !resolution.isHD()) {
            return original;
        }
        int previewHeight = resolution == SkinResolution.LEGACY ? 128 : 256;
        return HDTextureProcessor.downsampleTexture(original, 256, previewHeight);
    }

    public static CompletableFuture<BufferedImage> createMipmap(BufferedImage original, int level) {
        return CompletableFuture.supplyAsync(() -> {
            int scale = (int)Math.pow(2.0, level);
            int targetWidth = Math.max(64, original.getWidth() / scale);
            int targetHeight = Math.max(32, original.getHeight() / scale);
            return HDTextureProcessor.downsampleTexture(original, targetWidth, targetHeight);
        });
    }

    public static void optimizeMemoryUsage() {
        int maxCacheSize = (Integer)Config.MAX_HD_CACHE_SIZE_MB.get() * 1024 * 1024;
        long currentSize = HDTextureProcessor.estimateCacheSize();
        if (currentSize > (long)maxCacheSize) {
            QuickSkin.LOGGER.info("HD texture cache exceeds limit, clearing cache");
            HDTextureProcessor.clearCache();
        }
    }

    private static long estimateCacheSize() {
        long size = 0L;
        for (BufferedImage img : DOWNSAMPLED_CACHE.values()) {
            size += (long)(img.getWidth() * img.getHeight() * 4);
        }
        for (BufferedImage img : THUMBNAIL_CACHE.values()) {
            size += (long)(img.getWidth() * img.getHeight() * 4);
        }
        return size;
    }

    public static void clearCache() {
        DOWNSAMPLED_CACHE.clear();
        THUMBNAIL_CACHE.clear();
    }

    private static String generateCacheKey(BufferedImage image, int targetWidth, int targetHeight) {
        return image.hashCode() + "_" + targetWidth + "x" + targetHeight;
    }

    public static boolean isMemoryIntensive(SkinResolution resolution) {
        return resolution != null && resolution.isHD() && resolution.getScale() >= 8;
    }

    public static BufferedImage processForDistance(BufferedImage original, float distance) {
        if (distance > 10.0f) {
            return HDTextureProcessor.createThumbnail(original);
        }
        if (distance > 5.0f) {
            return HDTextureProcessor.createPreview(original);
        }
        return original;
    }

    public static BufferedImage normalizeForGeckoLib(BufferedImage original) {
        SkinResolution resolution = SkinResolution.fromDimensions(original.getWidth(), original.getHeight());
        if (resolution == null || !resolution.isHD()) {
            return original;
        }
        int targetHeight = resolution == SkinResolution.LEGACY ? 32 : 64;
        BufferedImage downsampled = new BufferedImage(64, targetHeight, 2);
        Graphics2D g2d = downsampled.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(original, 0, 0, 64, targetHeight, null);
        g2d.dispose();
        return downsampled;
    }
}

