/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.util;

import com.quickskin.mod.QuickSkin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinLoadingMonitor {
    private static final Map<String, LoadingStats> loadingStats = new ConcurrentHashMap<String, LoadingStats>();
    private static final AtomicInteger totalRequests = new AtomicInteger(0);
    private static final AtomicInteger successfulLoads = new AtomicInteger(0);
    private static final AtomicInteger failedLoads = new AtomicInteger(0);

    public static void printStatistics() {
        int pending = 0;
        long totalDuration = 0L;
        int completed = 0;
        for (LoadingStats stat : loadingStats.values()) {
            if (stat.endTime == 0L) {
                ++pending;
                continue;
            }
            ++completed;
            totalDuration += stat.getDuration();
        }
        double avgDuration = completed > 0 ? (double)totalDuration / (double)completed : 0.0;
        double successRate = totalRequests.get() > 0 ? (double)successfulLoads.get() / (double)totalRequests.get() * 100.0 : 0.0;
        QuickSkin.LOGGER.info("=== Skin Loading Statistics ===");
        QuickSkin.LOGGER.info("Total requests: {}", (Object)totalRequests.get());
        QuickSkin.LOGGER.info("Successful: {} ({:.1f}%)", (Object)successfulLoads.get(), (Object)successRate);
        QuickSkin.LOGGER.info("Failed: {}", (Object)failedLoads.get());
        QuickSkin.LOGGER.info("Pending: {}", (Object)pending);
        QuickSkin.LOGGER.info("Average load time: {:.0f}ms", (Object)avgDuration);
        QuickSkin.LOGGER.info("==============================");
    }

    public static void resetStatistics() {
        loadingStats.clear();
        totalRequests.set(0);
        successfulLoads.set(0);
        failedLoads.set(0);
        QuickSkin.LOGGER.info("Reset skin loading statistics");
    }

    public static class LoadingStats {
        private final long startTime = System.currentTimeMillis();
        private long endTime;

        public LoadingStats(String username, int attemptNumber) {
        }

        public long getDuration() {
            return this.endTime - this.startTime;
        }
    }
}

