/*
 * Decompiled with CFR 0.152.
 */
package com.quickskin.mod.util;

import com.quickskin.mod.network.C2STextureChunkPacket;
import com.quickskin.mod.network.S2CTextureChunkPacket;
import com.quickskin.mod.util.SkinResolution;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class TextureChunker {
    private static final int MAX_CHUNK_SIZE = 30000;

    public static List<C2STextureChunkPacket> chunkTextureForUpload(String hash, byte[] data, @Nullable SkinResolution resolution) {
        ArrayList<C2STextureChunkPacket> chunks = new ArrayList<C2STextureChunkPacket>();
        int totalChunks = (int)Math.ceil((double)data.length / 30000.0);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 30000;
            int end = Math.min(start + 30000, data.length);
            byte[] chunkData = new byte[end - start];
            System.arraycopy(data, start, chunkData, 0, end - start);
            chunks.add(new C2STextureChunkPacket(hash, i, totalChunks, chunkData, resolution));
        }
        return chunks;
    }

    public static List<S2CTextureChunkPacket> chunkTextureForDownload(String hash, byte[] data, @Nullable SkinResolution resolution) {
        ArrayList<S2CTextureChunkPacket> chunks = new ArrayList<S2CTextureChunkPacket>();
        int totalChunks = (int)Math.ceil((double)data.length / 30000.0);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 30000;
            int end = Math.min(start + 30000, data.length);
            byte[] chunkData = new byte[end - start];
            System.arraycopy(data, start, chunkData, 0, end - start);
            chunks.add(new S2CTextureChunkPacket(hash, i, totalChunks, chunkData, resolution));
        }
        return chunks;
    }

    public static boolean shouldUseChunking(byte[] data) {
        return data.length > 30000;
    }
}

