/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.burning;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.builtin.burning.BurningServerRecipe;
import de.crafty.eiv.common.builtin.burning.BurningViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class BurningViewRecipe
implements IEivViewRecipe {
    private final SlotContent fuel;
    private final int burnTime;
    private final AnimationTicker ticker;

    public BurningViewRecipe(BurningServerRecipe recipe) {
        this.fuel = SlotContent.of(recipe.getFuel());
        this.burnTime = recipe.getBurnTime();
        this.ticker = AnimationTicker.create(class_2960.method_60656((String)("burning_tick_" + this.burnTime)), this.burnTime);
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return BurningViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindSlot(0, this.fuel);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.fuel);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of();
    }

    @Override
    public List<AnimationTicker> getAnimationTickers() {
        return List.of(this.ticker);
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int burnProgress = Math.round(this.ticker.getProgress() * 14.0f);
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_25290(class_10799.field_56883, BuiltInEivIntegration.WIDGETS, 19, 2 + (14 - burnProgress), 0.0f, (float)(14 - burnProgress), 14, burnProgress, 128, 128);
        class_5250 class_52502 = class_2561.method_43470((String)(this.burnTime + " ticks"));
        Objects.requireNonNull(font);
        guiGraphics.method_51439(font, (class_2561)class_52502, 38, 9 - 9 / 2, -8355712, false);
    }
}

