/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.network.payload.transfer.ServerboundTransferPayload;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import de.crafty.eiv.common.recipe.inventory.RecipeTransferData;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import de.crafty.eiv.common.recipe.util.EivUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class RecipeViewScreen
extends class_465<RecipeViewMenu> {
    private static final class_2960 VIEW_LOCATION = class_2960.method_60655((String)"eiv", (String)"textures/gui/recipe_view.png");
    private final long timestamp;
    private class_4185 prevRecipe;
    private class_4185 nextRecipe;
    private class_2561 guiTitle;
    private class_2561 page;
    private final List<AnimationTicker> animationTickers;
    private final HashMap<class_2960, Integer> animationTickCache;
    private final List<class_4185> transferButtons = new ArrayList<class_4185>();
    private final List<ViewTypeButton> viewTypeButtons = new ArrayList<ViewTypeButton>();
    private int viewTypePage = 0;
    private class_4185 prevTypePage;
    private class_4185 nextTypePage;

    public RecipeViewScreen(RecipeViewMenu recipeViewMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)recipeViewMenu, inventory, component);
        this.animationTickers = new ArrayList<AnimationTicker>();
        this.animationTickCache = new HashMap();
        this.field_2779 = ((RecipeViewMenu)this.method_17577()).getHeight();
        this.field_2792 = ((RecipeViewMenu)this.method_17577()).getWidth();
        this.guiTitle = component;
        this.page = this.createPageComponent();
        this.timestamp = inventory.field_7546.method_37908().method_8510();
        recipeViewMenu.setViewScreen(this);
    }

    private class_2561 createPageComponent() {
        return class_2561.method_43470((String)(((RecipeViewMenu)this.method_17577()).getCurrentPage() + 1 + "/" + (((RecipeViewMenu)this.method_17577()).getMaxPageIndex() + 1)));
    }

    public boolean method_25406(double d, double e, int i) {
        if (CommonEIVClient.GO_BACK_RECIPE.method_1433(i) && ((RecipeViewMenu)this.method_17577()).goBack()) {
            return true;
        }
        if (CommonEIVClient.GO_FORWARD_RECIPE.method_1433(i) && ((RecipeViewMenu)this.method_17577()).goForward()) {
            return true;
        }
        return super.method_25406(d, e, i);
    }

    public boolean method_25404(int i, int j, int k) {
        if (CommonEIVClient.GO_BACK_RECIPE.method_1417(i, j) && ((RecipeViewMenu)this.method_17577()).goBack()) {
            return true;
        }
        if (CommonEIVClient.GO_FORWARD_RECIPE.method_1417(i, j) && ((RecipeViewMenu)this.method_17577()).goForward()) {
            return true;
        }
        return super.method_25404(i, j, k);
    }

    protected void method_25426() {
        super.method_25426();
        this.prevRecipe = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), button -> ((RecipeViewMenu)this.method_17577()).prevPage()).method_46437(12, 12).method_46431();
        this.nextRecipe = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), button -> ((RecipeViewMenu)this.method_17577()).nextRecipe()).method_46437(12, 12).method_46431();
        this.prevTypePage = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), button -> {
            this.viewTypePage = Math.max(this.viewTypePage - 1, 0);
            this.checkGui();
        }).method_46437(12, 12).method_46431();
        this.nextTypePage = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), button -> {
            this.viewTypePage = Math.min(this.viewTypePage + 1, ((RecipeViewMenu)this.method_17577()).getViewTypeOrder().size() / 5);
            this.checkGui();
        }).method_46437(12, 12).method_46431();
        this.checkGui();
        this.method_37063((class_364)this.prevRecipe);
        this.method_37063((class_364)this.nextRecipe);
        this.method_37063((class_364)this.prevTypePage);
        this.method_37063((class_364)this.nextTypePage);
        int width = 24;
        int height = 24;
        this.viewTypeButtons.clear();
        for (int i = 0; i < ((RecipeViewMenu)this.method_17577()).getViewTypeOrder().size(); ++i) {
            int tempId = i % 5;
            int xPos = this.field_22789 / 2 - (5 * width / 2 + 4) + tempId * width + tempId * 2;
            int yPos = this.field_2800 - height - 1;
            this.viewTypeButtons.add(new ViewTypeButton(this, xPos, yPos, width, height, ((RecipeViewMenu)this.method_17577()).getViewTypeOrder().get(i), i));
        }
    }

    protected void checkGui() {
        this.prevRecipe.field_22763 = ((RecipeViewMenu)this.method_17577()).hasPrevRecipe();
        this.nextRecipe.field_22763 = ((RecipeViewMenu)this.method_17577()).hasNextRecipe();
        this.prevTypePage.field_22764 = this.viewTypePage > 0;
        this.nextTypePage.field_22764 = this.viewTypePage < (((RecipeViewMenu)this.method_17577()).getViewTypeOrder().size() - 1) / 5;
        this.field_2779 = ((RecipeViewMenu)this.method_17577()).getHeight();
        this.field_2792 = ((RecipeViewMenu)this.method_17577()).getWidth();
        this.field_2800 = 32;
        this.prevRecipe.method_48229(this.field_2776 + 8, this.field_2800 + 4);
        this.nextRecipe.method_48229(this.field_2776 + this.field_2792 - 8 - 12, this.field_2800 + 4);
        this.prevTypePage.method_48229(this.field_22789 / 2 - 64 - 2 - 12, this.field_2800 - 1 - 12 - 6);
        this.nextTypePage.method_48229(this.field_22789 / 2 + 64 + 2, this.field_2800 - 1 - 12 - 6);
        this.guiTitle = ((RecipeViewMenu)this.method_17577()).getViewType().getDisplayName();
        this.field_25267 = this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.guiTitle) / 2;
        this.page = this.createPageComponent();
        this.animationTickCache.clear();
        this.checkTickers();
        this.transferButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.transferButtons.clear();
        int guiLeft = this.field_2776 + ((RecipeViewMenu)this.method_17577()).guiOffsetLeft();
        for (int i = 0; i < ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().size(); ++i) {
            IEivViewRecipe currentView = ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().get(i);
            int guiTop = this.field_2800 + ((RecipeViewMenu)this.method_17577()).guiOffsetTop(i);
            int finalI = i;
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button1 -> {
                if (!currentView.supportsItemTransfer()) {
                    return;
                }
                class_310.method_1551().method_1507(((RecipeViewMenu)this.method_17577()).getParentScreen());
                class_746 player = class_310.method_1551().field_1724;
                if (player != null && EivUtil.matchesAnyTransferClass(currentView, class_310.method_1551().field_1755)) {
                    if (!currentView.canTransferToScreen((class_465)class_310.method_1551().field_1755)) {
                        return;
                    }
                    IEivViewRecipe.RecipeTransferMap map = new IEivViewRecipe.RecipeTransferMap();
                    currentView.mapRecipeItems(map, (class_465)class_310.method_1551().field_1755);
                    RecipeTransferData transferData = ((RecipeViewMenu)this.method_17577()).getTransferData().get(finalI);
                    HashMap<Integer, HashMap<Integer, class_1799>> usedPlayerSlots = RecipeViewScreen.method_25442() ? transferData.getStackedData().getUsedPlayerSlots() : transferData.getUsedPlayerSlots();
                    CommonEIV.networkManager().sendPacketToServer(new ServerboundTransferPayload(map.getTransferMap(), usedPlayerSlots));
                }
            }).method_46437(12, 12).method_46433(guiLeft + currentView.getViewType().getDisplayWidth() + 4, guiTop + currentView.getViewType().getDisplayHeight() / 2 - 6).method_46431();
            RecipeTransferData data = ((RecipeViewMenu)this.method_17577()).getTransferData().get(i);
            button.field_22763 = data.isSuccess() && currentView.supportsItemTransfer() && EivUtil.matchesAnyTransferClass(currentView, ((RecipeViewMenu)this.method_17577()).getParentScreen()) && currentView.canTransferToScreen((class_465)((RecipeViewMenu)this.method_17577()).getParentScreen());
            button.field_22764 = currentView.supportsItemTransfer();
            this.method_37063((class_364)button);
            this.transferButtons.add(button);
        }
    }

    private void checkTickers() {
        this.animationTickers.forEach(animationTicker -> this.animationTickCache.put(animationTicker.id(), animationTicker.getTick()));
        this.animationTickers.clear();
        ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().forEach(recipe -> recipe.getAnimationTickers().forEach(animationTicker -> {
            this.animationTickers.add((AnimationTicker)animationTicker);
            if (this.animationTickCache.containsKey(animationTicker.id())) {
                animationTicker.setTick(this.animationTickCache.get(animationTicker.id()));
            } else {
                animationTicker.resetTick();
            }
        }));
    }

    protected void method_2388(class_332 guiGraphics, int i, int j) {
        guiGraphics.method_51439(this.field_22793, this.guiTitle, this.field_25267, this.field_25268, -12566464, false);
        guiGraphics.method_51439(this.field_22793, this.page, (this.field_2792 - this.field_22793.method_27525((class_5348)this.page)) / 2, this.field_2779 - 12, -12566464, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    @NotNull
    protected List<class_2561> method_51454(class_1799 itemStack) {
        List tooltip = super.method_51454(itemStack);
        class_2487 tagTag = ((class_9279)itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (tagTag.method_10545("eiv_recipeTag")) {
            tooltip.add(class_2561.method_43471((String)"view.eiv.tags").method_27693(": ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)("#" + tagTag.method_68564("eiv_recipeTag", "Error"))).method_27692(class_124.field_1080)));
        }
        if (this.field_2787 != null && this.field_2787.method_7681()) {
            ((RecipeViewMenu)this.method_17577()).getAdditionalStackModifier(this.field_2787.method_34266()).addTooltip(itemStack, tooltip);
        }
        tooltip.addLast(class_2561.method_43470((String)CommonEIVClient.resolver().getModNameForItem(itemStack.method_7909())).method_27692(class_124.field_1078).method_27692(class_124.field_1056));
        return tooltip;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX <= (double)this.field_2776 && mouseX >= (double)(this.field_2776 - 25) && mouseY >= (double)this.field_2800 && mouseY <= (double)(this.field_2800 + this.field_2779)) {
            if (scrollY < 0.0) {
                ((RecipeViewMenu)this.method_17577()).nextReference();
            }
            if (scrollY > 0.0) {
                ((RecipeViewMenu)this.method_17577()).prevReference();
            }
            return true;
        }
        if (!(mouseX >= (double)this.field_2776 && mouseX <= (double)(this.field_2776 + this.field_2792) && mouseY >= (double)this.field_2800 && mouseY <= (double)(this.field_2800 + this.field_2779))) {
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        if (scrollY < 0.0) {
            ((RecipeViewMenu)this.method_17577()).nextPage();
            this.checkTickers();
        }
        if (scrollY > 0.0) {
            ((RecipeViewMenu)this.method_17577()).prevPage();
            this.checkTickers();
        }
        if (scrollY != 0.0) {
            this.page = this.createPageComponent();
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1 && this.field_2787 != null) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.field_2787.method_7677(), ItemViewOverlay.ItemViewOpenType.INPUT);
            return true;
        }
        if (mouseButton == 0 && this.field_2787 != null) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.field_2787.method_7677(), ItemViewOverlay.ItemViewOpenType.RESULT);
            return true;
        }
        if (mouseButton == 0) {
            for (int i = this.viewTypePage * 5; i < this.viewTypePage * 5 + 5 && this.viewTypeButtons.size() > i; ++i) {
                if (!this.viewTypeButtons.get(i).onClick(mouseButton, (int)mouseX, (int)mouseY)) continue;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    private boolean isPrevTypeHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 - 14 - 2) && mouseX <= (double)(this.field_2776 - 2) && mouseY >= (double)(this.field_2800 + 2) && mouseY <= (double)(this.field_2800 + 2 + 14);
    }

    private boolean isNextTypeHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + this.field_2792 + 2) && mouseX <= (double)(this.field_2776 + this.field_2792 + 2 + 14) && mouseY >= (double)(this.field_2800 + 2) && mouseY <= (double)(this.field_2800 + 2 + 14);
    }

    protected void method_37432() {
        this.animationTickers.forEach(AnimationTicker::tick);
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        long timeOpen = this.field_22787.field_1724.field_17892.method_8510() - this.timestamp;
        if (timeOpen % 25L == 0L && timeOpen >= 25L) {
            ((RecipeViewMenu)this.method_17577()).tickContents();
        }
        ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().forEach(IEivViewRecipe::tick);
    }

    public int getLeftPos() {
        return this.field_2776;
    }

    public int getTopPos() {
        return this.field_2800;
    }

    public int getGuiWidth() {
        return this.field_2792;
    }

    public int getGuiHeight() {
        return this.field_2779;
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779 - 3, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_2776, this.field_2800 + (this.field_2779 - 3), 0.0f, 253.0f, this.field_2792, 3, 256, 256);
        IEivRecipeViewType viewType = ((RecipeViewMenu)this.method_17577()).getViewType();
        int current = ((RecipeViewMenu)this.method_17577()).getCurrentTypeIndex();
        for (i = 0; i < 5; ++i) {
            guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_22789 / 2 - 64 + i * 24 + i * 2, this.field_2800 - 24 - 1, 208.0f, 0.0f, 24, 24, 256, 256);
        }
        for (i = this.viewTypePage * 5; i < this.viewTypePage * 5 + 5 && this.viewTypeButtons.size() > i; ++i) {
            this.viewTypeButtons.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        for (i = 0; i < ((RecipeViewMenu)this.method_17577()).getDisplayableCraftReferences(); ++i) {
            guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_2776 - 25, this.field_2800 + 4 + i * 24 + i, 231.0f, 48.0f, 25, 24, 256, 256);
        }
        if (((RecipeViewMenu)this.method_17577()).getCurrentCraftReference() > 0) {
            guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_2776 - 4 - 5 - 8, this.field_2800 + 4 - 1 - 4, 248.0f, 72.0f, 8, 4, 256, 256);
        }
        if (((RecipeViewMenu)this.method_17577()).getCurrentCraftReference() < ((RecipeViewMenu)this.method_17577()).getViewType().getCraftReferences().size() - ((RecipeViewMenu)this.method_17577()).getDisplayableCraftReferences()) {
            guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.field_2776 - 4 - 5 - 8, this.field_2800 + 4 + ((RecipeViewMenu)this.method_17577()).getDisplayableCraftReferences() * 25, 248.0f, 76.0f, 8, 4, 256, 256);
        }
        int guiLeft = this.field_2776 + ((RecipeViewMenu)this.method_17577()).guiOffsetLeft();
        for (int i2 = 0; i2 < ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().size(); ++i2) {
            int guiTop = this.field_2800 + ((RecipeViewMenu)this.method_17577()).guiOffsetTop(i2);
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)guiLeft, (float)guiTop);
            guiGraphics.method_25290(class_10799.field_56883, viewType.getGuiTexture(), 0, 0, 0.0f, 0.0f, viewType.getDisplayWidth(), viewType.getDisplayHeight(), viewType.getDisplayWidth(), viewType.getDisplayHeight());
            ((RecipeViewMenu)this.method_17577()).field_7761.stream().filter(slot -> ((RecipeViewMenu)this.method_17577()).isOptionalSlot(slot.field_7874) && slot.method_7681()).forEach(slot -> {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)(slot.field_7873 - (guiLeft - this.field_2776) - 1), (float)(slot.field_7872 - (guiTop - this.field_2800) - 1));
                ((RecipeViewMenu)this.method_17577()).getOptionalSlotRenderer(slot.field_7874).render(guiGraphics, mouseX - guiLeft, mouseY - guiTop, partialTicks);
                guiGraphics.method_51448().popMatrix();
            });
            this.renderInvalidSlots(guiGraphics, i2);
            ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().get(i2).renderRecipe(this, new IEivViewRecipe.RecipePosition(guiLeft, guiTop, viewType.getDisplayWidth(), viewType.getDisplayHeight()), guiGraphics, mouseX - guiLeft, mouseY - guiTop, partialTicks);
            guiGraphics.method_51448().popMatrix();
        }
    }

    private void renderInvalidSlots(class_332 guiGraphics, int displayId) {
        class_4185 button = this.transferButtons.get(displayId);
        if (!button.method_49606()) {
            return;
        }
        IEivViewRecipe current = ((RecipeViewMenu)this.method_17577()).getCurrentDisplay().get(displayId);
        RecipeTransferData data = ((RecipeViewMenu)this.method_17577()).getTransferData().get(displayId);
        if (data.isSuccess()) {
            return;
        }
        for (int slotId : data.getSlotResults().keySet()) {
            if (data.getSlotResults().get(slotId).booleanValue()) continue;
            int actualSlotId = slotId + displayId * current.getViewType().getSlotCount();
            class_1735 invSlot = ((RecipeViewMenu)this.method_17577()).method_7611(actualSlotId);
            int x = invSlot.field_7873;
            int y = invSlot.field_7872;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)(-((RecipeViewMenu)this.method_17577()).guiOffsetLeft()), (float)(-((RecipeViewMenu)this.method_17577()).guiOffsetTop(displayId)));
            guiGraphics.method_25294(x, y, x + 16, y + 16, new Color(255, 0, 0, 64).getRGB());
            guiGraphics.method_51448().popMatrix();
        }
    }

    record ViewTypeButton(RecipeViewScreen viewScreen, int x, int y, int width, int height, IEivRecipeViewType viewType, int viewTypeId) {
        private boolean onClick(int mouseButton, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
                return false;
            }
            ((RecipeViewMenu)this.viewScreen.method_17577()).setViewType(this.viewTypeId);
            class_339.method_62888((class_1144)class_310.method_1551().method_1483());
            return true;
        }

        private void onHover(class_332 guiGraphics, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
                return;
            }
            guiGraphics.method_51434(class_310.method_1551().field_1772, List.of(this.viewType.getDisplayName()), mouseX, mouseY);
        }

        private void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            guiGraphics.method_25290(class_10799.field_56883, VIEW_LOCATION, this.x(), this.y(), 232.0f, this.viewType() == ((RecipeViewMenu)this.viewScreen.method_17577()).getViewType() ? 24.0f : 0.0f, 24, 24, 256, 256);
            guiGraphics.method_51445(this.viewType().getIcon(), this.x() + 4, this.y() + 4);
            this.onHover(guiGraphics, mouseX, mouseY);
        }
    }
}

