/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import com.mojang.datafixers.util.Either;
import de.crafty.eiv.common.extra.FluidStack;
import de.crafty.eiv.common.mixin.world.item.crafting.IngredientAccessor;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class SlotContent {
    private final List<class_1799> content;
    private int current;
    private class_6862<class_1792> itemTag;
    private class_1799 itemOrigin;
    private Type originType;
    private Type type;

    private SlotContent(List<class_1799> content) {
        ArrayList<class_1799> copied = new ArrayList<class_1799>();
        content.stream().map(class_1799::method_7972).forEach(copied::add);
        this.content = copied;
        this.current = 0;
        this.itemOrigin = class_1799.field_8037;
        this.originType = Type.ANY;
        this.type = Type.INGREDIENT;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    private SlotContent bindItemTag(class_6862<class_1792> tag) {
        this.itemTag = tag;
        this.setDataComponent();
        return this;
    }

    public void bindOrigin(class_1799 stack, Type originType) {
        this.itemOrigin = stack.method_7972();
        this.originType = originType;
    }

    public int size() {
        return this.content.size();
    }

    public boolean isEmpty() {
        return this.content.stream().filter(class_1799::method_7960).count() == (long)this.content.size();
    }

    public int index() {
        if (this.hasItem(this.itemOrigin.method_7909()) && this.originType == this.type) {
            return this.getNextMatching(this.itemOrigin);
        }
        return this.current;
    }

    public class_1799 getByIndex(int index) {
        return this.content.isEmpty() ? class_1799.field_8037 : this.content.get(index).method_7972();
    }

    public class_1799 next() {
        ++this.current;
        if (this.current >= this.content.size()) {
            this.current = 0;
        }
        return this.getByIndex(this.index());
    }

    public void resetPointer() {
        this.current = 0;
        this.itemOrigin = class_1799.field_8037;
        this.originType = Type.ANY;
    }

    public List<class_1799> getValidContents() {
        return this.content;
    }

    private void setDataComponent() {
        if (this.itemTag().isEmpty()) {
            return;
        }
        this.content.forEach(stack -> {
            class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
            tag.method_10582("eiv_recipeTag", this.itemTag().get().comp_327().toString());
            class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)stack, (class_2487)tag);
        });
    }

    public boolean hasItem(class_1792 check) {
        return this.content.stream().anyMatch(stack -> stack.method_7909() == check);
    }

    public int getNextMatching(class_1799 origin) {
        for (int i = this.current; i < this.content.size() + this.current; ++i) {
            int index = i < this.content.size() ? i : i - this.content.size();
            class_1799 stack = this.content.get(index);
            if (stack.method_7909() != origin.method_7909()) continue;
            boolean potionCheck = ItemViewRecipes.makePotionCheck(origin, stack);
            boolean enchantCheck = ItemViewRecipes.makeEnchantmentCheck(origin, stack);
            if (!potionCheck || !enchantCheck) continue;
            return index;
        }
        return this.current;
    }

    public Optional<class_6862<class_1792>> itemTag() {
        return this.itemTag == null ? Optional.empty() : Optional.of(this.itemTag);
    }

    public static SlotContent of() {
        return new SlotContent(List.of());
    }

    public static SlotContent of(class_1792 item) {
        return new SlotContent(List.of(new class_1799((class_1935)item)));
    }

    public static SlotContent ofItemList(List<class_1792> items) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        items.forEach(item -> stacks.add(new class_1799((class_1935)item)));
        return SlotContent.of(stacks);
    }

    public static SlotContent of(FluidStack fluidStack) {
        return new SlotContent(List.of(fluidStack.createItemStack()));
    }

    public static SlotContent ofFluidList(List<FluidStack> fluidStacks) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        fluidStacks.forEach(fluidStack -> stacks.add(fluidStack.createItemStack()));
        return new SlotContent(stacks);
    }

    public static SlotContent of(class_1799 stack) {
        return new SlotContent(List.of(stack));
    }

    public static SlotContent of(List<class_1799> stacks) {
        return new SlotContent(stacks);
    }

    public static SlotContent of(class_6862<class_1792> itemTag) {
        ArrayList items = new ArrayList();
        SlotContent.getItemsFromTag(itemTag).ifPresent(holders -> holders.forEach(holder -> items.add((class_1792)holder.comp_349())));
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        items.forEach(item -> stacks.add(new class_1799((class_1935)item)));
        return new SlotContent(stacks).bindItemTag(itemTag);
    }

    public static SlotContent of(class_1856 ingredient) {
        if (ingredient == null) {
            return SlotContent.of();
        }
        Either ingredientContent = ((IngredientAccessor)ingredient).getValues().method_40248();
        if (ingredientContent.right().isPresent()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            ((List)ingredientContent.right().get()).forEach(holder -> stacks.add(new class_1799((class_1935)holder.comp_349())));
            return new SlotContent(stacks);
        }
        return ingredientContent.left().isPresent() ? SlotContent.of((class_6862<class_1792>)((class_6862)ingredientContent.left().get())) : SlotContent.of(class_1802.field_8162);
    }

    public static Optional<class_6885.class_6888<class_1792>> getItemsFromTag(class_6862<class_1792> tag) {
        return class_7923.field_41178.method_46733(tag);
    }

    public static enum Type {
        INGREDIENT,
        RESULT,
        ANY;

    }
}

