/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.entity;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.entity.EntityServerRecipe;
import de.crafty.eiv.common.builtin.entity.EntityViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.rendering.EivGuiRenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_638;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityViewRecipe
implements IEivViewRecipe {
    private final class_1299<?> entityType;
    private final List<SlotContent> drops;
    private class_1309 previewEntity;
    private int animationTick = 0;
    private boolean hovered = false;

    public EntityViewRecipe(EntityServerRecipe serverRecipe) {
        this.entityType = serverRecipe.getEntityType();
        List<class_1799> drops = serverRecipe.getDrops();
        ArrayList<SlotContent> dropContents = new ArrayList<SlotContent>();
        for (int i = 0; i < this.getViewType().getSlotCount(); ++i) {
            if (drops.size() > i) {
                dropContents.add(SlotContent.of(drops.get(i)));
                continue;
            }
            dropContents.add(SlotContent.of());
        }
        this.drops = dropContents;
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return EntityViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        for (int i = 0; i < this.drops.size(); ++i) {
            if (i < 9) {
                slotFillContext.bindSlot(i, this.drops.get(i));
                continue;
            }
            slotFillContext.bindOptionalSlot(i, this.drops.get(i), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
        }
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of();
    }

    @Override
    public List<SlotContent> getResults() {
        return this.drops;
    }

    @Override
    public void tick() {
        if (this.hovered) {
            return;
        }
        ++this.animationTick;
        if (this.animationTick >= 360) {
            this.animationTick = 0;
        }
    }

    @Override
    public void initRecipe() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = this.getEntityType().method_5883((class_1937)level, class_3730.field_52444);
        if (entity instanceof class_1309) {
            class_1309 livingEntity;
            this.previewEntity = livingEntity = (class_1309)entity;
            this.previewEntity.method_5636(30.0f);
            this.previewEntity.method_5847(30.0f);
        }
    }

    @Override
    public void fadeRecipe() {
        if (this.previewEntity != null) {
            this.previewEntity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_2561 entityName = this.entityType.method_5897();
        this.renderEntity(screen, recipePosition, guiGraphics, mouseX, mouseY, partialTicks);
        this.hovered = mouseX >= 65 && mouseX <= 97 && mouseY >= 0 && mouseY <= 32;
        if (this.hovered) {
            guiGraphics.method_51434(screen.method_64506(), List.of(class_2561.method_43473().method_10852(entityName).method_27692(class_124.field_1065)), recipePosition.left() + mouseX, recipePosition.top() + mouseY);
        }
    }

    private void renderEntity(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.previewEntity == null) {
            return;
        }
        float scale = 12.0f;
        class_238 boundingBox = this.previewEntity.method_5829();
        if (boundingBox.method_17940() * (double)scale > 26.0) {
            scale = (float)(26.0 / boundingBox.method_17940());
        }
        EivGuiRenderHelper.renderEntityOnScreen(guiGraphics, this.previewEntity, recipePosition.left() + 67, recipePosition.top() + 2, recipePosition.left() + 67 + 28, recipePosition.top() + 2 + 28, scale, new Vector3f(0.0f, 28.0f / scale / 2.0f, 0.0f), new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), ((float)this.animationTick + partialTicks) / 180.0f * (float)Math.PI, 0.0f), null);
    }
}

