/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.shaped;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.shaped.CraftingViewType;
import de.crafty.eiv.common.builtin.shaped.ShapedServerRecipe;
import de.crafty.eiv.common.builtin.tipped_arrow.TippedArrowServerRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_9334;

public class CraftingViewRecipe
implements IEivViewRecipe {
    private final HashMap<Integer, SlotContent> ingredientSlotContents = new HashMap();
    private final SlotContent result;
    private final int width;
    private final int height;

    public CraftingViewRecipe(ShapedServerRecipe recipe) {
        this.width = recipe.getWidth();
        this.height = recipe.getHeight();
        recipe.getIngredients().forEach((slotId, ingredient) -> this.ingredientSlotContents.put((Integer)slotId, SlotContent.of(ingredient)));
        this.result = SlotContent.of(recipe.getResult());
    }

    public CraftingViewRecipe(TippedArrowServerRecipe recipe) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4) {
                this.ingredientSlotContents.put(i, SlotContent.of(recipe.getPotion()));
                continue;
            }
            this.ingredientSlotContents.put(i, SlotContent.of(class_1802.field_8107));
        }
        this.width = 3;
        this.height = 3;
        class_1799 result = new class_1799((class_1935)class_1802.field_8087, 8);
        result.method_57379(class_9334.field_49651, (Object)((class_1844)recipe.getPotion().method_58694(class_9334.field_49651)));
        this.result = SlotContent.of(result);
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return CraftingViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        this.ingredientSlotContents.forEach(slotFillContext::bindSlot);
        slotFillContext.bindSlot(9, this.result);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return this.ingredientSlotContents.values().stream().toList();
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    public boolean supportsItemTransfer() {
        return true;
    }

    @Override
    public List<Class<? extends class_465<?>>> getTransferClasses() {
        return List.of(class_479.class, class_490.class);
    }

    @Override
    public boolean canTransferToScreen(class_465<?> screen) {
        return screen instanceof class_479 || this.width <= 2 && this.height <= 2;
    }

    @Override
    public void mapRecipeItems(IEivViewRecipe.RecipeTransferMap map, class_465<?> screen) {
        if (!(screen instanceof class_490)) {
            map.linkSlots(0, 1);
            map.linkSlots(1, 2);
            map.linkSlots(2, 3);
            map.linkSlots(3, 4);
            map.linkSlots(4, 5);
            map.linkSlots(5, 6);
            map.linkSlots(6, 7);
            map.linkSlots(7, 8);
            map.linkSlots(8, 9);
        } else {
            class_490 invScreen = (class_490)screen;
            map.linkSlots(0, 1);
            map.linkSlots(1, 2);
            map.linkSlots(3, 3);
            map.linkSlots(4, 4);
        }
    }
}

