/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.villager;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.rendering.EivGuiRenderHelper;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VillagerViewRecipe
implements IEivViewRecipe {
    private final SlotContent offer;
    private final SlotContent cost1;
    private final SlotContent cost2;
    protected VillagerServerRecipe.VillagerOffer villagerOffer;
    private class_1646 previewVillager = null;
    private boolean prevVillagerLookLeft;
    private boolean villagerLookLeft = false;
    private int lastHeadChange;
    private int currentTick = 0;
    private final Random random;

    public VillagerViewRecipe(VillagerServerRecipe.VillagerOffer villagerOffer) {
        this.offer = SlotContent.of(villagerOffer.offerStacks());
        this.cost1 = SlotContent.of(villagerOffer.cost1());
        this.cost2 = SlotContent.of(villagerOffer.cost2());
        this.villagerOffer = villagerOffer;
        this.random = new Random();
        if (class_310.method_1551().field_1687 != null) {
            this.prevVillagerLookLeft = this.villagerLookLeft = this.random.nextBoolean();
        }
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return VillagerViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindDepedantSlot(0, this.offer::index, this.cost1);
        slotFillContext.bindSlot(1, this.cost2);
        slotFillContext.bindSlot(2, this.offer);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.cost1, this.cost2);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.offer);
    }

    @Override
    public void tick() {
        ++this.currentTick;
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        if (this.currentTick - this.lastHeadChange < 60) {
            return;
        }
        this.prevVillagerLookLeft = this.villagerLookLeft;
        this.villagerLookLeft = this.random.nextBoolean();
        this.lastHeadChange = this.currentTick;
    }

    @Override
    public void initRecipe() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        this.previewVillager = (class_1646)class_1299.field_6077.method_5883((class_1937)level, class_3730.field_52444);
        if (this.previewVillager == null) {
            return;
        }
        this.previewVillager.method_7195(this.previewVillager.method_7231().method_16920(this.villagerOffer.professionLevel()).method_66687((class_7871.class_7872)level.method_30349(), class_3854.field_17073).method_66688((class_7871.class_7872)level.method_30349(), this.villagerOffer.profession()));
        this.previewVillager.method_5977(true);
        this.previewVillager.method_5847((this.villagerLookLeft ? -1.0f : 1.0f) * 15.0f);
        if (this.villagerOffer.requiredtype() != null) {
            this.previewVillager.method_7195(this.previewVillager.method_7231().method_16922((class_6880)level.method_30349().method_30530(class_7924.field_41235).method_46747(this.villagerOffer.requiredtype())));
        }
    }

    @Override
    public void fadeRecipe() {
        if (this.previewVillager != null) {
            this.previewVillager.method_5650(class_1297.class_5529.field_26999);
        }
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_327 font = class_310.method_1551().field_1772;
        class_5321<class_3852> profession = this.villagerOffer.profession();
        String namespace = profession.method_29177().method_12836();
        String path = profession.method_29177().method_12832();
        float scale = 0.75f;
        class_5250 professionComp = class_2561.method_43471((String)("entity." + namespace + ".villager." + path)).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)("merchant.level." + this.villagerOffer.professionLevel()))).method_27692(class_124.field_1063);
        guiGraphics.method_51448().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = guiGraphics.method_51448();
        Objects.requireNonNull(font);
        matrix3x2fStack.translate(0.0f, (float)(-9) * scale);
        guiGraphics.method_51448().scale(scale, scale);
        guiGraphics.method_51439(font, (class_2561)professionComp, 0, 0, -1, false);
        guiGraphics.method_51448().popMatrix();
        if (this.villagerLookLeft != this.prevVillagerLookLeft && (float)(this.currentTick - this.lastHeadChange) <= 5.0f) {
            float pastTime = (float)(this.currentTick - this.lastHeadChange) + partialTicks;
            float headRotationProgress = pastTime / 5.0f;
            this.previewVillager.method_5847((this.villagerLookLeft ? -1.0f : 1.0f) * (15.0f * headRotationProgress));
        }
        this.renderVillager(guiGraphics, recipePosition, mouseX, mouseY, partialTicks);
        if (this.villagerOffer.requiredtype() == null) {
            return;
        }
        if (mouseX >= 0 && mouseX <= 24 && mouseY >= 0 && mouseY <= 36) {
            class_2960 typeLocation = this.villagerOffer.requiredtype().method_29177();
            class_5250 typeComponent = class_2561.method_43471((String)("view.eiv.type.trading." + typeLocation.method_12836() + "." + typeLocation.method_12832())).method_27692(class_124.field_1065);
            guiGraphics.method_51434(font, List.of(typeComponent), recipePosition.left() + mouseX, recipePosition.top() + mouseY);
        }
    }

    private void renderVillager(class_332 guiGraphics, IEivViewRecipe.RecipePosition recipePosition, int mouseX, int mouseY, float partialTicks) {
        if (this.previewVillager == null) {
            return;
        }
        EivGuiRenderHelper.renderEntityOnScreen(guiGraphics, (class_1309)this.previewVillager, recipePosition.left() + 2, recipePosition.top() + 2, recipePosition.left() + 2 + 20, recipePosition.top() + 2 + 32, 15.0f, new Vector3f(0.0f, 1.0666667f, 0.0f), new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), 0.0f, 0.0f), null);
    }
}

