/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.network;

import de.crafty.eiv.common.network.EivPayloadConverter;
import de.crafty.eiv.common.network.payload.ServerboundRequestEivUpdate;
import de.crafty.eiv.common.network.payload.compat.ClientboundCompatPayload;
import de.crafty.eiv.common.network.payload.mode.ServerboundPickCheatmodeItemPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStartStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.transfer.ClientboundUpdateTransferCachePayload;
import de.crafty.eiv.common.network.payload.transfer.ServerboundTransferPayload;
import de.crafty.eiv.common.recipe.ClientRecipeManager;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.cache.LowEndRecipeCache;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import java.util.HashMap;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class EivNetworkManager {
    public static final EivNetworkManager INSTANCE = new EivNetworkManager().registerPayloads();
    private final HashMap<class_2960, class_8710.class_9155<?, ?>> clientbound = new HashMap();
    private final HashMap<class_2960, class_8710.class_9155<?, ?>> serverbound = new HashMap();
    private final HashMap<class_2960, PayloadHandler<ClientContext, ? extends class_8710>> clientPayloadHandlers = new HashMap();
    private final HashMap<class_2960, PayloadHandler<ServerContext, ? extends class_8710>> serverPayloadHandlers = new HashMap();

    private EivNetworkManager() {
    }

    private <B extends class_2540, T extends class_8710> void registerClientbound(class_8710.class_9154<T> type, class_9139<B, T> codec, PayloadHandler<ClientContext, T> clientHandler) {
        this.clientbound.put(type.comp_2242(), new class_8710.class_9155(type, codec));
        this.clientPayloadHandlers.put(type.comp_2242(), clientHandler);
    }

    private <B extends class_2540, T extends class_8710> void registerServerbound(class_8710.class_9154<T> type, class_9139<B, T> codec, PayloadHandler<ServerContext, T> serverHandler) {
        this.serverbound.put(type.comp_2242(), new class_8710.class_9155(type, codec));
        this.serverPayloadHandlers.put(type.comp_2242(), serverHandler);
    }

    public HashMap<class_2960, class_8710.class_9155<?, ?>> getClientbound() {
        return this.clientbound;
    }

    public HashMap<class_2960, class_8710.class_9155<?, ?>> getServerbound() {
        return this.serverbound;
    }

    public HashMap<class_2960, PayloadHandler<ClientContext, ? extends class_8710>> clientPayloadHandlers() {
        return this.clientPayloadHandlers;
    }

    public HashMap<class_2960, PayloadHandler<ServerContext, ? extends class_8710>> serverPayloadHandlers() {
        return this.serverPayloadHandlers;
    }

    public <T extends class_8710> T castPayload(class_8710 payload) {
        return (T)payload;
    }

    public void sendPacketToServer(class_8710 payload) {
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787((class_2596)new class_2817(payload));
        }
    }

    public void sendPacket(class_3222 player, class_8710 payload) {
        player.field_13987.method_14364((class_2596)new class_2658(payload));
    }

    public EivNetworkManager registerPayloads() {
        this.registerServerbound(ServerboundRequestEivUpdate.TYPE, ServerboundRequestEivUpdate.STREAM_CODEC, (context, payload) -> {
            ServerRecipeManager.INSTANCE.updateStackSensitives(context.sender());
            ServerRecipeManager.INSTANCE.informAboutRecipes(context.sender());
        });
        this.registerClientbound(ClientboundStartStackSensitivesPayload.TYPE, ClientboundStartStackSensitivesPayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveStartReceived(payload.amount()));
        this.registerClientbound(ClientboundStackSensitivePayload.TYPE, ClientboundStackSensitivePayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveReceived(payload.stackSensitive()));
        this.registerClientbound(ClientboundFinishStackSensitivesPayload.TYPE, ClientboundFinishStackSensitivesPayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveEndReceived());
        this.registerClientbound(ClientboundStartUpdatesPayload.TYPE, ClientboundStartUpdatesPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(ClientRecipeManager.INSTANCE::startUpdate));
        this.registerClientbound(ClientboundFinishUpdatesPayload.TYPE, ClientboundFinishUpdatesPayload.STREAM_CODEC, (context, payload) -> {
            ClientRecipeManager.INSTANCE.queueTask(ClientRecipeManager.INSTANCE::processRecipes);
            ClientRecipeManager.INSTANCE.runTasks();
        });
        this.registerClientbound(ClientboundCacheStartPayload.TYPE, ClientboundCacheStartPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.cacheStartReceived(payload.types())));
        this.registerClientbound(ClientboundTypeUpdateStartPayload.TYPE, ClientboundTypeUpdateStartPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.startCaching(payload.recipeType(), payload.amount())));
        this.registerClientbound(ClientboundTypeUpdatePayload.TYPE, ClientboundTypeUpdatePayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.cacheModRecipe(payload.entry())));
        this.registerClientbound(ClientboundTypeUpdateEndPayload.TYPE, ClientboundTypeUpdateEndPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.endCaching(payload.recipeType())));
        this.registerServerbound(ServerboundTransferPayload.TYPE, ServerboundTransferPayload.STREAM_CODEC, (context, payload) -> ServerRecipeManager.INSTANCE.performRecipeTransfer(context.sender(), payload.transferMap(), payload.usedPlayerSlots()));
        this.registerClientbound(ClientboundUpdateTransferCachePayload.TYPE, ClientboundUpdateTransferCachePayload.STREAM_CODEC, (context, payload) -> {
            class_437 patt0$temp = context.client.field_1755;
            if (patt0$temp instanceof RecipeViewScreen) {
                RecipeViewScreen viewScreen = (RecipeViewScreen)patt0$temp;
                ((RecipeViewMenu)viewScreen.method_17577()).updateTransferCache();
            }
        });
        this.registerServerbound(ServerboundPickCheatmodeItemPayload.TYPE, ServerboundPickCheatmodeItemPayload.STREAM_CODEC, (context, payload) -> {
            if (context.sender().method_64475(3)) {
                context.sender().method_64398((class_2561)class_2561.method_43470((String)"Cheated x").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(payload.amount())).method_27692(class_124.field_1065)).method_27693(" ").method_10852((class_2561)payload.stack().method_7954().method_27661()));
                context.sender().method_7270(payload.stack().method_46651(payload.amount()));
                context.sender().method_51469().method_43128(null, context.sender().method_23317(), context.sender().method_23318(), context.sender().method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((context.sender().method_59922().method_43057() - context.sender().method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
            } else {
                context.sender().method_64398((class_2561)class_2561.method_43471((String)"cheatmode.eiv.denied").method_27692(class_124.field_1061));
            }
        });
        this.registerClientbound(ClientboundCompatPayload.TYPE, ClientboundCompatPayload.STREAM_CODEC, EivPayloadConverter::convertFromCompat);
        return this;
    }

    public static interface PayloadHandler<S extends Context, T extends class_8710> {
        public void handle(S var1, T var2);
    }

    public record ServerContext(MinecraftServer server, class_3222 sender) implements Context
    {
    }

    public record ClientContext(class_310 client) implements Context
    {
    }

    public static interface Context {
    }
}

