/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.overlay.BlockingGuiComponent;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.overlay.OverlayManager;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEivOverlay {
    private final List<ItemSlot> itemSlots = new ArrayList<ItemSlot>();
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int effectiveX;
    protected int effectiveY;
    protected int effectiveWidth;
    protected int effectiveHeight;
    protected OverlayAlignment overlayAlignment;
    private boolean enabled;
    private boolean enoughSpaceToRender;

    protected AbstractEivOverlay(int defaultX, int defaultY, int defaultWidth, int defaultHeight) {
        this.x = defaultX;
        this.y = defaultY;
        this.width = defaultWidth;
        this.height = defaultHeight;
        this.overlayAlignment = OverlayAlignment.HORIZONTAL;
        this.enabled = true;
        this.enoughSpaceToRender = true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnoughSpaceToRender() {
        return this.enoughSpaceToRender;
    }

    protected boolean keyPressed(int i, int j, int k) {
        for (ItemSlot slot : this.itemSlots()) {
            if (!slot.isHovered()) continue;
            if (CommonEIVClient.USAGE_KEYBIND.method_1417(i, j)) {
                ItemViewOverlay.INSTANCE.openRecipeView(slot.getStack(), ItemViewOverlay.ItemViewOpenType.INPUT);
            }
            if (CommonEIVClient.RECIPE_KEYBIND.method_1417(i, j)) {
                ItemViewOverlay.INSTANCE.openRecipeView(slot.getStack(), ItemViewOverlay.ItemViewOpenType.RESULT);
            }
            return true;
        }
        return false;
    }

    protected boolean charTyped(char c, int i) {
        return false;
    }

    protected abstract boolean mouseClicked(double var1, double var3, int var5);

    protected abstract boolean scrollMouse(double var1, double var3, double var5, double var7);

    public List<ItemSlot> itemSlots() {
        return this.itemSlots;
    }

    public void onScreenChanged(InventoryPositionInfo info) {
        this.updateEffectiveDimensions(info);
    }

    protected void placeWidgets(ScreenContext ctx) {
    }

    protected void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected abstract void render(class_332 var1, int var2, int var3, float var4);

    protected BlockingPredicate getBlockingPredicate() {
        return comp -> true;
    }

    protected boolean isPositionBlocked(int x, int y, int width, int height) {
        List<BlockingGuiComponent> relevantComponents = OverlayManager.INSTANCE.allGuiBlockings().stream().filter(blockingGuiComponent -> this.getBlockingPredicate().isBlocking((BlockingGuiComponent)blockingGuiComponent)).toList();
        for (BlockingGuiComponent blocking : relevantComponents) {
            if (!blocking.hasIntersectionWith(x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    public void updateEffectiveDimensions(InventoryPositionInfo info) {
        this.effectiveX = this.x;
        this.effectiveY = this.y;
        this.effectiveWidth = this.width;
        this.effectiveHeight = this.height;
        if (OverlayManager.INSTANCE.allGuiBlockings().isEmpty()) {
            return;
        }
        List<BlockingGuiComponent> relevantBlockings = OverlayManager.INSTANCE.allGuiBlockings().stream().filter(blockingGuiComponent -> blockingGuiComponent.hasIntersectionWith(this.x, this.y, this.width, this.height)).toList();
        if (relevantBlockings.isEmpty()) {
            return;
        }
        int mostLeftBlock = -1;
        int mostRightBlock = -1;
        int mostTopBlock = -1;
        int mostBottomBlock = -1;
        for (BlockingGuiComponent guiBlocking : relevantBlockings) {
            if (guiBlocking.x() < mostLeftBlock || mostLeftBlock < 0) {
                mostLeftBlock = guiBlocking.x();
            }
            if (guiBlocking.x() + guiBlocking.width() > mostRightBlock || mostRightBlock < 0) {
                mostRightBlock = guiBlocking.x() + guiBlocking.width();
            }
            if (guiBlocking.y() < mostTopBlock || mostTopBlock < 0) {
                mostTopBlock = guiBlocking.y();
            }
            if (guiBlocking.y() + guiBlocking.height() <= mostBottomBlock && mostBottomBlock >= 0) continue;
            mostBottomBlock = guiBlocking.y() + guiBlocking.height();
        }
        if (this.overlayAlignment == OverlayAlignment.HORIZONTAL) {
            if (this.x <= info.screenWidth() / 2) {
                this.effectiveWidth = mostLeftBlock - this.x;
            } else {
                this.effectiveX = mostRightBlock;
                this.effectiveWidth = this.x + this.width - this.effectiveX;
            }
        }
        if (this.overlayAlignment == OverlayAlignment.VERTICAL) {
            if (this.y <= info.screenHeight() / 2) {
                this.effectiveHeight = mostTopBlock - this.y;
            } else {
                this.effectiveY = mostBottomBlock;
                this.effectiveHeight = this.y + this.height - this.effectiveY;
            }
        }
        this.enoughSpaceToRender = this.effectiveX >= 0 && this.effectiveY >= 0 && this.effectiveWidth > 0 && this.effectiveHeight > 0;
    }

    public static enum OverlayAlignment {
        HORIZONTAL,
        VERTICAL;

    }

    public record InventoryPositionInfo(class_465<? extends class_1703> screen, int screenWidth, int screenHeight, int leftPos, int topPos, int imageWidth, int imageHeight) {
        public boolean matches(@Nullable InventoryPositionInfo info) {
            if (info == null) {
                return false;
            }
            return info.screen.equals(this.screen) && info.screenWidth == this.screenWidth && info.screenHeight == this.screenHeight && info.leftPos == this.leftPos && info.topPos == this.topPos && info.imageWidth == this.imageWidth && info.imageHeight == this.imageHeight;
        }
    }

    protected static interface BlockingPredicate {
        public boolean isBlocking(BlockingGuiComponent var1);
    }

    public static class ScreenContext {
        private final List<class_364> renderables = new ArrayList<class_364>();
        private final List<class_364> nonRenderables = new ArrayList<class_364>();

        public <T extends class_364 & class_4068> void addRenderable(T renderable) {
            if (renderable != null) {
                this.renderables.add(renderable);
            }
        }

        public <T extends class_364 & class_6379> void addNonRendarable(T nonRenderable) {
            if (nonRenderable != null) {
                this.nonRenderables.add(nonRenderable);
            }
        }

        public List<class_364> renderables() {
            return this.renderables;
        }

        public List<class_364> nonRenderables() {
            return this.nonRenderables;
        }
    }
}

