/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.entity;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.builtin.entity.EntityViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class EntityViewType
implements IEivRecipeViewType {
    public static final EntityViewType INSTANCE = new EntityViewType();
    private static final List<ItemStack> SPAWN_EGGS = BuiltInRegistries.ITEM.stream().filter(item -> item instanceof SpawnEggItem).map(ItemStack::new).toList();
    private static final IEivRecipeViewType.ReferenceCondition REFERENCE_CONDITION = (craftReference, viewRecipe) -> {
        SpawnEggItem eggItem;
        block3: {
            block2: {
                Item patt0$temp = craftReference.getItem();
                if (!(patt0$temp instanceof SpawnEggItem)) break block2;
                eggItem = (SpawnEggItem)patt0$temp;
                if (viewRecipe instanceof EntityViewRecipe) break block3;
            }
            return true;
        }
        EntityViewRecipe entityViewRecipe = (EntityViewRecipe)viewRecipe;
        return eggItem.getType((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), craftReference) == entityViewRecipe.getEntityType();
    };

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"view.eiv.type.entity");
    }

    @Override
    public int getDisplayWidth() {
        return 162;
    }

    @Override
    public int getDisplayHeight() {
        return 152;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"textures/gui/type/entity.png");
    }

    @Override
    public int getSlotCount() {
        return 54;
    }

    @Override
    public void placeSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        for (int row = 0; row < 6; ++row) {
            for (int i = 0; i < 9; ++i) {
                slotDefinition.addItemSlot(row * 9 + i, i * 18 + 1, 45 + row * 18);
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return ResourceLocation.withDefaultNamespace((String)"entity_loot");
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.IRON_SWORD);
    }

    @Override
    public List<ItemStack> getCraftReferences() {
        return SPAWN_EGGS;
    }

    @Override
    public IEivRecipeViewType.ReferenceCondition getCraftReferenceCondition() {
        return REFERENCE_CONDITION;
    }
}

