/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.mixin.client.gui.screens.inventory;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.BlockingGuiComponent;
import de.crafty.eiv.common.overlay.OverlayManager;
import de.crafty.eiv.common.overlay.itemlist.bookmark.ItemBookmarkOverlay;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class MixinAbstractContainerScreen<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int imageHeight;
    @Shadow
    @Nullable
    protected Slot hoveredSlot;

    @Shadow
    public abstract T getMenu();

    protected MixinAbstractContainerScreen(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void injectOverlay$0(CallbackInfo ci) {
        if (this instanceof AbstractRecipeBookScreen) {
            return;
        }
        AbstractEivOverlay.InventoryPositionInfo info = new AbstractEivOverlay.InventoryPositionInfo((AbstractContainerScreen<? extends AbstractContainerMenu>)((AbstractContainerScreen)this), this.width, this.height, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        OverlayManager.INSTANCE.setGuiBlocking(new BlockingGuiComponent(ResourceLocation.withDefaultNamespace((String)"container"), info.leftPos(), info.topPos(), info.imageWidth(), info.imageHeight()));
        OverlayManager.INSTANCE.checkForScreenChange(info);
        OverlayManager.INSTANCE.updateOverlaysAndWidgets();
        this.updateWidgets();
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")})
    private void injectOverlayBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        OverlayManager.INSTANCE.renderAllBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Inject(method={"renderContents"}, at={@At(value="TAIL")})
    private void injectOverlay$1(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (this.minecraft == null) {
            return;
        }
        AbstractEivOverlay.InventoryPositionInfo info = new AbstractEivOverlay.InventoryPositionInfo((AbstractContainerScreen<? extends AbstractContainerMenu>)((AbstractContainerScreen)this), this.width, this.height, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        OverlayManager.INSTANCE.setGuiBlocking(new BlockingGuiComponent(ResourceLocation.withDefaultNamespace((String)"container"), info.leftPos(), info.topPos(), info.imageWidth(), info.imageHeight()));
        if (OverlayManager.INSTANCE.checkForScreenChange(info)) {
            OverlayManager.INSTANCE.updateOverlaysAndWidgets();
        }
        if (OverlayManager.INSTANCE.hasQueuedWidgetUpdate()) {
            this.updateWidgets();
        }
        OverlayManager.INSTANCE.renderAll(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectOverlay$2(double mouseX, double mouseY, double scrolledX, double scrolledY, CallbackInfoReturnable<Boolean> cir) {
        if (OverlayManager.INSTANCE.scrollMouse(mouseX, mouseY, scrolledX, scrolledY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectOverlay$3(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        GuiEventListener guiEventListener;
        if (OverlayManager.INSTANCE.isTextWidgetFocused() && (guiEventListener = this.getFocused()) instanceof EditBox) {
            EditBox box = (EditBox)guiEventListener;
            box.keyPressed(i, j, k);
            if (i != 256 && i != 258) {
                cir.setReturnValue((Object)true);
            }
            return;
        }
        if (!((AbstractContainerScreen)this instanceof CreativeModeInventoryScreen) && OverlayManager.INSTANCE.keyPressed(i, j, k)) {
            cir.setReturnValue((Object)true);
        }
        if (this.hoveredSlot == null) {
            return;
        }
        if (CommonEIVClient.USAGE_KEYBIND.matches(i, j) && this.hoveredSlot.hasItem()) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.hoveredSlot.getItem(), ItemViewOverlay.ItemViewOpenType.INPUT);
        }
        if (CommonEIVClient.RECIPE_KEYBIND.matches(i, j) && this.hoveredSlot.hasItem()) {
            ItemViewOverlay.INSTANCE.openRecipeView(this.hoveredSlot.getItem(), ItemViewOverlay.ItemViewOpenType.RESULT);
        }
        if (CommonEIVClient.ADD_BOOKMARK_KEYBIND.matches(i, j) && this.hoveredSlot.hasItem()) {
            ItemBookmarkOverlay.INSTANCE.bookmarkItem(this.hoveredSlot.getItem());
        }
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;mouseClicked(DDI)Z"))
    private boolean injectOverlay$3(Screen instance, double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton) | OverlayManager.INSTANCE.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Inject(method={"onClose"}, at={@At(value="HEAD")})
    private void injectOverlay$4(CallbackInfo ci) {
        OverlayManager.INSTANCE.oldWidgets().clear();
        OverlayManager.INSTANCE.screenContextMap().clear();
    }

    @Inject(method={"renderSlotHighlightBack"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventFromRender$0(GuiGraphics guiGraphics, CallbackInfo ci) {
        RecipeViewScreen viewScreen;
        AbstractContainerScreen abstractContainerScreen;
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem() && (abstractContainerScreen = (AbstractContainerScreen)this) instanceof RecipeViewScreen && ((RecipeViewMenu)(viewScreen = (RecipeViewScreen)abstractContainerScreen).getMenu()).isOptionalSlot(this.hoveredSlot.index)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSlotHighlightFront"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventFromRender$1(GuiGraphics guiGraphics, CallbackInfo ci) {
        RecipeViewScreen viewScreen;
        AbstractContainerScreen abstractContainerScreen;
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem() && (abstractContainerScreen = (AbstractContainerScreen)this) instanceof RecipeViewScreen && ((RecipeViewMenu)(viewScreen = (RecipeViewScreen)abstractContainerScreen).getMenu()).isOptionalSlot(this.hoveredSlot.index)) {
            ci.cancel();
        }
    }

    @Unique
    private void updateWidgets() {
        OverlayManager.INSTANCE.oldWidgets().forEach(eventListener -> {
            if (eventListener.isFocused()) {
                this.setFocused(null);
            }
            this.removeWidget((GuiEventListener)eventListener);
        });
        OverlayManager.INSTANCE.oldWidgets().clear();
        OverlayManager.INSTANCE.screenContextMap().forEach((abstractEivOverlay, screenContext) -> {
            screenContext.renderables().forEach(eventListener -> this.addRenderableWidget((GuiEventListener)((NarratableEntry)((Renderable)eventListener))));
            screenContext.nonRenderables().forEach(eventListener -> this.addWidget((GuiEventListener)((NarratableEntry)eventListener)));
        });
        OverlayManager.INSTANCE.setQueuedWidgetUpdate(false);
    }
}

