/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.overlay.itemlist.bookmark;

import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.overlay.AbstractEivOverlay;
import de.crafty.eiv.common.overlay.ItemSlot;
import de.crafty.eiv.common.overlay.itemlist.AbstractEivItemListOverlay;
import java.awt.Color;
import net.minecraft.class_11908;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class ItemBookmarkOverlay
extends AbstractEivItemListOverlay {
    public static final ItemBookmarkOverlay INSTANCE = new ItemBookmarkOverlay();
    private static final int HEADER_HEIGHT = 20;
    private static final int FOOTER_HEIGHT = 40;

    private ItemBookmarkOverlay() {
        super(-1, -1, -1, -1);
    }

    public void bookmarkItem(class_1799 stack) {
        if (!this.availableItems().contains(stack)) {
            this.availableItems().add(stack);
            this.updateSlots();
        }
    }

    @Override
    public void onScreenChanged(AbstractEivOverlay.InventoryPositionInfo info) {
        this.initForScreen(info.screen(), info);
        super.onScreenChanged(info);
        this.updateSlots();
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.fittingPerPage() == 0) {
            return;
        }
        if (this.itemSlots().isEmpty()) {
            return;
        }
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            guiGraphics.method_25294(this.x, this.y, this.width, this.height, new Color(0, 0, 0, 64).getRGB());
        } else {
            guiGraphics.method_25294(this.effectiveX, this.effectiveY, this.effectiveWidth, this.effectiveHeight, new Color(0, 0, 0, 64).getRGB());
        }
    }

    @Override
    protected void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.itemSlots().isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_327 font = client.field_1772;
        if (this.fittingPerPage() <= 0) {
            return;
        }
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            this.drawScaledString(font, guiGraphics, (class_2561)class_2561.method_43471((String)"eiv.bookmarks"), this.x + this.width / 2, 6, -1);
        } else {
            this.drawScaledString(font, guiGraphics, (class_2561)class_2561.method_43471((String)"eiv.bookmarks"), this.effectiveX + this.effectiveWidth / 2, 6, -1);
        }
        String pageString = this.getPage() + 1 + "/" + (this.getMaxPageIndex() + 1);
        if (Configs.CLIENT_SETTINGS.isItemWrapMode()) {
            guiGraphics.method_25300(font, pageString, Math.max(this.width / 2, font.method_1727(pageString) / 2 + 2), this.y + this.height - 2 - 20 - 10, -1);
        } else {
            guiGraphics.method_25300(font, pageString, Math.max(this.effectiveWidth / 2, font.method_1727(pageString) / 2 + 2), this.effectiveY + this.effectiveHeight - 2 - 20 - 10, -1);
        }
        for (ItemSlot slot : this.itemSlots()) {
            slot.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean keyPressed(class_11908 event) {
        super.keyPressed(event);
        for (ItemSlot slot : this.itemSlots()) {
            if (!slot.isHovered()) continue;
            if (!CommonEIVClient.ADD_BOOKMARK_KEYBIND.method_1417(event)) break;
            this.availableItems.remove(slot.getStack());
            this.updateSlots();
            if (this.itemSlots().isEmpty() && !this.availableItems.isEmpty()) {
                this.startIndex = Math.max(0, this.startIndex - this.fittingPerPage());
                this.updateSlots();
            }
            return true;
        }
        return false;
    }

    public void initForScreen(class_465<? extends class_1703> screen, AbstractEivOverlay.InventoryPositionInfo currentInfo) {
        this.x = 0;
        this.y = 0;
        this.width = screen.field_22789 - ((screen.field_22789 - 176) / 2 + 176) - 14 - 40;
        this.width -= (this.width - 4) % 20;
        this.height = screen.field_22790;
        this.itemStartX = 2;
        this.itemStartY = 20;
        this.itemEndX = this.x + this.width - 2;
        this.itemEndY = this.y + this.height - 40;
    }
}

