/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ClientRecipeCache {
    public static final ClientRecipeCache INSTANCE = new ClientRecipeCache();
    private final LinkedHashMap<EivRecipeType<?>, List<ServerRecipeManager.ServerRecipeEntry>> serverEntryMap = new LinkedHashMap();
    private final HashMap<class_2960, List<class_2960>> multiRecipeMap = new LinkedHashMap<class_2960, List<class_2960>>();
    private final HashMap<class_2960, IEivViewRecipe> recipeMap = new HashMap();
    private final HashMap<class_1792, List<class_2960>> byItemIngredient = new HashMap();
    private final HashMap<class_1792, List<class_2960>> byItemResult = new HashMap();
    private final HashMap<class_1792, List<ItemView.StackSensitive>> stackSensitives = new HashMap();

    private ClientRecipeCache() {
    }

    public void clearStackSensitives() {
        this.stackSensitives.clear();
    }

    public void addStackSensitive(ItemView.StackSensitive stackSensitive) {
        List present = this.stackSensitives.getOrDefault(stackSensitive.stack().method_7909(), new ArrayList());
        present.add(stackSensitive);
        this.stackSensitives.put(stackSensitive.stack().method_7909(), present);
    }

    public List<ItemView.StackSensitive> getStackSensitives(class_1792 item) {
        return this.stackSensitives.getOrDefault(item, new ArrayList());
    }

    public IEivViewRecipe getRecipe(class_2960 recipeId) {
        return this.recipeMap.getOrDefault(recipeId, null);
    }

    public void updateType(EivRecipeType<?> type, List<ServerRecipeManager.ServerRecipeEntry> recipes) {
        ((List)this.serverEntryMap.getOrDefault(type, new ArrayList())).forEach(entry -> ((List)this.multiRecipeMap.getOrDefault(entry.modRecipeId(), new ArrayList())).forEach(resourceLocation -> {
            this.recipeMap.remove(resourceLocation);
            this.byItemIngredient.forEach((item, resourceLocations) -> resourceLocations.remove(resourceLocation));
            this.byItemResult.forEach((item, resourceLocations) -> resourceLocations.remove(resourceLocation));
        }));
        this.serverEntryMap.put(type, recipes);
    }

    public List<IEivViewRecipe> getRecipesForCraftingInput(class_1799 inputStack) {
        ArrayList<IEivViewRecipe> recipes = new ArrayList<IEivViewRecipe>();
        this.byItemIngredient.getOrDefault(inputStack.method_7909(), List.of()).forEach(resourceLocation -> recipes.add(this.recipeMap.get(resourceLocation)));
        recipes.removeIf(viewRecipe -> !viewRecipe.redirectsAsIngredient(inputStack) && (viewRecipe.getViewType().getCraftReferences().stream().noneMatch(itemStack -> itemStack.method_7909() == inputStack.method_7909()) || !viewRecipe.getViewType().getCraftReferenceCondition().matches(inputStack, (IEivViewRecipe)viewRecipe)));
        return recipes;
    }

    public List<IEivViewRecipe> getRecipesForCraftingOutput(class_1799 outputStack) {
        ArrayList<IEivViewRecipe> recipes = new ArrayList<IEivViewRecipe>();
        this.byItemResult.getOrDefault(outputStack.method_7909(), List.of()).forEach(resourceLocation -> recipes.add(this.recipeMap.get(resourceLocation)));
        recipes.removeIf(viewRecipe -> !viewRecipe.redirectsAsResult(outputStack));
        return recipes;
    }

    public void sortModType(EivRecipeType<?> type) {
        ItemViewRecipes.ClientRecipeWrapper wrapper = ItemViewRecipes.INSTANCE.wrapperMap().getOrDefault(type, null);
        if (wrapper == null || !this.serverEntryMap.containsKey(type)) {
            return;
        }
        for (ServerRecipeManager.ServerRecipeEntry modEntry : this.serverEntryMap.get(type)) {
            List<IEivViewRecipe> wrappedRecipes;
            try {
                wrappedRecipes = wrapper.wrap(modEntry.asWrapped());
            }
            catch (Exception e) {
                CommonEIV.LOGGER.error("Failed to wrap recipe entry {}: {}, skipping it...", (Object)modEntry.modRecipeId(), (Object)e.getMessage());
                continue;
            }
            if (wrappedRecipes.isEmpty()) continue;
            for (int id = 0; id < wrappedRecipes.size(); ++id) {
                IEivViewRecipe wrapped = wrappedRecipes.get(id);
                class_2960 uniqueId = this.getUniqueId(modEntry, id);
                List summarized = this.multiRecipeMap.getOrDefault(modEntry.modRecipeId(), new ArrayList());
                summarized.add(uniqueId);
                this.multiRecipeMap.put(modEntry.modRecipeId(), summarized);
                this.recipeMap.put(uniqueId, wrapped);
                wrapped.getIngredients().forEach(ingredient -> ingredient.getValidContents().forEach(stack -> {
                    List byIngredient = this.byItemIngredient.getOrDefault(stack.method_7909(), new ArrayList());
                    byIngredient.remove(uniqueId);
                    byIngredient.add(uniqueId);
                    this.byItemIngredient.put(stack.method_7909(), byIngredient);
                }));
                wrapped.getViewType().getCraftReferences().forEach(reference -> {
                    if (!wrapped.getViewType().getCraftReferenceCondition().matches((class_1799)reference, wrapped)) {
                        return;
                    }
                    List byIngredient = this.byItemIngredient.getOrDefault(reference.method_7909(), new ArrayList());
                    byIngredient.remove(uniqueId);
                    byIngredient.add(uniqueId);
                    this.byItemIngredient.put(reference.method_7909(), byIngredient);
                });
                wrapped.getResults().forEach(result -> result.getValidContents().forEach(stack -> {
                    List byResult = this.byItemResult.getOrDefault(stack.method_7909(), new ArrayList());
                    byResult.remove(uniqueId);
                    byResult.add(uniqueId);
                    this.byItemResult.put(stack.method_7909(), byResult);
                }));
            }
        }
    }

    private class_2960 getUniqueId(ServerRecipeManager.ServerRecipeEntry modEntry, int index) {
        return class_2960.method_60655((String)modEntry.modRecipeId().method_12836(), (String)(modEntry.modRecipeId().method_12832() + "/" + index));
    }
}

