/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.config.Configs;
import de.crafty.eiv.common.overlay.OverlayManager;
import de.crafty.eiv.common.overlay.itemlist.bookmark.ItemBookmarkOverlay;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.resolver.IEivClientResolver;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;

public class CommonEIVClient {
    public static final ModelLayerLocation FLUID_ITEM_MODEL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"fluiditem"), "inventory");
    public static final MenuType<RecipeViewMenu> RECIPE_VIEW_MENU = new MenuType(RecipeViewMenu::new, FeatureFlagSet.of());
    public static final KeyMapping.Category EIV_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"eiv"));
    public static final KeyMapping.Category EIV_ADMIN_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"eiv_admin"));
    public static final KeyMapping USAGE_KEYBIND = new KeyMapping("key.eiv.usage", 85, EIV_CATEGORY);
    public static final KeyMapping RECIPE_KEYBIND = new KeyMapping("key.eiv.recipe", 82, EIV_CATEGORY);
    public static final KeyMapping TOGGLE_OVERLAY_KEYBIND = new KeyMapping("key.eiv.toggle_overlay", 79, EIV_CATEGORY);
    public static final KeyMapping ADD_BOOKMARK_KEYBIND = new KeyMapping("key.eiv.bookmark", 65, EIV_CATEGORY);
    public static final KeyMapping GO_BACK_RECIPE = new KeyMapping("key.eiv.go_back", InputConstants.Type.MOUSE, 3, EIV_CATEGORY);
    public static final KeyMapping GO_FORWARD_RECIPE = new KeyMapping("key.eiv.go_forward", InputConstants.Type.MOUSE, 4, EIV_CATEGORY);
    public static final KeyMapping USE_CHEATMODE = new KeyMapping("key.eiv.cheatmode", 342, EIV_ADMIN_CATEGORY);
    public static final List<KeyMapping> EIV_KEY_MAPPINGS = List.of(USAGE_KEYBIND, RECIPE_KEYBIND, TOGGLE_OVERLAY_KEYBIND, ADD_BOOKMARK_KEYBIND, GO_BACK_RECIPE, GO_FORWARD_RECIPE, USE_CHEATMODE);
    private static IEivClientResolver HELPER = null;

    public static void boostrap() {
        OverlayManager.registerOverlay(ItemViewOverlay.INSTANCE);
        OverlayManager.registerOverlay(ItemBookmarkOverlay.INSTANCE);
    }

    public static void setResolver(IEivClientResolver helper) {
        HELPER = helper;
        CommonEIV.LOGGER.info("Helper has been set");
    }

    public static IEivClientResolver resolver() {
        if (HELPER != null) {
            return HELPER;
        }
        throw new IllegalStateException("Helper not set");
    }

    public static void loadConfigs() {
        Configs.CLIENT_SETTINGS.load();
        Configs.BOOKMARKS.load();
    }

    public static void saveConfigs() {
        Configs.CLIENT_SETTINGS.save();
        Configs.BOOKMARKS.save();
    }

    public static boolean isCheatmodeActive() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(3) && InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)CommonEIVClient.USE_CHEATMODE.key.getValue());
    }
}

