/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.command.EivCommand;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@Mod(value="eiv")
public class NeoForgeEIV {
    public NeoForgeEIV(IEventBus eventBus) {
        CommonEIV.LOGGER.info("Hello Minecraft!");
        NeoForge.EVENT_BUS.addListener(this::onCommandRegistry);
        CommonEIV.LOGGER.info("Scanning for integrations...");
        if (FMLLoader.getCurrentOrNull() != null) {
            FMLLoader.getCurrent().getLoadingModList().getMods().forEach(modInfo -> {
                Optional optional = modInfo.getConfigElement(new String[]{"eiv"});
                if (optional.isPresent()) {
                    CommonEIV.LOGGER.info("Loading integration: {}", optional.get());
                    try {
                        Class<?> clazz = Class.forName((String)optional.get());
                        IExtendedItemViewIntegration integration = (IExtendedItemViewIntegration)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        integration.onIntegrationInitialize();
                        CommonEIV.LOGGER.info("Integration initialized for mod: {}", (Object)modInfo.getModId());
                        return;
                    }
                    catch (Exception exception) {
                        CommonEIV.LOGGER.error("Failed to load integration: {}", optional.get());
                    }
                }
            });
        }
    }

    private void onCommandRegistry(RegisterCommandsEvent event) {
        EivCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

