/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.neoforge.mixin.neoforge.registries;

import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.item.FluidItem;
import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.registries.GameData;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GameData.class})
public class MixinGameData {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Redirect(method={"postRegisterEvents"}, at=@At(value="INVOKE", target="Lnet/neoforged/fml/ModLoader;postEventWrapContainerInModOrder(Lnet/neoforged/bus/api/Event;)V"))
    private static <T extends Event> void injectFluidItems(T e) {
        ModLoader.postEventWrapContainerInModOrder(e);
        RegisterEvent event = (RegisterEvent)e;
        if (!event.getRegistryKey().location().equals((Object)Registries.ITEM.location())) {
            return;
        }
        HashMap<Fluid, Item> fluidItemMap = new HashMap<Fluid, Item>();
        BuiltInRegistries.FLUID.forEach(fluid -> {
            if (fluid == Fluids.EMPTY || !fluid.isSource(fluid.defaultFluidState())) {
                return;
            }
            ResourceLocation fluidLocation = BuiltInRegistries.FLUID.getKey(fluid);
            if (event.getRegistry().containsKey(fluidLocation)) {
                fluidItemMap.put((Fluid)fluid, (Item)event.getRegistry().getValue(fluidLocation));
                return;
            }
            event.register(Registries.ITEM, itemRegisterHelper -> itemRegisterHelper.register(fluidLocation, (Object)new FluidItem(fluid.defaultFluidState().createLegacyBlock().getBlock(), new FluidItem.FluidItemProperties().fluid((Fluid)fluid).setItemId((ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)fluidLocation)))));
        });
        ItemViewRecipes.INSTANCE.setFluidItemMap(fluidItemMap);
    }
}

