/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.recipe.inventory.RecipeTransferData;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.inventory.ViewContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RecipeViewMenu
extends AbstractContainerMenu {
    protected static final int MAX_POSSIBLE_HEIGHT = 224;
    protected static final int BUFFER_ZONE = 16;
    protected static final int TOP_SPACE = 24;
    protected static final int BOTTOM_SPACE = 24;
    private final Player player;
    private ViewContainer viewContainer;
    private List<? extends IEivViewRecipe> recipes;
    private IEivRecipeViewType viewType;
    private int maxPossiblePerPage;
    private int maxPageIndex;
    private int currentPage;
    private final List<IEivViewRecipe> currentDisplay;
    private final LinkedHashMap<IEivRecipeViewType, List<IEivViewRecipe>> sortedByType;
    private final List<IEivRecipeViewType> viewTypeOrder;
    private int currentTypeIndex;
    private int menuWidth;
    private int menuHeight;
    private final ItemStack origin;
    private final SlotContent.Type originType;
    private final HashMap<Integer, AdditionalStackModifier> additionalStackModifiers;
    private final HashMap<Integer, OptionalSlotRenderer> optionalSlotRenderers;
    private RecipeViewScreen viewScreen;
    private final Screen parentScreen;
    private final ArrayList<RecipeViewScreen> viewHistory;
    private int currentCraftReference;
    private final List<RecipeTransferData> transferData;

    public RecipeViewMenu(Screen parentScreen, int containerId, Inventory inventory, List<? extends IEivViewRecipe> recipes, ItemStack origin, SlotContent.Type originType, ArrayList<RecipeViewScreen> viewHistory) {
        super(CommonEIVClient.RECIPE_VIEW_MENU, containerId);
        this.viewHistory = viewHistory;
        this.parentScreen = parentScreen;
        this.transferData = new ArrayList<RecipeTransferData>();
        this.currentCraftReference = 0;
        this.origin = origin;
        this.originType = originType;
        this.additionalStackModifiers = new HashMap();
        this.optionalSlotRenderers = new HashMap();
        this.sortedByType = new LinkedHashMap();
        HashMap<IEivRecipeViewType, HashMap> prioOrder = new HashMap<IEivRecipeViewType, HashMap>();
        recipes.forEach(iEivRecipe -> {
            List list = prioOrder.getOrDefault(iEivRecipe.getViewType(), new HashMap()).getOrDefault(iEivRecipe.getPriority(), new ArrayList());
            list.add(iEivRecipe);
            HashMap<Integer, List> map = prioOrder.getOrDefault(iEivRecipe.getViewType(), new HashMap());
            map.put(iEivRecipe.getPriority(), list);
            prioOrder.put(iEivRecipe.getViewType(), map);
        });
        prioOrder.forEach((viewType, map) -> {
            ArrayList list = new ArrayList();
            map.values().forEach(list::addAll);
            this.sortedByType.put((IEivRecipeViewType)viewType, list);
        });
        this.viewTypeOrder = new ArrayList<IEivRecipeViewType>();
        List unsortedTypes = this.sortedByType.keySet().stream().toList();
        HashMap byId = new HashMap();
        unsortedTypes.forEach(viewType -> byId.put(viewType.getId().toString(), viewType));
        ArrayList ids = new ArrayList(byId.keySet());
        ids.sort(String::compareTo);
        ids.forEach(id -> this.viewTypeOrder.add((IEivRecipeViewType)byId.get(id)));
        this.currentTypeIndex = 0;
        this.currentPage = 0;
        this.currentDisplay = new ArrayList<IEivViewRecipe>();
        if (recipes.isEmpty()) {
            CommonEIV.LOGGER.error("Attempting to open Menu with 0 recipes");
        }
        this.player = inventory.player;
        this.updateByViewType();
        if (!this.sortedByType.isEmpty()) {
            return;
        }
        this.viewContainer = new ViewContainer(0);
        this.viewType = IEivRecipeViewType.NONE;
    }

    public RecipeViewMenu(int containerId, Inventory inventory) {
        this(null, containerId, inventory, IEivViewRecipe.PLACEHOLDER, ItemStack.EMPTY, SlotContent.Type.ANY, new ArrayList<RecipeViewScreen>());
    }

    public int getCurrentCraftReference() {
        return this.currentCraftReference;
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }

    public ArrayList<RecipeViewScreen> getViewHistory() {
        return this.viewHistory;
    }

    public boolean goBack() {
        if (this.viewScreen != null && this.viewHistory.indexOf((Object)this.viewScreen) > 0) {
            Minecraft.getInstance().setScreen((Screen)this.viewHistory.get(this.viewHistory.indexOf((Object)this.viewScreen) - 1));
            return true;
        }
        return false;
    }

    public boolean goForward() {
        if (this.viewScreen != null && this.viewHistory.size() - 1 > this.viewHistory.indexOf((Object)this.viewScreen)) {
            Minecraft.getInstance().setScreen((Screen)this.viewHistory.get(this.viewHistory.indexOf((Object)this.viewScreen) + 1));
            return true;
        }
        return false;
    }

    public void setViewScreen(RecipeViewScreen viewScreen) {
        this.viewScreen = viewScreen;
        this.viewHistory.add(viewScreen);
    }

    public ItemStack getOrigin() {
        return this.origin;
    }

    public AdditionalStackModifier getAdditionalStackModifier(int slot) {
        return this.additionalStackModifiers.getOrDefault(slot, AdditionalStackModifier.NONE);
    }

    public boolean isOptionalSlot(int slot) {
        return this.optionalSlotRenderers.containsKey(slot);
    }

    public OptionalSlotRenderer getOptionalSlotRenderer(int slot) {
        return this.optionalSlotRenderers.getOrDefault(slot, OptionalSlotRenderer.DEFAULT);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.viewContainer.stillValid(player);
    }

    public int getMaxPossiblePerPage() {
        return this.maxPossiblePerPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getMaxPageIndex() {
        return this.maxPageIndex;
    }

    public void nextReference() {
        this.currentCraftReference = Math.min(this.currentCraftReference + 1, this.viewType.getCraftReferences().size() - this.getDisplayableCraftReferences());
        this.updateReferences();
    }

    public void prevReference() {
        this.currentCraftReference = Math.max(this.currentCraftReference - 1, 0);
        this.updateReferences();
    }

    public void nextPage() {
        this.currentPage = Math.min(this.currentPage + 1, this.maxPageIndex);
        this.updateByPage();
    }

    public void prevPage() {
        this.currentPage = Math.max(this.currentPage - 1, 0);
        this.updateByPage();
    }

    public void nextRecipe() {
        int prevPage = this.currentPage;
        this.currentPage = Math.min(this.currentPage + 1, this.maxPageIndex);
        if (prevPage != this.currentPage) {
            this.updateByPage();
        }
    }

    public void setViewType(int typeId) {
        int prevIndex = this.currentTypeIndex;
        this.currentTypeIndex = typeId;
        if (prevIndex != this.currentTypeIndex) {
            this.updateByViewType();
        }
    }

    public boolean hasNextRecipe() {
        return this.currentPage < this.maxPageIndex;
    }

    public boolean hasPrevRecipe() {
        return this.currentPage > 0;
    }

    public List<IEivRecipeViewType> getViewTypeOrder() {
        return this.viewTypeOrder;
    }

    public int getCurrentTypeIndex() {
        return this.currentTypeIndex;
    }

    protected List<IEivViewRecipe> getCurrentDisplay() {
        return this.currentDisplay;
    }

    private List<IEivViewRecipe> getRecipeDisplay() {
        ArrayList<IEivViewRecipe> recipesOnPage = new ArrayList<IEivViewRecipe>();
        for (int i = this.currentPage * this.maxPossiblePerPage; i < Math.min(this.getRecipes().size(), (this.currentPage + 1) * this.maxPossiblePerPage); ++i) {
            recipesOnPage.add(this.getRecipes().get(i));
        }
        return recipesOnPage;
    }

    protected void updateByPage() {
        int i;
        this.additionalStackModifiers.clear();
        this.optionalSlotRenderers.clear();
        this.slots.clear();
        this.currentDisplay.forEach(IEivViewRecipe::fadeRecipe);
        this.currentDisplay.clear();
        this.currentDisplay.addAll(this.getRecipeDisplay());
        this.currentDisplay.forEach(IEivViewRecipe::initRecipe);
        this.currentCraftReference = 0;
        for (i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            recipe.getIngredients().forEach(slotContent -> slotContent.bindOrigin(this.origin, this.originType));
            recipe.getResults().forEach(slotContent -> slotContent.bindOrigin(this.origin, this.originType));
            recipe.getIngredients().forEach(slotContent -> slotContent.setType(SlotContent.Type.INGREDIENT));
            recipe.getResults().forEach(slotContent -> slotContent.setType(SlotContent.Type.RESULT));
            SlotDefinition slotDefinition = new SlotDefinition();
            this.viewType.placeSlots(slotDefinition);
            for (Slot slot : slotDefinition.getItemSlots()) {
                int id = slot.getContainerSlot() + i * this.getViewType().getSlotCount();
                this.addSlot(new Slot(slot.container, id, slot.x + this.guiOffsetLeft(), slot.y + this.guiOffsetTop(i)));
            }
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                int slotId = j + i * this.getViewType().getSlotCount();
                this.viewContainer.setItem(slotId, slotFillContext.contentBySlot(j).getByIndex(slotFillContext.contentBySlot(j).index()));
                if (slotFillContext.getAdditionalTooltips().containsKey(j)) {
                    this.additionalStackModifiers.put(slotId, slotFillContext.getAdditionalTooltips().get(j));
                }
                if (!slotFillContext.getOptionalSlotRenderers().containsKey(j)) continue;
                this.optionalSlotRenderers.put(slotId, slotFillContext.getOptionalSlotRenderers().get(j));
            }
        }
        this.transferData.clear();
        for (i = 0; i < this.getCurrentDisplay().size(); ++i) {
            this.transferData.add(this.checkMatchingContent(i));
        }
        if (this.viewScreen != null) {
            this.viewScreen.checkGui();
        }
        this.updateDependencies();
        for (i = 0; i < this.getDisplayableCraftReferences(); ++i) {
            this.addSlot(new Slot((Container)this.viewContainer, this.viewType.getSlotCount() * this.getCurrentDisplay().size() + i, -21, 8 + i * 24 + i));
        }
        this.updateReferences();
    }

    public int getDisplayableCraftReferences() {
        List<ItemStack> craftReferences = this.getViewType().getCraftReferences();
        return Math.min(craftReferences.size(), (this.getHeight() - 4) / 25);
    }

    private void updateReferences() {
        List<ItemStack> craftReferences = this.viewType.getCraftReferences();
        for (int i = this.currentCraftReference; i < Math.min(this.viewType.getCraftReferences().size(), this.currentCraftReference + this.getDisplayableCraftReferences()); ++i) {
            this.getSlot(this.viewType.getSlotCount() * this.getCurrentDisplay().size() + (i - this.currentCraftReference)).set(craftReferences.get(i));
        }
    }

    public List<RecipeTransferData> getTransferData() {
        return this.transferData;
    }

    private RecipeTransferData checkMatchingContent(int displayId) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return RecipeTransferData.EMPTY;
        }
        IEivViewRecipe currentLooking = this.getCurrentDisplay().get(displayId);
        SlotFillContext context = new SlotFillContext();
        currentLooking.bindSlots(context);
        LocalPlayer player = minecraft.player;
        NonNullList stackSupply = NonNullList.withSize((int)player.getInventory().getContainerSize(), (Object)ItemStack.EMPTY);
        for (int slot2 = 0; slot2 < stackSupply.size(); ++slot2) {
            stackSupply.set(slot2, (Object)player.getInventory().getItem(slot2).copy());
        }
        RecipeTransferData.Builder dataBuilder = new RecipeTransferData.Builder();
        context.getContents().keySet().stream().filter(slot -> context.getContents().get(slot).getType() != SlotContent.Type.RESULT).forEach(dataBuilder::noticeSlot);
        HashMap<Integer, List<ItemStack>> validAndAvailableContent = new HashMap<Integer, List<ItemStack>>();
        for (int slot3 : context.getContents().keySet()) {
            SlotContent content = context.getContents().get(slot3);
            if (content.getType() == SlotContent.Type.RESULT) continue;
            if (content.isEmpty()) {
                dataBuilder.findContent(slot3, new HashMap<Integer, ItemStack>());
                continue;
            }
            ArrayList availableItems = new ArrayList();
            content.getValidContents().forEach(stack -> {
                StackValidator stackValidator = context.getStackValidators().getOrDefault(slot3, null);
                if (stackSupply.stream().anyMatch(stack1 -> stack1.is(stack.getItem())) && (stackValidator == null || stackValidator.validate((ItemStack)stack))) {
                    availableItems.add(stack);
                }
            });
            validAndAvailableContent.put(slot3, availableItems);
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        context.getContents().forEach((slot, slotContent) -> {
            if (slotContent.getType() != SlotContent.Type.RESULT) {
                slots.add((Integer)slot);
            }
        });
        HashMap<Integer, HashMap<Integer, ItemStack>> bestMatch = new HashMap<Integer, HashMap<Integer, ItemStack>>();
        this.check(slots, 0, validAndAvailableContent, new HashMap<Integer, HashMap<Integer, ItemStack>>(), bestMatch, (NonNullList<ItemStack>)stackSupply);
        bestMatch.forEach(dataBuilder::findContent);
        RecipeTransferData transferData = dataBuilder.build();
        if (transferData.isSuccess() && !transferData.getUsedPlayerSlots().isEmpty()) {
            ItemStack required;
            HashMap<Integer, ItemStack> requiredStacks = new HashMap<Integer, ItemStack>();
            for (int recipeSlot2 : transferData.getUsedPlayerSlots().keySet()) {
                HashMap<Integer, ItemStack> usedSlots = transferData.getUsedPlayerSlots().get(recipeSlot2);
                required = usedSlots.values().stream().findFirst().orElseGet(() -> ItemStack.EMPTY).copy();
                int amount = 0;
                for (ItemStack stack2 : usedSlots.values()) {
                    amount += stack2.getCount();
                }
                if (required.isEmpty()) continue;
                requiredStacks.put(recipeSlot2, required.copyWithCount(amount));
            }
            boolean checking = true;
            HashMap<Integer, HashMap> stackable = new HashMap<Integer, HashMap>();
            int runs = 0;
            while (checking) {
                required = requiredStacks.keySet().iterator();
                while (required.hasNext()) {
                    int recipeSlot3 = (Integer)required.next();
                    if ((runs + 1) * ((ItemStack)requiredStacks.get(recipeSlot3)).getCount() <= ((ItemStack)requiredStacks.get(recipeSlot3)).getMaxStackSize() - ((ItemStack)requiredStacks.get(recipeSlot3)).getCount()) continue;
                    checking = false;
                    break;
                }
                if (!checking) break;
                HashMap<Integer, HashMap> currentStackable = new HashMap<Integer, HashMap>();
                Iterator recipeSlot3 = requiredStacks.keySet().iterator();
                while (recipeSlot3.hasNext()) {
                    int recipeSlot4 = (Integer)recipeSlot3.next();
                    ItemStack requiredStack = (ItemStack)requiredStacks.get(recipeSlot4);
                    HashMap<Integer, ItemStack> found = this.invCheckAndFind((NonNullList<ItemStack>)stackSupply, requiredStack, true);
                    if (found.isEmpty()) {
                        checking = false;
                        break;
                    }
                    currentStackable.put(recipeSlot4, found);
                }
                if (!checking) continue;
                currentStackable.forEach((recipeSlot, usedPlayerSlots) -> {
                    HashMap presentStackable = stackable.getOrDefault(recipeSlot, new HashMap());
                    usedPlayerSlots.forEach((playerSlot, stack) -> {
                        if (presentStackable.containsKey(playerSlot)) {
                            presentStackable.put(playerSlot, stack.copyWithCount(((ItemStack)presentStackable.get(playerSlot)).getCount() + stack.getCount()));
                        } else {
                            presentStackable.put(playerSlot, stack);
                        }
                    });
                    stackable.put((Integer)recipeSlot, presentStackable);
                });
                ++runs;
            }
            HashMap<Integer, HashMap> stackedMatch = new HashMap<Integer, HashMap>();
            bestMatch.forEach((recipeSlot, usedPlayerSlots) -> {
                HashMap playerSlots = new HashMap();
                usedPlayerSlots.forEach((playerSlot, stack) -> playerSlots.put(playerSlot, stack.copy()));
                stackedMatch.put((Integer)recipeSlot, playerSlots);
            });
            stackable.forEach((recipeSlot, usedPlayerSlots) -> usedPlayerSlots.forEach((playerSlot, stack) -> {
                if (((HashMap)stackedMatch.get(recipeSlot)).containsKey(playerSlot)) {
                    ((HashMap)stackedMatch.get(recipeSlot)).put(playerSlot, stack.copyWithCount(((ItemStack)((HashMap)stackedMatch.get(recipeSlot)).get(playerSlot)).getCount() + stack.getCount()));
                } else {
                    ((HashMap)stackedMatch.get(recipeSlot)).put(playerSlot, stack);
                }
            }));
            RecipeTransferData.Builder stackedBuilder = dataBuilder.duplicate();
            stackedMatch.forEach(stackedBuilder::findContent);
            transferData.setStackedData(stackedBuilder.build());
        }
        return transferData;
    }

    private void check(List<Integer> slots, int currentSlotIndex, HashMap<Integer, List<ItemStack>> validAndAvailableContent, HashMap<Integer, HashMap<Integer, ItemStack>> usedPlayerSlots, HashMap<Integer, HashMap<Integer, ItemStack>> bestMatch, NonNullList<ItemStack> stackSupply) {
        if (currentSlotIndex >= slots.size() || bestMatch.size() == slots.size()) {
            return;
        }
        List validStacks = validAndAvailableContent.getOrDefault(slots.get(currentSlotIndex), new ArrayList());
        for (ItemStack requiredStack : validStacks) {
            HashMap<Integer, ItemStack> found = this.invCheckAndFind(stackSupply, requiredStack, false);
            if (found.isEmpty()) continue;
            usedPlayerSlots.put(slots.get(currentSlotIndex), found);
            if (usedPlayerSlots.size() > bestMatch.size()) {
                bestMatch.putAll(usedPlayerSlots);
            }
            this.check(slots, currentSlotIndex + 1, validAndAvailableContent, usedPlayerSlots, bestMatch, stackSupply);
        }
        this.check(slots, currentSlotIndex + 1, validAndAvailableContent, usedPlayerSlots, bestMatch, stackSupply);
    }

    private HashMap<Integer, ItemStack> invCheckAndFind(NonNullList<ItemStack> stackSupply, ItemStack requiredStack, boolean checkComponents) {
        HashMap<Integer, ItemStack> usedPlayerSlots = new HashMap<Integer, ItemStack>();
        int requiredAmount = requiredStack.getCount();
        ItemStack firstFound = ItemStack.EMPTY;
        for (int playerSlot = 0; playerSlot < stackSupply.size() && requiredAmount > 0; ++playerSlot) {
            ItemStack playerStack = (ItemStack)stackSupply.get(playerSlot);
            ItemStack foundStack = playerStack.copy();
            if (!(checkComponents ? ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)requiredStack) : ItemStack.isSameItem((ItemStack)playerStack, (ItemStack)requiredStack))) continue;
            if (firstFound.isEmpty()) {
                firstFound = foundStack.copy();
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)foundStack, (ItemStack)firstFound)) continue;
            int prevReq = requiredAmount;
            requiredAmount -= Math.min(requiredAmount, playerStack.getCount());
            playerStack.setCount(playerStack.getCount() - (prevReq - requiredAmount));
            if (playerStack.getCount() <= 0) {
                stackSupply.set(playerSlot, (Object)ItemStack.EMPTY);
            }
            foundStack.setCount(prevReq - requiredAmount);
            OptionalInt menuSlotId = this.player.containerMenu.findSlot((Container)this.player.getInventory(), playerSlot);
            if (menuSlotId.isPresent()) {
                usedPlayerSlots.put(menuSlotId.getAsInt(), foundStack);
                continue;
            }
            this.returnToCache(usedPlayerSlots, stackSupply);
            return new HashMap<Integer, ItemStack>();
        }
        if (requiredAmount == 0) {
            return usedPlayerSlots;
        }
        this.returnToCache(usedPlayerSlots, stackSupply);
        return new HashMap<Integer, ItemStack>();
    }

    private void returnToCache(HashMap<Integer, ItemStack> usedPlayerSlots, NonNullList<ItemStack> stackSupply) {
        usedPlayerSlots.forEach((playerSlot, stack) -> {
            if (((ItemStack)stackSupply.get(playerSlot.intValue())).isEmpty()) {
                stackSupply.set(playerSlot.intValue(), stack);
            } else {
                ((ItemStack)stackSupply.get(playerSlot.intValue())).setCount(((ItemStack)stackSupply.get(playerSlot.intValue())).getCount() + stack.getCount());
            }
        });
    }

    private void resetContentPointers() {
        this.recipes.forEach(iEivRecipe -> {
            iEivRecipe.getIngredients().forEach(SlotContent::resetPointer);
            iEivRecipe.getResults().forEach(SlotContent::resetPointer);
        });
    }

    protected void updateByViewType() {
        this.currentPage = 0;
        this.recipes = this.sortedByType.getOrDefault(this.viewTypeOrder.get(this.currentTypeIndex), new ArrayList());
        this.resetContentPointers();
        Optional optional = this.recipes.stream().findFirst();
        if (optional.isPresent()) {
            this.viewType = ((IEivViewRecipe)optional.get()).getViewType();
            this.maxPossiblePerPage = this.calculateRecipesPerPage();
            int i = this.getRecipes().size() / this.maxPossiblePerPage;
            if (this.getRecipes().size() % this.maxPossiblePerPage != 0) {
                ++i;
            }
            this.maxPageIndex = i - 1;
            this.setMenuSizes();
            this.viewContainer = new ViewContainer(this.viewType.getSlotCount() * this.maxPossiblePerPage + this.getDisplayableCraftReferences());
            this.updateByPage();
        }
    }

    private void setMenuSizes() {
        this.menuHeight = 24 + this.getRecipeDisplay().size() * this.getViewType().getDisplayHeight() + this.getRecipeDisplay().size() * 16 + 8;
        this.menuWidth = 176;
    }

    public int getHeight() {
        return this.menuHeight;
    }

    public int getWidth() {
        return this.menuWidth;
    }

    protected int guiOffsetLeft() {
        return (this.menuWidth - this.getViewType().getDisplayWidth()) / 2;
    }

    protected int guiOffsetTop(int displayIndex) {
        return 24 + displayIndex * (this.getViewType().getDisplayHeight() + 16);
    }

    protected void tickContents() {
        for (int i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                if (slotFillContext.contentDependencies.containsKey(j)) continue;
                this.viewContainer.setItem(j + i * this.getViewType().getSlotCount(), slotFillContext.contentBySlot(j).next());
            }
        }
        this.updateDependencies();
    }

    protected void updateDependencies() {
        for (int i = 0; i < this.currentDisplay.size(); ++i) {
            IEivViewRecipe recipe = this.currentDisplay.get(i);
            SlotFillContext slotFillContext = new SlotFillContext();
            recipe.bindSlots(slotFillContext);
            for (int j = 0; j < this.getViewType().getSlotCount(); ++j) {
                if (!slotFillContext.contentDependencies.containsKey(j)) continue;
                this.viewContainer.setItem(j + i * this.getViewType().getSlotCount(), slotFillContext.contentBySlot(j).getByIndex(Math.min(slotFillContext.contentDependencies.get(j).get(), slotFillContext.contentBySlot(j).size() - 1)));
            }
        }
    }

    public List<? extends IEivViewRecipe> getRecipes() {
        return this.recipes;
    }

    public IEivRecipeViewType getViewType() {
        return this.viewType;
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private int calculateRecipesPerPage() {
        if (this.getRecipes().isEmpty()) {
            return 0;
        }
        int recipeHeight = this.getViewType().getDisplayHeight();
        int technicallyFitting = Math.min(this.getRecipes().size(), 224 / recipeHeight);
        int imageheightRequired = technicallyFitting * recipeHeight + (technicallyFitting * 16 + 24 + 24);
        while (imageheightRequired > 224) {
            imageheightRequired = --technicallyFitting * recipeHeight + (technicallyFitting * 16 + 24 + 24);
        }
        return technicallyFitting;
    }

    public void updateTransferCache() {
        this.transferData.clear();
        for (int i = 0; i < this.getCurrentDisplay().size(); ++i) {
            this.transferData.add(this.checkMatchingContent(i));
        }
        this.viewScreen.checkGui();
    }

    public static interface AdditionalStackModifier {
        public static final AdditionalStackModifier NONE = (stack, tooltip) -> {};

        public void addTooltip(ItemStack var1, List<Component> var2);
    }

    public static interface OptionalSlotRenderer {
        public static final OptionalSlotRenderer DEFAULT = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BuiltInEivIntegration.DEFAULT_SLOT_TEXTURE, 0, 0, 0.0f, 0.0f, 18, 18, 18, 18);

        public void render(GuiGraphics var1, int var2, int var3, float var4);
    }

    public class SlotDefinition {
        private final HashMap<Integer, Slot> itemSlots = new HashMap();

        private SlotDefinition() {
        }

        public void addItemSlot(int slotId, int x, int y) {
            this.itemSlots.put(slotId, new Slot((Container)RecipeViewMenu.this.viewContainer, slotId, x, y));
        }

        private List<Slot> getItemSlots() {
            return this.itemSlots.values().stream().toList();
        }
    }

    public static class SlotFillContext {
        private final HashMap<Integer, SlotContent> contents = new HashMap();
        private final HashMap<Integer, Supplier<Integer>> contentDependencies = new HashMap();
        private final HashMap<Integer, AdditionalStackModifier> additionalTooltips = new HashMap();
        private final HashMap<Integer, StackValidator> stackValidators = new HashMap();
        private final HashMap<Integer, OptionalSlotRenderer> optionalSlotRenderers = new HashMap();

        protected SlotFillContext() {
        }

        public void bindSlot(int slotId, SlotContent slotContent) {
            this.contents.put(slotId, slotContent);
        }

        public void bindDepedantSlot(int slotId, Supplier<Integer> dependantIndex, SlotContent slotContent) {
            this.contents.put(slotId, slotContent);
            this.contentDependencies.put(slotId, dependantIndex);
        }

        public void bindOptionalSlot(int slotId, SlotContent slotContent, OptionalSlotRenderer optionalSlotRenderer) {
            this.contents.put(slotId, slotContent);
            this.optionalSlotRenderers.put(slotId, optionalSlotRenderer);
        }

        public HashMap<Integer, Supplier<Integer>> contentDependencies() {
            return this.contentDependencies;
        }

        public void addAdditionalStackModifier(int slotId, AdditionalStackModifier tooltipProvider) {
            this.additionalTooltips.put(slotId, tooltipProvider);
        }

        public void addStackValidator(int slotId, StackValidator stackValidator) {
            this.stackValidators.put(slotId, stackValidator);
        }

        protected HashMap<Integer, SlotContent> getContents() {
            return this.contents;
        }

        protected HashMap<Integer, OptionalSlotRenderer> getOptionalSlotRenderers() {
            return this.optionalSlotRenderers;
        }

        protected SlotContent contentBySlot(int slotId) {
            return this.contents.getOrDefault(slotId, SlotContent.of(List.of()));
        }

        private HashMap<Integer, AdditionalStackModifier> getAdditionalTooltips() {
            return this.additionalTooltips;
        }

        private HashMap<Integer, StackValidator> getStackValidators() {
            return this.stackValidators;
        }
    }

    public static interface StackValidator {
        public boolean validate(ItemStack var1);
    }
}

