/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin;

import com.mojang.datafixers.util.Either;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.builtin.blasting.BlastingServerRecipe;
import de.crafty.eiv.common.builtin.blasting.BlastingViewRecipe;
import de.crafty.eiv.common.builtin.brewing.BrewingServerRecipe;
import de.crafty.eiv.common.builtin.brewing.BrewingViewRecipe;
import de.crafty.eiv.common.builtin.burning.BurningServerRecipe;
import de.crafty.eiv.common.builtin.burning.BurningViewRecipe;
import de.crafty.eiv.common.builtin.campfire.CampfireServerRecipe;
import de.crafty.eiv.common.builtin.campfire.CampfireViewRecipe;
import de.crafty.eiv.common.builtin.entity.EntityServerRecipe;
import de.crafty.eiv.common.builtin.entity.EntityViewRecipe;
import de.crafty.eiv.common.builtin.shaped.CraftingViewRecipe;
import de.crafty.eiv.common.builtin.shaped.ShapedServerRecipe;
import de.crafty.eiv.common.builtin.shapeless.ShapelessServerRecipe;
import de.crafty.eiv.common.builtin.shapeless.ShapelessViewRecipe;
import de.crafty.eiv.common.builtin.smelting.SmeltingServerRecipe;
import de.crafty.eiv.common.builtin.smelting.SmeltingViewRecipe;
import de.crafty.eiv.common.builtin.smithing.SmithingServerRecipe;
import de.crafty.eiv.common.builtin.smithing.SmithingViewRecipe;
import de.crafty.eiv.common.builtin.smoking.SmokingServerRecipe;
import de.crafty.eiv.common.builtin.smoking.SmokingViewRecipe;
import de.crafty.eiv.common.builtin.stonecutting.StonecutterServerRecipe;
import de.crafty.eiv.common.builtin.stonecutting.StonecutterViewRecipe;
import de.crafty.eiv.common.builtin.tipped_arrow.TippedArrowServerRecipe;
import de.crafty.eiv.common.builtin.transmute.TransmuteServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerViewRecipe;
import de.crafty.eiv.common.mixin.world.item.alchemy.PotionBrewingAccessor;
import de.crafty.eiv.common.mixin.world.item.crafting.IngredientAccessor;
import de.crafty.eiv.common.mixin.world.item.crafting.TransmuteRecipeAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.LootPoolAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.LootTableAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.CompositeEntryBaseAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.LootItemAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.entries.LootPoolSingletonContainerAccessor;
import de.crafty.eiv.common.mixin.world.level.storage.loot.functions.SetPotionFunctionAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.TransmuteRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;

public class BuiltInEivIntegration
implements IExtendedItemViewIntegration {
    public static final ResourceLocation WIDGETS = ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"textures/gui/eiv_widgets.png");
    public static final ResourceLocation DEFAULT_SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"textures/gui/default_slot.png");
    private static final TagKey<Item> EXCLUDED_ITEMS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hidden_from_recipe_viewers"));
    private static final TagKey<Block> EXCLUDED_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hidden_from_recipe_viewers"));

    @Override
    public void onIntegrationInitialize() {
        ItemView.addClientReloadCallback(() -> {
            BuiltInRegistries.BLOCK.get(EXCLUDED_BLOCKS).ifPresent(blocks -> blocks.stream().filter(Holder::isBound).filter(Holder::isBound).map(Holder::value).forEach(block -> ItemView.excludeItem(block.asItem())));
            BuiltInRegistries.ITEM.get(EXCLUDED_ITEMS).ifPresent(items -> items.stream().filter(Holder::isBound).filter(Holder::isBound).map(Holder::value).forEach(ItemView::excludeItem));
        });
        ItemView.addReloadCallback(() -> {
            Registry potionRegistry = ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.POTION);
            potionRegistry.forEach(potion -> {
                ItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                ItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                ItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                if (ServerRecipeManager.INSTANCE.getServer().potionBrewing().isBrewablePotion(potionRegistry.wrapAsHolder(potion))) {
                    ItemStack tipped = new ItemStack((ItemLike)Items.TIPPED_ARROW);
                    tipped.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionRegistry.wrapAsHolder(potion)));
                    ItemView.addStackSensitive(tipped);
                }
            });
            Registry enchantmentRegistry = ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            enchantmentRegistry.forEach(enchantment -> {
                for (int i = enchantment.getMinLevel(); i <= enchantment.getMaxLevel(); ++i) {
                    ItemStack enchantedBook = EnchantmentHelper.createBook((EnchantmentInstance)new EnchantmentInstance(enchantmentRegistry.wrapAsHolder(enchantment), i));
                    ItemView.addStackSensitive(enchantedBook);
                }
            });
        });
        ItemView.addRecipeProvider(recipeList -> BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            if (entityType.getDefaultLootTable().isEmpty()) {
                return;
            }
            LootTable table = ServerRecipeManager.INSTANCE.getServer().reloadableRegistries().getLootTable((ResourceKey)entityType.getDefaultLootTable().get());
            LootTableAccessor accessor = (LootTableAccessor)table;
            ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
            for (LootPool pool : accessor.getPools()) {
                LootPoolAccessor lootPoolAccessor = (LootPoolAccessor)pool;
                for (LootPoolEntryContainer container : lootPoolAccessor.entries()) {
                    if (container instanceof LootItem) {
                        LootItem lootItem = (LootItem)container;
                        LootItemAccessor lootItemAccessor = (LootItemAccessor)lootItem;
                        LootPoolSingletonContainerAccessor containerAccessor = (LootPoolSingletonContainerAccessor)((Object)lootItemAccessor);
                        ItemStack stack = new ItemStack((ItemLike)lootItemAccessor.getItem().value());
                        containerAccessor.getFunctions().forEach(function -> {
                            if (function instanceof SetPotionFunction) {
                                SetPotionFunction setPotionFunction = (SetPotionFunction)function;
                                stack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).withPotion(((SetPotionFunctionAccessor)setPotionFunction).getPotion()));
                            }
                        });
                        for (LootItemCondition condition : lootPoolAccessor.conditions()) {
                            if (!(condition instanceof LootItemKilledByPlayerCondition)) continue;
                            stack.set(DataComponents.LORE, (Object)((ItemLore)stack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY)).withLineAdded((Component)Component.translatable((String)"view.eiv.type.entity.playerKill").withStyle(ChatFormatting.RED)));
                        }
                        loot.add(stack);
                    }
                    if (!(container instanceof CompositeEntryBase)) continue;
                    CompositeEntryBase entryBase = (CompositeEntryBase)container;
                    CompositeEntryBaseAccessor entryBaseAccessor = (CompositeEntryBaseAccessor)entryBase;
                    entryBaseAccessor.getChildren().forEach(child -> {
                        if (child instanceof LootItem) {
                            LootItem lootItem = (LootItem)child;
                            LootItemAccessor lootItemAccessor = (LootItemAccessor)lootItem;
                            loot.add(new ItemStack(lootItemAccessor.getItem()));
                        }
                    });
                }
            }
            if (entityType == EntityType.WITHER) {
                loot.add(new ItemStack((ItemLike)Items.NETHER_STAR));
            }
            if (!loot.isEmpty()) {
                recipeList.add(new EntityServerRecipe((EntityType<?>)entityType, (List<ItemStack>)loot));
            }
        }));
        ItemView.addRecipeProvider(recipeList -> {
            FuelValues fuelValues = ServerRecipeManager.INSTANCE.getServer().fuelValues();
            fuelValues.fuelItems().forEach(item -> recipeList.add(new BurningServerRecipe((Item)item, fuelValues.burnDuration(new ItemStack((ItemLike)item)))));
        });
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.SMELTING).forEach(recipe -> recipeList.add(new SmeltingServerRecipe(recipe.input(), recipe.result))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.BLASTING).forEach(recipe -> recipeList.add(new BlastingServerRecipe(recipe.input(), recipe.result))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.SMOKING).forEach(recipe -> recipeList.add(new SmokingServerRecipe(recipe.input(), recipe.result))));
        ItemView.addRecipeProvider(recipeList -> {
            ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.CRAFTING).forEach(recipe -> {
                if (recipe instanceof ShapelessRecipe) {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                    recipeList.add(new ShapelessServerRecipe(shapelessRecipe.ingredients, shapelessRecipe.result));
                }
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    HashMap<Integer, Ingredient> ingredients = new HashMap<Integer, Ingredient>();
                    int i = 0;
                    for (int y = 0; y < 3; ++y) {
                        for (int x = 0; x < 3; ++x) {
                            if (x >= shapedRecipe.getWidth() || y >= shapedRecipe.getHeight()) continue;
                            if (((Optional)shapedRecipe.getIngredients().get(i)).isPresent()) {
                                ingredients.put(x + y * 3, (Ingredient)((Optional)shapedRecipe.getIngredients().get(i)).get());
                            }
                            ++i;
                        }
                    }
                    recipeList.add(new ShapedServerRecipe(shapedRecipe.getWidth(), shapedRecipe.getHeight(), ingredients, shapedRecipe.result));
                }
                if (recipe instanceof TransmuteRecipe) {
                    TransmuteRecipeAccessor accessor = (TransmuteRecipeAccessor)recipe;
                    ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                    Either ingredientContent = ((IngredientAccessor)accessor.getInput()).getValues().unwrap();
                    ArrayList<Item> ingredients = new ArrayList<Item>();
                    if (ingredientContent.left().isPresent()) {
                        SlotContent.getItemsFromTag((TagKey<Item>)((TagKey)ingredientContent.left().get())).ifPresent(holders -> holders.forEach(holder -> ingredients.add((Item)holder.value())));
                    }
                    if (ingredientContent.right().isPresent()) {
                        ingredients.addAll(((List)ingredientContent.right().get()).stream().map(Holder::value).toList());
                    }
                    ingredients.forEach(ingredient -> results.add(accessor.getResult().apply(new ItemStack((ItemLike)ingredient))));
                    if (!ingredients.isEmpty() && !results.isEmpty()) {
                        recipeList.add(new TransmuteServerRecipe(accessor.getInput(), accessor.getMaterial(), results));
                    }
                }
            });
            Registry potionRegistry = ServerRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.POTION);
            potionRegistry.forEach(potion -> {
                ItemStack potionStack = PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionRegistry.wrapAsHolder(potion));
                recipeList.add(new TippedArrowServerRecipe(potionStack));
            });
        });
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.CAMPFIRE_COOKING).forEach(campfireCookingRecipe -> recipeList.add(new CampfireServerRecipe(campfireCookingRecipe.input(), campfireCookingRecipe.result))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.STONECUTTING).forEach(stonecutterRecipe -> recipeList.add(new StonecutterServerRecipe(stonecutterRecipe.input(), stonecutterRecipe.result))));
        ItemView.addRecipeProvider(recipeList -> ServerRecipeManager.INSTANCE.getRecipesForType(RecipeType.SMITHING).forEach(smithingRecipe -> {
            if (smithingRecipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)smithingRecipe;
                recipeList.add(new SmithingServerRecipe(true, trimRecipe.baseIngredient(), trimRecipe.templateIngredient().orElse(null), trimRecipe.additionIngredient().orElse(null), (TrimPattern)trimRecipe.pattern.value(), null));
            }
            if (smithingRecipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)smithingRecipe;
                recipeList.add(new SmithingServerRecipe(false, transformRecipe.baseIngredient(), transformRecipe.templateIngredient().orElse(null), transformRecipe.additionIngredient().orElse(null), null, transformRecipe.result));
            }
        }));
        ItemView.addRecipeProvider(recipeList -> {
            PotionBrewing potionBrewing = ServerRecipeManager.INSTANCE.getServer().potionBrewing();
            List<PotionBrewing.Mix<Potion>> potionMixes = ((PotionBrewingAccessor)potionBrewing).getPotionMixes();
            List<PotionBrewing.Mix<Item>> containerMixes = ((PotionBrewingAccessor)potionBrewing).getContainerMixes();
            containerMixes.forEach(itemMix -> recipeList.add(new BrewingServerRecipe(new ItemStack((ItemLike)itemMix.to().value()), itemMix.ingredient(), new ItemStack((ItemLike)itemMix.from().value()))));
            potionMixes.forEach(potionMix -> {
                recipeList.add(new BrewingServerRecipe(PotionContents.createItemStack((Item)Items.POTION, (Holder)potionMix.to()), potionMix.ingredient(), PotionContents.createItemStack((Item)Items.POTION, (Holder)potionMix.from())));
                recipeList.add(new BrewingServerRecipe(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potionMix.to()), potionMix.ingredient(), PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potionMix.from())));
                recipeList.add(new BrewingServerRecipe(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionMix.to()), potionMix.ingredient(), PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionMix.from())));
            });
        });
        ItemView.addRecipeProvider(recipeList -> VillagerTrades.TRADES.forEach((profession, byProfessionLevel) -> byProfessionLevel.forEach((professionLevel, itemListings) -> Arrays.stream(itemListings).toList().forEach(listing -> {
            if (listing instanceof VillagerTrades.EmeraldForItems) {
                VillagerTrades.EmeraldForItems emeraldForItems = (VillagerTrades.EmeraldForItems)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.EmeraldForItems>(VillagerServerRecipe.VillagerOfferType.EMERALD_FOR_ITEMS, emeraldForItems)));
            }
            if (listing instanceof VillagerTrades.ItemsForEmeralds) {
                VillagerTrades.ItemsForEmeralds itemsForEmeralds = (VillagerTrades.ItemsForEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.ItemsForEmeralds>(VillagerServerRecipe.VillagerOfferType.ITEMS_FOR_EMERALDS, itemsForEmeralds)));
            }
            if (listing instanceof VillagerTrades.SuspiciousStewForEmerald) {
                VillagerTrades.SuspiciousStewForEmerald suspiciousStewForEmerald = (VillagerTrades.SuspiciousStewForEmerald)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.SuspiciousStewForEmerald>(VillagerServerRecipe.VillagerOfferType.SUSPICIOUS_STEW, suspiciousStewForEmerald)));
            }
            if (listing instanceof VillagerTrades.EnchantBookForEmeralds) {
                VillagerTrades.EnchantBookForEmeralds enchantBookForEmeralds = (VillagerTrades.EnchantBookForEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.EnchantBookForEmeralds>(VillagerServerRecipe.VillagerOfferType.ENCHANT_BOOK, enchantBookForEmeralds)));
            }
            if (listing instanceof VillagerTrades.TreasureMapForEmeralds) {
                VillagerTrades.TreasureMapForEmeralds treasureMapForEmeralds = (VillagerTrades.TreasureMapForEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.TreasureMapForEmeralds>(VillagerServerRecipe.VillagerOfferType.TREASURE_MAP, treasureMapForEmeralds)));
            }
            if (listing instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
                VillagerTrades.TippedArrowForItemsAndEmeralds tippedArrowForItemsAndEmeralds = (VillagerTrades.TippedArrowForItemsAndEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.TippedArrowForItemsAndEmeralds>(VillagerServerRecipe.VillagerOfferType.TIPPED_ARROW, tippedArrowForItemsAndEmeralds)));
            }
            if (listing instanceof VillagerTrades.EnchantedItemForEmeralds) {
                VillagerTrades.EnchantedItemForEmeralds enchantedItemForEmeralds = (VillagerTrades.EnchantedItemForEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.EnchantedItemForEmeralds>(VillagerServerRecipe.VillagerOfferType.ENCHANTED_ITEM_FOR_EMERALDS, enchantedItemForEmeralds)));
            }
            if (listing instanceof VillagerTrades.DyedArmorForEmeralds) {
                VillagerTrades.DyedArmorForEmeralds dyedArmorForEmeralds = (VillagerTrades.DyedArmorForEmeralds)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.DyedArmorForEmeralds>(VillagerServerRecipe.VillagerOfferType.DYED_ARMOR, dyedArmorForEmeralds)));
            }
            if (listing instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
                VillagerTrades.ItemsAndEmeraldsToItems itemsAndEmeraldsToItems = (VillagerTrades.ItemsAndEmeraldsToItems)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.ItemsAndEmeraldsToItems>(VillagerServerRecipe.VillagerOfferType.ITEMS_AND_EMERALDS_TO_ITEMS, itemsAndEmeraldsToItems)));
            }
            if (listing instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
                VillagerTrades.EmeraldsForVillagerTypeItem emeraldsForVillagerTypeItem = (VillagerTrades.EmeraldsForVillagerTypeItem)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.EmeraldsForVillagerTypeItem>(VillagerServerRecipe.VillagerOfferType.EMERALDS_FOR_VILLAGER_TYPE, emeraldsForVillagerTypeItem)));
            }
            if (listing instanceof VillagerTrades.TypeSpecificTrade) {
                VillagerTrades.TypeSpecificTrade typeSpecificTrade = (VillagerTrades.TypeSpecificTrade)listing;
                recipeList.add(new VillagerServerRecipe((ResourceKey<VillagerProfession>)profession, (int)professionLevel, new VillagerServerRecipe.VillagerDataObject<VillagerTrades.TypeSpecificTrade>(VillagerServerRecipe.VillagerOfferType.TYPE_SPECIFIC, typeSpecificTrade)));
            }
        }))));
        ItemView.registerRecipeWrapper(BurningServerRecipe.TYPE, unwrapped -> List.of(new BurningViewRecipe((BurningServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmeltingServerRecipe.TYPE, unwrapped -> List.of(new SmeltingViewRecipe((SmeltingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(BlastingServerRecipe.TYPE, unwrapped -> List.of(new BlastingViewRecipe((BlastingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmokingServerRecipe.TYPE, unwrapped -> List.of(new SmokingViewRecipe((SmokingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(ShapelessServerRecipe.TYPE, unwrapped -> List.of(new ShapelessViewRecipe((ShapelessServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(ShapedServerRecipe.TYPE, unwrapped -> List.of(new CraftingViewRecipe((ShapedServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(TransmuteServerRecipe.TYPE, unwrapped -> List.of(new ShapelessViewRecipe((TransmuteServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(TippedArrowServerRecipe.TYPE, unwrapped -> List.of(new CraftingViewRecipe((TippedArrowServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(CampfireServerRecipe.TYPE, unwrapped -> List.of(new CampfireViewRecipe((CampfireServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(StonecutterServerRecipe.TYPE, unwrapped -> List.of(new StonecutterViewRecipe((StonecutterServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(SmithingServerRecipe.TYPE, unwrapped -> {
            ArrayList recipes = new ArrayList();
            if (unwrapped.getBase() != null && unwrapped.getTemplate() != null) {
                SlotContent.of(unwrapped.getBase()).getValidContents().forEach(baseStack -> SlotContent.of(unwrapped.getTemplate()).getValidContents().forEach(templateStack -> recipes.add(new SmithingViewRecipe(unwrapped.isTrim(), unwrapped.getAddition(), Ingredient.of((ItemLike)baseStack.getItem()), Ingredient.of((ItemLike)templateStack.getItem()), unwrapped.getPattern(), unwrapped.getUpgradeResult()))));
            } else if (unwrapped.getBase() != null && unwrapped.getAddition() != null) {
                SlotContent.of(unwrapped.getBase()).getValidContents().forEach(baseStack -> SlotContent.of(unwrapped.getAddition()).getValidContents().forEach(additionStack -> recipes.add(new SmithingViewRecipe(unwrapped.isTrim(), Ingredient.of((ItemLike)additionStack.getItem()), Ingredient.of((ItemLike)baseStack.getItem()), unwrapped.getTemplate(), unwrapped.getPattern(), unwrapped.getUpgradeResult()))));
            } else if (unwrapped.getAddition() != null && unwrapped.getTemplate() != null) {
                SlotContent.of(unwrapped.getTemplate()).getValidContents().forEach(templateStack -> SlotContent.of(unwrapped.getAddition()).getValidContents().forEach(additionStack -> recipes.add(new SmithingViewRecipe(unwrapped.isTrim(), Ingredient.of((ItemLike)additionStack.getItem()), unwrapped.getBase(), Ingredient.of((ItemLike)templateStack.getItem()), unwrapped.getPattern(), unwrapped.getUpgradeResult()))));
            }
            return recipes;
        });
        ItemView.registerRecipeWrapper(BrewingServerRecipe.TYPE, unwrapped -> List.of(new BrewingViewRecipe((BrewingServerRecipe)unwrapped)));
        ItemView.registerRecipeWrapper(VillagerServerRecipe.TYPE, unwrapped -> unwrapped.getOffers().stream().map(VillagerViewRecipe::new).toList());
        ItemView.registerRecipeWrapper(EntityServerRecipe.TYPE, unwrapped -> List.of(new EntityViewRecipe((EntityServerRecipe)unwrapped)));
    }
}

