/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.extra;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.extra.FluidItemModel;
import de.crafty.eiv.common.extra.FluidStack;
import de.crafty.eiv.common.recipe.item.FluidItem;
import de.crafty.eiv.common.resolver.IEivClientResolver;
import java.awt.Color;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FluidItemSpecialRenderer
implements SpecialModelRenderer<ItemStack> {
    private final FluidItemModel model;

    private FluidItemSpecialRenderer(FluidItemModel model) {
        this.model = model;
    }

    public void submit(@Nullable ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, int j, boolean bl, int k) {
        if (stack == null) {
            return;
        }
        if (!(stack.getItem() instanceof FluidItem)) {
            return;
        }
        FluidStack fluidStack = FluidStack.fromItemStack(stack);
        Fluid fluid = fluidStack.fluid();
        float renderHeight = Math.max(Math.min((float)fluidStack.amount() / 1000.0f, 1.0f), 0.1f);
        int color = fluid == Fluids.WATER ? ((Biome)Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS).value()).getWaterColor() : -1;
        Color unmodified = new Color(color);
        color = new Color(unmodified.getRed(), unmodified.getGreen(), unmodified.getBlue(), 255).getRGB();
        TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(fluid.defaultFluidState().createLegacyBlock()).particleIcon();
        IEivClientResolver.UVInfo uvInfo = CommonEIVClient.resolver().getUVInfo(sprite);
        float u0 = uvInfo.u0();
        float u1 = uvInfo.u1();
        float v0 = uvInfo.v0();
        float v1 = uvInfo.v1();
        float width = u1 - u0;
        float height = v1 - v0;
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        float finalHeight = height *= renderHeight;
        int finalColor = color;
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation()), (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose.pose(), 1.0f, 0.0f, 0.0f).setUv(u0 + width, v0).setOverlay(j).setLight(i).setColor(finalColor).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose.pose(), 1.0f, renderHeight, 0.0f).setUv(u0 + width, v0 + finalHeight).setOverlay(j).setLight(i).setColor(finalColor).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose.pose(), 0.0f, renderHeight, 0.0f).setUv(u0, v0 + finalHeight).setOverlay(j).setLight(i).setColor(finalColor).setNormal(0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose.pose(), 0.0f, 0.0f, 0.0f).setUv(u0, v0).setOverlay(j).setLight(i).setColor(finalColor).setNormal(0.0f, 0.0f, 1.0f);
        });
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> set) {
    }

    @Nullable
    public ItemStack extractArgument(ItemStack itemStack) {
        return itemStack;
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        @NotNull
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext bakingContext) {
            return new FluidItemSpecialRenderer(new FluidItemModel(bakingContext.entityModelSet().bakeLayer(CommonEIVClient.FLUID_ITEM_MODEL_LAYER)));
        }

        @NotNull
        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

