/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.extra;

import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.item.FluidItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public record FluidStack(Fluid fluid, int amount) {
    public static final int AMOUNT_FULL = 1000;
    public static final FluidStack EMPTY = new FluidStack(Fluids.EMPTY, 0);

    public FluidStack(Fluid fluid) {
        this(fluid, 1000);
    }

    public static FluidStack fromItemStack(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof FluidItem)) {
            return EMPTY;
        }
        FluidItem fluidItem = (FluidItem)item;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int amount = 1000;
        if (tag.contains("fluidAmount")) {
            amount = tag.getInt("fluidAmount").orElseGet(() -> 1000);
        }
        return new FluidStack(fluidItem.getFluid(), amount);
    }

    public ItemStack createItemStack() {
        Item item = ItemViewRecipes.INSTANCE.itemForFluid(this.fluid);
        if (item == Items.AIR) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putInt("fluidAmount", this.amount);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        return stack;
    }
}

