/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.mixin.server.network;

import de.crafty.eiv.common.CommonEIV;
import de.crafty.eiv.common.network.EivNetworkManager;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class MixinServerGamePacketListenerImpl {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEivPayloadReceived(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        CustomPacketPayload payload = packet.payload();
        ResourceLocation payloadId = payload.type().id();
        EivNetworkManager.INSTANCE.getServerbound().forEach((resourceLocation, typeAndCodec) -> {
            if (!payloadId.equals(resourceLocation)) {
                return;
            }
            if (EivNetworkManager.INSTANCE.serverPayloadHandlers().containsKey(payloadId)) {
                this.player.level().getServer().execute(() -> EivNetworkManager.INSTANCE.serverPayloadHandlers().get(payloadId).handle(new EivNetworkManager.ServerContext(this.player.level().getServer(), this.player), (CustomPacketPayload)EivNetworkManager.INSTANCE.castPayload(payload)));
            } else {
                CommonEIV.LOGGER.error("Cannot resolve payload handler for id: {}", (Object)payloadId);
            }
            ci.cancel();
        });
    }
}

