/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.network;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.network.EivNetworkManager;
import de.crafty.eiv.common.network.payload.compat.ClientboundCompatPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStartStackSensitivesPayload;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class EivPayloadConverter {
    public static void convertFromCompat(EivNetworkManager.ClientContext ctx, ClientboundCompatPayload payload) {
        Record p;
        CompoundTag payloadTag = payload.data();
        if (payloadTag.isEmpty()) {
            return;
        }
        ResourceLocation payloadType = ResourceLocation.parse((String)payloadTag.getStringOr("payloadType", ""));
        CompoundTag data = payloadTag.getCompoundOrEmpty("payloadData");
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        if (payloadType.equals((Object)ClientboundCacheStartPayload.TYPE.id())) {
            p = new ClientboundCacheStartPayload(data.getIntOr("types", 0));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundStartUpdatesPayload.TYPE.id())) {
            p = new ClientboundStartUpdatesPayload();
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundTypeUpdateStartPayload.TYPE.id())) {
            p = new ClientboundTypeUpdateStartPayload(EivRecipeType.byId(ResourceLocation.parse((String)data.getStringOr("recipeType", ""))), data.getIntOr("amount", 0));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundTypeUpdatePayload.TYPE.id())) {
            CompoundTag fullTag = data.getCompoundOrEmpty("entry");
            ResourceLocation recipeId = ResourceLocation.parse((String)fullTag.getStringOr("recipeId", ""));
            IEivServerRecipe recipe = ServerRecipeManager.ServerRecipeEntry.fromTag(fullTag.getCompoundOrEmpty("recipe"));
            ClientboundTypeUpdatePayload p2 = new ClientboundTypeUpdatePayload(new ServerRecipeManager.ServerRecipeEntry(recipeId, recipe));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p2);
        }
        if (payloadType.equals((Object)ClientboundTypeUpdateEndPayload.TYPE.id())) {
            p = new ClientboundTypeUpdateEndPayload(EivRecipeType.byId(ResourceLocation.parse((String)data.getStringOr("recipeType", ""))));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundFinishUpdatesPayload.TYPE.id())) {
            p = new ClientboundFinishUpdatesPayload();
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundStartStackSensitivesPayload.TYPE.id())) {
            p = new ClientboundStartStackSensitivesPayload(data.getIntOr("amount", 0));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundStackSensitivePayload.TYPE.id())) {
            p = new ClientboundStackSensitivePayload(new ItemView.StackSensitive(EivTagUtil.decodeItemStackOnClient(data.getCompoundOrEmpty("sensitive"))));
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
        if (payloadType.equals((Object)ClientboundFinishStackSensitivesPayload.TYPE.id())) {
            p = new ClientboundFinishStackSensitivesPayload();
            Minecraft.getInstance().getConnection().handleCustomPayload((CustomPacketPayload)p);
        }
    }
}

