/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.network.payload.compat;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.charset.StandardCharsets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record ClientboundCompatPayload(CompoundTag data) implements CustomPacketPayload
{
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundCompatPayload> STREAM_CODEC = CustomPacketPayload.codec((payload, friendlyByteBuf) -> {}, friendlyByteBuf -> {
        if (friendlyByteBuf.readableBytes() <= 0 || friendlyByteBuf.readableBytes() > 0x100000) {
            return new ClientboundCompatPayload(new CompoundTag());
        }
        String s = friendlyByteBuf.readBytes(friendlyByteBuf.readableBytes()).toString(StandardCharsets.UTF_8);
        try {
            return new ClientboundCompatPayload(TagParser.parseCompoundFully((String)s));
        }
        catch (CommandSyntaxException e) {
            return new ClientboundCompatPayload(new CompoundTag());
        }
    });
    public static final CustomPacketPayload.Type<ClientboundCompatPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eiv", (String)"compat"));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

