/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ViewContainer
implements Container {
    private final NonNullList<ItemStack> items;
    private final int size;

    protected ViewContainer(int size) {
        this.size = size;
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.takeItem(this.items, (int)0);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)0);
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.items.set(slot, (Object)itemStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }
}

