/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.recipe.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import de.crafty.eiv.common.mixin.world.item.crafting.IngredientAccessor;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class EivTagUtil {
    private static <T> ListTag createRegistryList(List<T> objects, DefaultedRegistry<T> registry) {
        ListTag list = new ListTag();
        objects.stream().map(t -> StringTag.valueOf((String)EivTagUtil.registryToString(t, registry))).forEach(arg_0 -> list.add(arg_0));
        return list;
    }

    private static <T> List<T> reconstructRegistryList(CompoundTag srcTag, String key, DefaultedRegistry<T> registry) {
        return srcTag.getListOrEmpty(key).stream().map(Tag::asString).map(s -> EivTagUtil.stringToRegistry((String)s.orElseThrow(), registry)).filter(Objects::nonNull).toList();
    }

    public static ItemStack decodeItemStackOnClient(CompoundTag tag) {
        return ItemStack.CODEC.parse((DynamicOps)Minecraft.getInstance().player.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().orElse(ItemStack.EMPTY);
    }

    public static CompoundTag encodeItemStackOnClient(ItemStack stack) {
        return (CompoundTag)ItemStack.CODEC.encode((Object)stack, (DynamicOps)Minecraft.getInstance().player.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CompoundTag()).mapOrElse(tag -> tag.asCompound().orElseGet(CompoundTag::new), tagError -> new CompoundTag());
    }

    public static CompoundTag encodeItemStackOnServer(ItemStack stack) {
        return (CompoundTag)ItemStack.CODEC.encode((Object)stack, (DynamicOps)ServerRecipeManager.INSTANCE.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CompoundTag()).mapOrElse(tag -> tag.asCompound().orElseGet(CompoundTag::new), tagError -> new CompoundTag());
    }

    public static ItemStack decodeItemStackOnServer(CompoundTag tag) {
        return ItemStack.CODEC.parse((DynamicOps)ServerRecipeManager.INSTANCE.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().orElse(ItemStack.EMPTY);
    }

    public static CompoundTag writeIngredient(Ingredient ingredient) {
        if (ingredient == null) {
            return new CompoundTag();
        }
        HolderSet<Item> set = ((IngredientAccessor)ingredient).getValues();
        Either ingredientContent = set.unwrap();
        CompoundTag tag = new CompoundTag();
        if (ingredientContent.left().isPresent()) {
            tag.putString("tag", ((TagKey)ingredientContent.left().get()).location().toString());
            return tag;
        }
        if (ingredientContent.right().isEmpty()) {
            return new CompoundTag();
        }
        tag.put("items", (Tag)EivTagUtil.createItemList(((List)ingredientContent.right().get()).stream().filter(Holder::isBound).map(Holder::value).toList()));
        return tag;
    }

    public static Ingredient readIngredient(CompoundTag tag) {
        if (tag.isEmpty()) {
            return null;
        }
        if (tag.contains("tag")) {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag.getStringOr("tag", "")));
            if (BuiltInRegistries.ITEM.get(tagKey).isEmpty()) {
                return null;
            }
            return Ingredient.of((HolderSet)((HolderSet)Objects.requireNonNull((HolderSet.Named)BuiltInRegistries.ITEM.get(tagKey).get())));
        }
        List<Holder> itemList = EivTagUtil.reconstructItemList(tag, "items").stream().map(Holder::direct).toList();
        return !itemList.isEmpty() ? Ingredient.of((HolderSet)HolderSet.direct(itemList)) : null;
    }

    public static ListTag createItemList(List<Item> items) {
        return EivTagUtil.createRegistryList(items, BuiltInRegistries.ITEM);
    }

    public static List<Item> reconstructItemList(CompoundTag srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, BuiltInRegistries.ITEM);
    }

    public static ListTag createBlockList(List<Block> blocks) {
        return EivTagUtil.createRegistryList(blocks, BuiltInRegistries.BLOCK);
    }

    public static List<Block> reconstructBlockList(CompoundTag srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, BuiltInRegistries.BLOCK);
    }

    public static ListTag createFluidList(List<Fluid> fluids) {
        return EivTagUtil.createRegistryList(fluids, BuiltInRegistries.FLUID);
    }

    public static List<Fluid> reconstructFluidList(CompoundTag srcTag, String key) {
        return EivTagUtil.reconstructRegistryList(srcTag, key, BuiltInRegistries.FLUID);
    }

    public static <T> ListTag writeList(List<T> list, CompoundBuilder<T> builder) {
        ListTag tagList = new ListTag();
        list.stream().map(t -> builder.buildSingle(t, new CompoundTag())).forEach(arg_0 -> tagList.add(arg_0));
        return tagList;
    }

    public static <T> List<T> readList(CompoundTag srcTag, String key, CompoundReconstructor<T> builder) {
        return srcTag.getListOrEmpty(key).stream().map(Tag::asCompound).map(compoundTag -> builder.reconstructSingle(compoundTag.orElseGet(CompoundTag::new))).toList();
    }

    private static <T> String registryToString(T object, DefaultedRegistry<T> registry) {
        return registry.getKey(object).toString();
    }

    private static <T> T stringToRegistry(String string, DefaultedRegistry<T> registry) {
        if (string.isEmpty()) {
            return null;
        }
        return registry.getOptional(ResourceLocation.tryParse((String)string)).orElse(null);
    }

    public static String itemToString(Item item) {
        return EivTagUtil.registryToString(item, BuiltInRegistries.ITEM);
    }

    public static Item itemFromString(String s) {
        return (Item)EivTagUtil.stringToRegistry(s, BuiltInRegistries.ITEM);
    }

    public static String blockToString(Block block) {
        return EivTagUtil.registryToString(block, BuiltInRegistries.BLOCK);
    }

    public static Block blockFromString(String s) {
        return (Block)EivTagUtil.stringToRegistry(s, BuiltInRegistries.BLOCK);
    }

    public static String fluidToString(Fluid fluid) {
        return EivTagUtil.registryToString(fluid, BuiltInRegistries.FLUID);
    }

    public static Fluid fluidFromString(String s) {
        return (Fluid)EivTagUtil.stringToRegistry(s, BuiltInRegistries.FLUID);
    }

    public static interface CompoundBuilder<T> {
        public CompoundTag buildSingle(T var1, CompoundTag var2);
    }

    public static interface CompoundReconstructor<T> {
        public T reconstructSingle(CompoundTag var1);
    }
}

