/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.api.recipe;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.builtin.shaped.CraftingViewType;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;

public interface IEivViewRecipe {
    public static final List<IEivViewRecipe> PLACEHOLDER = List.of(new IEivViewRecipe(){

        @Override
        public IEivRecipeViewType getViewType() {
            return CraftingViewType.INSTANCE;
        }

        @Override
        public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        }

        @Override
        public List<SlotContent> getIngredients() {
            return List.of();
        }

        @Override
        public List<SlotContent> getResults() {
            return List.of();
        }
    });

    public IEivRecipeViewType getViewType();

    public void bindSlots(RecipeViewMenu.SlotFillContext var1);

    public List<SlotContent> getIngredients();

    public List<SlotContent> getResults();

    default public boolean redirectsAsIngredient(ItemStack stack) {
        boolean potionRedirectCheck = ItemViewRecipes.makePotionRedirectCheck(stack, this.getIngredients());
        boolean enchantmentRedirectCheck = ItemViewRecipes.makeEnchantedRedirectCheck(stack, this.getIngredients());
        return potionRedirectCheck && enchantmentRedirectCheck;
    }

    default public boolean redirectsAsResult(ItemStack stack) {
        boolean potionRedirectCheck = ItemViewRecipes.makePotionRedirectCheck(stack, this.getResults());
        boolean enchantmentRedirectCheck = ItemViewRecipes.makeEnchantedRedirectCheck(stack, this.getResults());
        return potionRedirectCheck && enchantmentRedirectCheck;
    }

    default public int getPriority() {
        return 0;
    }

    default public List<AnimationTicker> getAnimationTickers() {
        return List.of();
    }

    default public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    default public void tick() {
    }

    default public void initRecipe() {
    }

    default public void fadeRecipe() {
    }

    default public boolean supportsItemTransfer() {
        return false;
    }

    @Deprecated
    default public Class<? extends AbstractContainerScreen<?>> getTransferClass() {
        return null;
    }

    default public List<Class<? extends AbstractContainerScreen<?>>> getTransferClasses() {
        return this.getTransferClass() == null ? List.of() : List.of(this.getTransferClass());
    }

    default public boolean canTransferToScreen(AbstractContainerScreen<?> screen) {
        return true;
    }

    default public void mapRecipeItems(RecipeTransferMap transferMap, AbstractContainerScreen<?> screen) {
    }

    public static class RecipeTransferMap {
        private final HashMap<Integer, Integer> map = new HashMap();

        public void linkSlots(int recipeSlot, int destSlot) {
            this.map.put(recipeSlot, destSlot);
        }

        public HashMap<Integer, Integer> getTransferMap() {
            return this.map;
        }
    }
}

