/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.blasting;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.builtin.blasting.BlastingServerRecipe;
import de.crafty.eiv.common.builtin.blasting.BlastingViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class BlastingViewRecipe
implements IEivViewRecipe {
    private final SlotContent input;
    private final SlotContent result;
    private final AnimationTicker blastingTicker;

    public BlastingViewRecipe(BlastingServerRecipe blastingRecipe) {
        this.input = SlotContent.of(blastingRecipe.getInput());
        this.result = SlotContent.of(blastingRecipe.getResult());
        this.blastingTicker = AnimationTicker.create(ResourceLocation.withDefaultNamespace((String)"blasting_ticker"), 100);
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return BlastingViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindSlot(0, this.input);
        slotFillContext.bindSlot(2, this.result);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.input);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    public List<AnimationTicker> getAnimationTickers() {
        return List.of(this.blastingTicker);
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int litProgress = Math.round(this.blastingTicker.getProgress() * 14.0f);
        int smeltProgress = Math.round(this.blastingTicker.getProgress() * 24.0f);
        guiGraphics.blit(RenderType::guiTextured, BuiltInEivIntegration.WIDGETS, 1, 20 + (14 - litProgress), 0.0f, (float)(14 - litProgress), 14, litProgress, 128, 128);
        guiGraphics.blit(RenderType::guiTextured, BuiltInEivIntegration.WIDGETS, 24, 19, 14.0f, 0.0f, smeltProgress, 16, 128, 128);
    }

    @Override
    public boolean supportsItemTransfer() {
        return true;
    }

    @Override
    public Class<? extends AbstractContainerScreen<?>> getTransferClass() {
        return BlastFurnaceScreen.class;
    }

    @Override
    public void mapRecipeItems(IEivViewRecipe.RecipeTransferMap transferMap, AbstractContainerScreen<?> screen) {
        transferMap.linkSlots(0, 0);
    }
}

