/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.burning;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.builtin.burning.BurningServerRecipe;
import de.crafty.eiv.common.builtin.burning.BurningViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BurningViewRecipe
implements IEivViewRecipe {
    private final SlotContent fuel;
    private final int burnTime;
    private final AnimationTicker ticker;

    public BurningViewRecipe(BurningServerRecipe recipe) {
        this.fuel = SlotContent.of(recipe.getFuel());
        this.burnTime = recipe.getBurnTime();
        this.ticker = AnimationTicker.create(ResourceLocation.withDefaultNamespace((String)("burning_tick_" + this.burnTime)), this.burnTime);
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return BurningViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindSlot(0, this.fuel);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.fuel);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of();
    }

    @Override
    public List<AnimationTicker> getAnimationTickers() {
        return List.of(this.ticker);
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int burnProgress = Math.round(this.ticker.getProgress() * 14.0f);
        Font font = Minecraft.getInstance().font;
        guiGraphics.blit(RenderType::guiTextured, BuiltInEivIntegration.WIDGETS, 19, 2 + (14 - burnProgress), 0.0f, (float)(14 - burnProgress), 14, burnProgress, 128, 128);
        MutableComponent mutableComponent = Component.literal((String)(this.burnTime + " ticks"));
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (Component)mutableComponent, 38, 9 - 9 / 2, -8355712, false);
    }
}

