/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.campfire;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.BuiltInEivIntegration;
import de.crafty.eiv.common.builtin.campfire.CampfireServerRecipe;
import de.crafty.eiv.common.builtin.campfire.CampfireViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CampfireViewRecipe
implements IEivViewRecipe {
    private final SlotContent input;
    private final SlotContent result;
    private final AnimationTicker cookingTicker;

    public CampfireViewRecipe(CampfireServerRecipe campfireCookingRecipe) {
        this.input = SlotContent.of(campfireCookingRecipe.getInput());
        this.result = SlotContent.of(campfireCookingRecipe.getResult());
        this.cookingTicker = AnimationTicker.create(ResourceLocation.withDefaultNamespace((String)"campfire_cooking_ticker"), 300);
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return CampfireViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindSlot(0, this.input);
        slotFillContext.bindSlot(1, this.result);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.input);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    public List<AnimationTicker> getAnimationTickers() {
        return List.of(this.cookingTicker);
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.CAMPFIRE), 1, 20);
        int cookingProgress = Math.round(this.cookingTicker.getProgress() * 24.0f);
        guiGraphics.blit(RenderType::guiTextured, BuiltInEivIntegration.WIDGETS, 25, 1, 14.0f, 0.0f, cookingProgress, 16, 128, 128);
    }
}

