/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.entity;

import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class EntityServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<EntityServerRecipe> TYPE = EivRecipeType.register(ResourceLocation.withDefaultNamespace((String)"entity_loot"), () -> new EntityServerRecipe(null, List.of()));
    private EntityType<?> entityType;
    private List<ItemStack> drops;

    public EntityServerRecipe(EntityType<?> entityType, List<ItemStack> drops) {
        this.entityType = entityType;
        this.drops = drops;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    @Override
    public void writeToTag(CompoundTag tag) {
        tag.putString("entity", BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).toString());
        tag.put("stacks", (Tag)EivTagUtil.writeList(this.drops, (origin, tag1) -> EivTagUtil.encodeItemStack(origin)));
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        this.entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse((String)tag.getString("entity")));
        this.drops = EivTagUtil.readList(tag, "stacks", EivTagUtil::decodeItemStack);
    }

    @Override
    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }
}

