/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.entity;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.entity.EntityServerRecipe;
import de.crafty.eiv.common.builtin.entity.EntityViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityViewRecipe
implements IEivViewRecipe {
    private final EntityType<?> entityType;
    private final List<SlotContent> drops;
    private LivingEntity previewEntity;
    private int animationTick = 0;
    private boolean hovered = false;

    public EntityViewRecipe(EntityServerRecipe serverRecipe) {
        this.entityType = serverRecipe.getEntityType();
        List<ItemStack> drops = serverRecipe.getDrops();
        ArrayList<SlotContent> dropContents = new ArrayList<SlotContent>();
        for (int i = 0; i < this.getViewType().getSlotCount(); ++i) {
            if (drops.size() > i) {
                dropContents.add(SlotContent.of(drops.get(i)));
                continue;
            }
            dropContents.add(SlotContent.of());
        }
        this.drops = dropContents;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return EntityViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        for (int i = 0; i < this.drops.size(); ++i) {
            if (i < 9) {
                slotFillContext.bindSlot(i, this.drops.get(i));
                continue;
            }
            slotFillContext.bindOptionalSlot(i, this.drops.get(i), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
        }
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of();
    }

    @Override
    public List<SlotContent> getResults() {
        return this.drops;
    }

    @Override
    public void tick() {
        if (this.hovered) {
            return;
        }
        ++this.animationTick;
        if (this.animationTick >= 360) {
            this.animationTick = 0;
        }
    }

    @Override
    public void initRecipe() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = this.getEntityType().create((Level)level, EntitySpawnReason.LOAD);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.previewEntity = livingEntity = (LivingEntity)entity;
            this.previewEntity.setYBodyRot(30.0f);
            this.previewEntity.setYHeadRot(30.0f);
        }
    }

    @Override
    public void fadeRecipe() {
        if (this.previewEntity != null) {
            this.previewEntity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Component entityName = this.entityType.getDescription();
        this.renderEntity(guiGraphics, mouseX, mouseY, partialTicks);
        this.hovered = mouseX >= 65 && mouseX <= 97 && mouseY >= 0 && mouseY <= 32;
        if (this.hovered) {
            guiGraphics.renderTooltip(screen.getFont(), (Component)Component.empty().append(entityName).withStyle(ChatFormatting.GOLD), mouseX, mouseY);
        }
    }

    private void renderEntity(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.previewEntity == null) {
            return;
        }
        float scale = 12.0f;
        AABB boundingBox = this.previewEntity.getBoundingBox();
        if (boundingBox.getYsize() * (double)scale > 26.0) {
            scale = (float)(26.0 / boundingBox.getYsize());
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(81.0f, 29.0f, 0.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)0.0f, (float)0.0f, (float)scale, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), ((float)this.animationTick + partialTicks) / 180.0f * (float)Math.PI, 0.0f), null, (LivingEntity)this.previewEntity);
        guiGraphics.pose().popPose();
    }
}

