/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.builtin.villager;

import com.mojang.blaze3d.vertex.PoseStack;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerServerRecipe;
import de.crafty.eiv.common.builtin.villager.VillagerViewType;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VillagerViewRecipe
implements IEivViewRecipe {
    private final SlotContent offer;
    private final SlotContent cost1;
    private final SlotContent cost2;
    protected VillagerServerRecipe.VillagerOffer villagerOffer;
    private Villager previewVillager = null;
    private boolean prevVillagerLookLeft;
    private boolean villagerLookLeft = false;
    private int lastHeadChange;
    private int currentTick = 0;
    private final Random random;

    public VillagerViewRecipe(VillagerServerRecipe.VillagerOffer villagerOffer) {
        this.offer = SlotContent.of(villagerOffer.offerStacks());
        this.cost1 = SlotContent.of(villagerOffer.cost1());
        this.cost2 = SlotContent.of(villagerOffer.cost2());
        this.villagerOffer = villagerOffer;
        this.random = new Random();
        if (Minecraft.getInstance().level != null) {
            this.prevVillagerLookLeft = this.villagerLookLeft = this.random.nextBoolean();
        }
    }

    @Override
    public IEivRecipeViewType getViewType() {
        return VillagerViewType.INSTANCE;
    }

    @Override
    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindDepedantSlot(0, this.offer::index, this.cost1);
        slotFillContext.bindSlot(1, this.cost2);
        slotFillContext.bindSlot(2, this.offer);
    }

    @Override
    public List<SlotContent> getIngredients() {
        return List.of(this.cost1, this.cost2);
    }

    @Override
    public List<SlotContent> getResults() {
        return List.of(this.offer);
    }

    @Override
    public void tick() {
        ++this.currentTick;
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (this.currentTick - this.lastHeadChange < 60) {
            return;
        }
        this.prevVillagerLookLeft = this.villagerLookLeft;
        this.villagerLookLeft = this.random.nextBoolean();
        this.lastHeadChange = this.currentTick;
    }

    @Override
    public void initRecipe() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        this.previewVillager = (Villager)EntityType.VILLAGER.create((Level)level, EntitySpawnReason.LOAD);
        if (this.previewVillager == null) {
            return;
        }
        this.previewVillager.setVillagerData(this.previewVillager.getVillagerData().setLevel(this.villagerOffer.professionLevel()).setType(VillagerType.PLAINS).setProfession(this.villagerOffer.profession()));
        this.previewVillager.setNoAi(true);
        this.previewVillager.setYHeadRot((this.villagerLookLeft ? -1.0f : 1.0f) * 15.0f);
        if (this.villagerOffer.requiredtype() != null) {
            this.previewVillager.setVillagerData(this.previewVillager.getVillagerData().setType(this.villagerOffer.requiredtype()));
        }
    }

    @Override
    public void fadeRecipe() {
        if (this.previewVillager != null) {
            this.previewVillager.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void renderRecipe(RecipeViewScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        VillagerProfession profession = this.villagerOffer.profession();
        String namespace = "minecraft";
        String path = profession.name();
        float scale = 0.75f;
        MutableComponent professionComp = Component.translatable((String)("entity." + namespace + ".villager." + path)).append(" - ").append((Component)Component.translatable((String)("merchant.level." + this.villagerOffer.professionLevel()))).withStyle(ChatFormatting.DARK_GRAY);
        guiGraphics.pose().pushPose();
        PoseStack poseStack = guiGraphics.pose();
        Objects.requireNonNull(font);
        poseStack.translate(0.0f, (float)(-9) * scale, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawString(font, (Component)professionComp, 0, 0, -1, false);
        guiGraphics.pose().popPose();
        if (this.villagerLookLeft != this.prevVillagerLookLeft && (float)(this.currentTick - this.lastHeadChange) <= 5.0f) {
            float pastTime = (float)(this.currentTick - this.lastHeadChange) + partialTicks;
            float headRotationProgress = pastTime / 5.0f;
            this.previewVillager.setYHeadRot((this.villagerLookLeft ? -1.0f : 1.0f) * (15.0f * headRotationProgress));
        }
        this.renderVillager(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.villagerOffer.requiredtype() == null) {
            return;
        }
        if (mouseX >= 0 && mouseX <= 24 && mouseY >= 0 && mouseY <= 36) {
            ResourceLocation typeLocation = ResourceLocation.withDefaultNamespace((String)this.villagerOffer.requiredtype().toString());
            MutableComponent typeComponent = Component.translatable((String)("view.eiv.type.trading." + typeLocation.getNamespace() + "." + typeLocation.getPath())).withStyle(ChatFormatting.GOLD);
            guiGraphics.renderTooltip(font, (Component)typeComponent, mouseX, mouseY);
        }
    }

    private void renderVillager(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.previewVillager == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(12.0f, 34.0f, 0.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)0.0f, (float)0.0f, (float)15.0f, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), 0.0f, 0.0f), null, (LivingEntity)this.previewVillager);
        guiGraphics.pose().popPose();
    }
}

