/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.crafty.eiv.common.CommonEIV;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public abstract class AbstractEivConfig {
    private final String fileName;
    private JsonObject data;

    protected AbstractEivConfig(String fileName) {
        this.fileName = fileName;
        this.data = new JsonObject();
    }

    public JsonObject data() {
        return this.data;
    }

    protected abstract void loadData();

    protected abstract void saveData();

    public void load() {
        try {
            File file = new File("config/eiv/" + this.fileName + ".json");
            if (!file.exists()) {
                CommonEIV.LOGGER.info("Config file: {}.json not present, creating a new one...", (Object)this.fileName);
                this.save();
                return;
            }
            String fileContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            this.data = (JsonObject)new GsonBuilder().create().fromJson(fileContent, JsonObject.class);
            CommonEIV.LOGGER.info("Loading config file: {}.json", (Object)this.fileName);
            this.loadData();
        }
        catch (Exception e) {
            CommonEIV.LOGGER.error("Failed to load config file: {}.json", (Object)this.fileName, (Object)e);
        }
    }

    public void save() {
        try {
            this.saveData();
            File saveFile = new File("config/eiv/" + this.fileName + ".json");
            if (saveFile.createNewFile()) {
                CommonEIV.LOGGER.info("Created new config file: {}.json", (Object)this.fileName);
            }
            String encoded = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.data);
            FileUtils.writeStringToFile((File)saveFile, (String)encoded, (Charset)StandardCharsets.UTF_8);
            CommonEIV.LOGGER.info("Saved config file: {}.json", (Object)this.fileName);
        }
        catch (Exception e) {
            CommonEIV.LOGGER.error("Failed to save config file: {}.json", (Object)this.fileName, (Object)e);
        }
    }
}

