/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.extra;

import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.item.FluidItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidStack {
    public static final int AMOUNT_FULL = 1000;
    public static final FluidStack EMPTY = new FluidStack(Fluids.EMPTY, 0);
    private final Fluid fluid;
    private int amount;

    public FluidStack(Fluid fluid) {
        this.fluid = fluid;
        this.amount = 1000;
    }

    public FluidStack(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        return this.amount;
    }

    public static FluidStack fromItemStack(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof FluidItem)) {
            return EMPTY;
        }
        FluidItem fluidItem = (FluidItem)item;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int amount = 1000;
        if (tag.contains("fluidAmount")) {
            amount = tag.getInt("fluidAmount");
        }
        return new FluidStack(fluidItem.getFluid(), amount);
    }

    public ItemStack createItemStack() {
        Item item = ItemViewRecipes.INSTANCE.itemForFluid(this.fluid);
        if (item == Items.AIR) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putInt("fluidAmount", this.amount);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
        return stack;
    }
}

