/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.common.network;

import de.crafty.eiv.common.network.payload.ServerboundRequestEivUpdate;
import de.crafty.eiv.common.network.payload.mode.ServerboundPickCheatmodeItemPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.common.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.common.network.payload.stack.ClientboundStartStackSensitivesPayload;
import de.crafty.eiv.common.network.payload.transfer.ClientboundUpdateTransferCachePayload;
import de.crafty.eiv.common.network.payload.transfer.ServerboundTransferPayload;
import de.crafty.eiv.common.recipe.ClientRecipeManager;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import de.crafty.eiv.common.recipe.cache.LowEndRecipeCache;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class EivNetworkManager {
    public static final EivNetworkManager INSTANCE = new EivNetworkManager().registerPayloads();
    private final HashMap<ResourceLocation, CustomPacketPayload.TypeAndCodec<?, ?>> clientbound = new HashMap();
    private final HashMap<ResourceLocation, CustomPacketPayload.TypeAndCodec<?, ?>> serverbound = new HashMap();
    private final HashMap<ResourceLocation, PayloadHandler<ClientContext, ? extends CustomPacketPayload>> clientPayloadHandlers = new HashMap();
    private final HashMap<ResourceLocation, PayloadHandler<ServerContext, ? extends CustomPacketPayload>> serverPayloadHandlers = new HashMap();

    private EivNetworkManager() {
    }

    private <B extends FriendlyByteBuf, T extends CustomPacketPayload> void registerClientbound(CustomPacketPayload.Type<T> type, StreamCodec<B, T> codec, PayloadHandler<ClientContext, T> clientHandler) {
        this.clientbound.put(type.id(), new CustomPacketPayload.TypeAndCodec(type, codec));
        this.clientPayloadHandlers.put(type.id(), clientHandler);
    }

    private <B extends FriendlyByteBuf, T extends CustomPacketPayload> void registerServerbound(CustomPacketPayload.Type<T> type, StreamCodec<B, T> codec, PayloadHandler<ServerContext, T> serverHandler) {
        this.serverbound.put(type.id(), new CustomPacketPayload.TypeAndCodec(type, codec));
        this.serverPayloadHandlers.put(type.id(), serverHandler);
    }

    public HashMap<ResourceLocation, CustomPacketPayload.TypeAndCodec<?, ?>> getClientbound() {
        return this.clientbound;
    }

    public HashMap<ResourceLocation, CustomPacketPayload.TypeAndCodec<?, ?>> getServerbound() {
        return this.serverbound;
    }

    public HashMap<ResourceLocation, PayloadHandler<ClientContext, ? extends CustomPacketPayload>> clientPayloadHandlers() {
        return this.clientPayloadHandlers;
    }

    public HashMap<ResourceLocation, PayloadHandler<ServerContext, ? extends CustomPacketPayload>> serverPayloadHandlers() {
        return this.serverPayloadHandlers;
    }

    public <T extends CustomPacketPayload> T castPayload(CustomPacketPayload payload) {
        return (T)payload;
    }

    public void sendPacketToServer(CustomPacketPayload payload) {
        if (Minecraft.getInstance().getConnection() != null) {
            Minecraft.getInstance().getConnection().send((Packet)new ServerboundCustomPayloadPacket(payload));
        }
    }

    public void sendPacket(ServerPlayer player, CustomPacketPayload payload) {
        player.connection.send((Packet)new ClientboundCustomPayloadPacket(payload));
    }

    public EivNetworkManager registerPayloads() {
        this.registerServerbound(ServerboundRequestEivUpdate.TYPE, ServerboundRequestEivUpdate.STREAM_CODEC, (context, payload) -> {
            ServerRecipeManager.INSTANCE.informAboutStackSensitives();
            ServerRecipeManager.INSTANCE.informAboutRecipes(context.sender());
        });
        this.registerClientbound(ClientboundStartStackSensitivesPayload.TYPE, ClientboundStartStackSensitivesPayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveStartReceived(payload.amount()));
        this.registerClientbound(ClientboundStackSensitivePayload.TYPE, ClientboundStackSensitivePayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveReceived(payload.stackSensitive()));
        this.registerClientbound(ClientboundFinishStackSensitivesPayload.TYPE, ClientboundFinishStackSensitivesPayload.STREAM_CODEC, (context, payload) -> LowEndRecipeCache.INSTANCE.stackSensitiveEndReceived());
        this.registerClientbound(ClientboundStartUpdatesPayload.TYPE, ClientboundStartUpdatesPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(ClientRecipeManager.INSTANCE::startUpdate));
        this.registerClientbound(ClientboundFinishUpdatesPayload.TYPE, ClientboundFinishUpdatesPayload.STREAM_CODEC, (context, payload) -> {
            ClientRecipeManager.INSTANCE.queueTask(ClientRecipeManager.INSTANCE::processRecipes);
            ClientRecipeManager.INSTANCE.runTasks();
        });
        this.registerClientbound(ClientboundCacheStartPayload.TYPE, ClientboundCacheStartPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.cacheStartReceived(payload.types())));
        this.registerClientbound(ClientboundTypeUpdateStartPayload.TYPE, ClientboundTypeUpdateStartPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.startCaching(payload.recipeType(), payload.amount())));
        this.registerClientbound(ClientboundTypeUpdatePayload.TYPE, ClientboundTypeUpdatePayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.cacheModRecipe(payload.entry())));
        this.registerClientbound(ClientboundTypeUpdateEndPayload.TYPE, ClientboundTypeUpdateEndPayload.STREAM_CODEC, (context, payload) -> ClientRecipeManager.INSTANCE.queueTask(() -> LowEndRecipeCache.INSTANCE.endCaching(payload.recipeType())));
        this.registerServerbound(ServerboundTransferPayload.TYPE, ServerboundTransferPayload.STREAM_CODEC, (context, payload) -> ServerRecipeManager.INSTANCE.performRecipeTransfer(context.sender(), payload.transferMap(), payload.usedPlayerSlots()));
        this.registerClientbound(ClientboundUpdateTransferCachePayload.TYPE, ClientboundUpdateTransferCachePayload.STREAM_CODEC, (context, payload) -> {
            Screen patt0$temp = context.client.screen;
            if (patt0$temp instanceof RecipeViewScreen) {
                RecipeViewScreen viewScreen = (RecipeViewScreen)patt0$temp;
                ((RecipeViewMenu)viewScreen.getMenu()).updateTransferCache();
            }
        });
        this.registerServerbound(ServerboundPickCheatmodeItemPayload.TYPE, ServerboundPickCheatmodeItemPayload.STREAM_CODEC, (context, payload) -> {
            if (context.sender().hasPermissions(3)) {
                context.sender().sendSystemMessage((Component)Component.literal((String)"Cheated x").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(payload.amount())).withStyle(ChatFormatting.GOLD)).append(" ").append((Component)payload.stack().getDisplayName().copy()));
                context.sender().addItem(payload.stack().copyWithCount(payload.amount()));
                context.sender().serverLevel().playSound(null, context.sender().getX(), context.sender().getY(), context.sender().getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((context.sender().getRandom().nextFloat() - context.sender().getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else {
                context.sender().sendSystemMessage((Component)Component.translatable((String)"cheatmode.eiv.denied").withStyle(ChatFormatting.RED));
            }
        });
        return this;
    }

    public static interface PayloadHandler<S extends Context, T extends CustomPacketPayload> {
        public void handle(S var1, T var2);
    }

    public record ServerContext(MinecraftServer server, ServerPlayer sender) implements Context
    {
    }

    public record ClientContext(Minecraft client) implements Context
    {
    }

    public static interface Context {
    }
}

